package com.js.api.jspay.service.chinapnr;


import com.js.common.model.req.ChinaPNREnterpriseOpenAccountReq;
import com.js.common.model.req.ChinaPNRPersonalOpenAccountReq;
import com.js.common.model.req.ChinaPNRQueryOpenAccountReq;
import com.js.common.model.vo.common.ResponseMessage;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.Map;

/**
 * @Description: 汇付国际业务代发
 * @Author: zhouyongsheng
 * @Create: 2019-06-10
 **/
@Path("chinaPNRPayOpenAccount")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ChinaPNRPayOpenAccountService {

    /**
     * 个人开户
     * @param chinaPNROpenAccountReq
     * @return
     */
    @GET
    @Path("personalOpenAccount")
    ResponseMessage personalOpenAccount(ChinaPNRPersonalOpenAccountReq chinaPNROpenAccountReq);

    /**
     * 企业开户
     * @param chinaPNROpenAccountReq
     * @return
     */
    @GET
    @Path("enterpriseOpenAccount")
    ResponseMessage enterpriseOpenAccount(ChinaPNREnterpriseOpenAccountReq chinaPNROpenAccountReq);

    /**
     * 个人开户信息修改
     * @param chinaPNROpenAccountReq
     * @return
     */
    @GET
    @Path("personalUpdateOpenAccount")
    ResponseMessage personalUpdateOpenAccount(ChinaPNRPersonalOpenAccountReq chinaPNROpenAccountReq);

    /**
     * 企业开户信息修改
     * @param chinaPNROpenAccountReq
     * @return
     */
    @GET
    @Path("enterpriseUpdateOpenAccount")
    ResponseMessage enterpriseUpdateOpenAccount(ChinaPNREnterpriseOpenAccountReq chinaPNROpenAccountReq);

    /**
     * 个人开户信息查询
     * @param chinaPNRQueryOpenAccountReq
     * @return
     */
    @GET
    @Path("personalQueryOpenAccount")
    ResponseMessage personalQueryOpenAccount(ChinaPNRQueryOpenAccountReq chinaPNRQueryOpenAccountReq);

    /**
     * 企业开户信息查询
     * @param chinaPNRQueryOpenAccountReq
     * @return
     */
    @GET
    @Path("enterpriseQueryOpenAccount")
    ResponseMessage enterpriseQueryOpenAccount(ChinaPNRQueryOpenAccountReq chinaPNRQueryOpenAccountReq);

    /**
     * 企业开户信息回调
     * @param map
     * @return
     */
    @GET
    @Path("enterpriseCallbackOpenAccount")
    ResponseMessage enterpriseCallbackOpenAccount(Map<String, String> map);

    /**
     * 个人开户信息回调
     * @param map
     * @return
     */
    @GET
    @Path("personalCallbackOpenAccount")
    ResponseMessage personalCallbackOpenAccount(Map<String, String> map);


    /**
     * @Author liuh
     * @Description 开户信息查询（查询js内部）
     * @Date 2019/6/30
     **/
    @GET
    @Path("personalQueryOpenAccount")
    ResponseMessage queryOpenAccount(String kycNautralId,String result);
}
