package com.js.api.jspay.service;

import com.js.common.enums.RegisterType;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;

import javax.validation.Valid;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.List;
import java.util.Map;

/**
 * @Description: 与寻汇询价交互接口
 * @Author: liuh
 * @Create: 2019-05-29
 **/
@Path("apiSunRateTradePrice")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiSunrateTradePriceService {
    /**
     * @Author liuh
     * @Description 合作方 -> 寻汇 询价 接口
     * @Date 2019/5/29
     **/
    @POST
    @Path("xhTradeQueryPrice")
    ResponseMessage xhTradeQueryPrice(@Valid SunrateTradePriceReq sunrateTradePriceReq);

    /**
     * @Author liuh
     * @Description 查询当前用户下的站点
     * @Date 2019/6/5
     **/
    @GET
    @Path("findSiteByNaturalId")
    List<Map> findSiteByNaturalId(String kycNaturalId);

    /**
     * @Author liuh
     * @Description 获取orgCode
     * @Date 2019/6/5
     **/
    @GET
    @Path("findOrgCode")
    String findOrgCode(String kycNaturalId, RegisterType registerType);

    Object findCertiInfo(String kycNaturalId,RegisterType registerType);
}
