package com.js.api.jspay.service;

import com.js.common.model.req.KycShowStoreReq;
import com.js.common.model.req.KycStoreEditReq;
import com.js.common.model.req.KycStoreReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.KycStoreVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 申请境外虚拟户-店铺记录服务接口
 * @Author: liuh
 * @Create: 2019-05-21
 **/
@Path("apiKycStore")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiKycStoreService {

    /**
     * @Author liuh
     * @Description 申请境外虚拟户-添加店铺
     * @Date 2019/5/21
     **/
    @POST
    @Path("kycSore")
    @Transactional
    ResponseMessage addStore(KycStoreReq kycStoreReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description js店铺列表
     * @Date 2019/5/23
     **/
    @GET
    @Path("storeList")
    ResponseMessage storeList(KycShowStoreReq kycShowStoreReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 获取各个站点申请账户数量
     * @Date 2019/5/29
     **/
    @GET
    @Path("findApplyCountNum")
    ResponseMessage findApplyCountNum(String browserIP,KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 根据主键ID查询kyc店铺信息
     * @Date 2019/6/19
     **/
    @GET
    @Path("findKycStoreByPrimaryKey")
    KycStoreVO findKycStoreByPrimaryKey(String kycStoreId, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 编辑保存店铺信息
     * @Date 2019/6/25
     **/
    @PUT
    @Path("editStore")
    ResponseMessage editStore(KycStoreEditReq kycStoreEditReq, KycNaturalVO kycNaturalVO);
}
