package com.js.api.jspay.service;

import com.js.common.enums.CertiStatusEnum;
import com.js.common.model.req.ChPwdReq;
import com.js.common.model.req.KycNaturalListReq;
import com.js.common.model.req.KycNaturalReq;
import com.js.common.model.req.RegiserKycNaturalReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.KycPasswordVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

/**
 * @ClassName: ApiKycNaturalService
 * @Description: kycNatural协约服务接口
 * @Author: yjzhao
 * @Create: 2019-05-16  10:14
 **/
@Path("apiKycNatural")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiKycNaturalService {

    /**
     * @Author yjzhao
     * @Description email是否已被使用
     * @Date 2019/5/16 10:09
     * @Param email 参数email
     * @return com.js.common.model.vo.common.ResponseMessage
     **/
    @GET
    @Path("verifyEmailExists")
    Integer verifyEmailExists(String email);

    /**
     * @Author yjzhao
     * @Description mobile是否已被使用
     * @Date 2019/5/16 10:10
     * @Param [mobile]
     * @return com.js.common.model.vo.common.ResponseMessage
     **/
    @GET
    @Path("verifyMobileExists")
    Integer verifyMobileExists(String phoneNo);

    /**
     * @Author yjzhao
     * @Description 注册用户
     * @Date 2019/5/16 10:11
     * @Param [regiserKycNatural, request, response]
     * @return com.js.common.model.vo.common.ResponseMessage
     **/
    @POST
    @Path("register")
    @Transactional
    ResponseMessage register(RegiserKycNaturalReq regiserKycNaturalReq);

    /**
     * @Author yjzhao
     * @Description 根据手机号获取Kyc账户相关信息
     * @Date 2019/5/21 14:29
     * @Param [phoneNo]
     * @return com.js.common.model.vo.KycNaturalVO
     **/
    @GET
    @Path("findKycNaturalVOByPhoneNo")
    KycNaturalVO findKycNaturalVOByPhoneNo(String phoneNo);

    /**
     * @Author yjzhao
     * @Description 根据邮箱获取Kyc账户相关信息
     * @Date 2019/5/21 14:52
     * @Param [email]
     * @return java.util.Optional<com.js.common.model.vo.KycNaturalVO>
     **/
    @GET
    @Path("findKycNaturalVOByEmail")
    KycNaturalVO findKycNaturalVOByEmail(String email);

    /**
     * @Author yjzhao
     * @Description 根据手机号获取Kyc账号密码
     * @Date 2019/5/21 14:52
     * @Param [email]
     * @return java.util.Optional<com.js.common.model.vo.KycNaturalVO>
     **/
    @GET
    @Path("findKycPwdVOByPhoneNo")
    KycPasswordVO findKycPwdVOByPhoneNo(String phoneNo);

    /**
     * @Author yjzhao
     * @Description 根据邮箱获取Kyc账号密码
     * @Date 2019/5/21 14:52
     * @Param [email]
     * @return java.util.Optional<com.js.common.model.vo.KycNaturalVO>
     **/
    @GET
    @Path("findKycPwdVOByEmail")
    KycPasswordVO findKycPwdVOByEmail(String phoneNo);

    /**
     * @Author yjzhao
     * @Description 校验密码并根据登陆账号获取用户
     * @Date 2019/5/21 16:07
     * @Param [phoneNo, password]
     * @return com.js.common.model.vo.common.ResponseMessage
     **/
    ResponseMessage findKycNaturalVOForLogin(String phoneNo, String password);

    /**
     * @Author yjzhao
     * @Description 更改密码
     * @Date 2019/5/23 15:57
     * @Param [chPwdReq]
     * @return com.js.common.model.vo.common.ResponseMessage
     **/
    @POST
    @Path("changePwd")
    ResponseMessage changePwd(ChPwdReq chPwdReq);

    /**
     * @Author yjzhao
     * @Description 更改账户信息
     * @Date 2019/5/24 21:45
     * @Param [kycNaturalReq]
     * @return int
     **/
    @POST
    @Path("updateKycNatural")
    int updateKycNatural(KycNaturalReq kycNaturalReq);

    /**
     * 获取用户 kyc 列表 （js-manage）
     *
     * @autheor liutianyu
     */
    @GET
    @Path("getKycNaturalList")
    String getKycNaturalList(KycNaturalListReq kycNaturalListReq);

    /**
     * 获取用户 kyc 详情 （js-manage）
     *
     * @autheor liutianyu
     */
    @GET
    @Path("getKycNaturaById")
    KycNaturalVO getKycNaturaById(String id);

    /**
     * 删除用户 kyc 详情 （js-manage）
     *
     * @autheor liutianyu
     */
    @GET
    @Path("deleteKycNaturaById")
    int deleteKycNaturaById(String id);

}
