package com.js.api.jspay.service;

import com.js.common.model.req.CertiMainLandCompanyReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 大陆企业操作服务接口
 * @Author: liuh
 * @Create: 2019-05-21
 **/
@Path("apiKycCertiMainLandCompany")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiKycCertiMainLandCompanyService {

    /**
     * @Author liuh
     * @Description 实名认证-大陆企业-保存
     * @Date 2019/5/21
     **/
    @POST
    @Path("certiMainLandCompany")
    @Transactional
    ResponseMessage certiMainLandCompanyAdd(CertiMainLandCompanyReq certiMainLandCompanyReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @param unifiedSocialCreditCode-统一社会信用代码
     *@Description 校验大陆企业是否存在
     * @Date 2019/6/5
     */
    @GET
    @Path("verifyCertiMainLandComapnyExists")
    boolean verifyCertiMainLandComapnyExists(String unifiedSocialCreditCode);
}
