package com.js.api.jspay.service;

import com.js.common.model.req.JsPaySunrateBankTradeInReq;
import com.js.common.model.req.JsPaySunrateBankTradeOutReq;
import com.js.common.model.req.JsPaySunrateTradeMarketOrderReq;
import com.js.common.model.req.JsTradeListReq;
import com.js.common.model.vo.JsPaySunrateTradeLockPriceVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 锁汇成交接口
 * @Author: liuh
 * @Create: 2019-06-11
 **/
@Path("apiJsPaySunrateTradeLockPrice")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiJsPaySunrateTradeLockPriceService {
    /**
     * @author:liuh
     * @Descripiton: 8.2锁汇成交（合作方 -> 寻汇）
     * @Date 2019/06/11
     */
    @POST
    @Path("queryPriceTradeOrder")
    ResponseMessage queryPriceTradeOrder(JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq);

    /**
     * @Author liuh
     * @Description 提现列表/还款列表
     * @Date 2019/6/14
     **/
    @GET
    @Path("withdrawAndRefundList")
    ResponseMessage withdrawAndRefundList(JsTradeListReq jsTradeListReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 提现详情/还款详情
     * @Date 2019/6/15
     **/
    @GET
    @Path("withdrawAndRefundDetail")
    ResponseMessage withdrawAndRefundDetail(String tradeId);

    /**
     * @Author liuh
     * @Description 根据出账信息查找提交的锁汇交易信息
     * @Date 2019/6/15
     **/
    @GET
    @Path("findTradeLockInfo")
    JsPaySunrateTradeLockPriceVO findTradeLockInfo(JsPaySunrateBankTradeOutReq jsPaySunrateBankTradeOutReq);

    /**
     * @author:liuh
     * @Descripiton: 8.3市价锁汇成交（合作方 → 寻汇）
     * @Date 2019/06/28
     */
    @POST
    @Path("tradeMarketOrder")
    ResponseMessage tradeMarketOrder(JsPaySunrateTradeMarketOrderReq jsPaySunrateTradeMarketOrderReq,String kycNaturalId,String kycSunrateStoreId,String kycSunrateBankId);
}
