package com.js.loan.utils;

import com.js.common.enums.ResultEnum;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;

import java.util.function.Function;

/**
 * 包装通用的响应对象。
 */
public class ResponseMessageWraper {

    ResponseMessage responseMessage;

    public static ResponseMessageWraper wrap(ResponseMessage responseMessage) {
        return new ResponseMessageWraper(responseMessage);
    }

    private ResponseMessageWraper(ResponseMessage responseMessage) {
        this.responseMessage = responseMessage;
    }

    /**
     * responseMessage 链式凋用
     * @param execution 处理逻辑，返回值如果不是 responseMessage 对象或响影结果为失败。则后的面的链式调用将不会执行。
     * @param <T> responseMessage.data 中需要转换成的类型
     * @param <R> 处理逻辑终后返回的类型
     * @return
     */
    public <T, R> ResponseMessageWraper andThen(Function<T, R> execution) {
        if (responseMessage.isSuccess()) {
            R result = execution.apply((T) responseMessage.getData());
            if (result instanceof ResponseMessage) {
                return new ResponseMessageWraper((ResponseMessage) result);
            } else {
                return new ResponseMessageWraper(ResultUtil.error(result, ResultEnum.ERROR));
            }
        } else {
            return this;
        }
    }

    public ResponseMessage unwrap() {
        return responseMessage;
    }
}
