package com.js.loan.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {

    public static String getNewDate(){
        SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");
        String timeStr = sdf.format(new Date());
        return timeStr;
    }

    public static String getNewyyyyMMddHHmmss(){
        SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeStr = sdf.format(new Date());
        return timeStr;
    }

    public static String getNewDateCN(){
        SimpleDateFormat sdf=new SimpleDateFormat("yyyy年MM月dd日");
        String timeStr = sdf.format(new Date());
        return timeStr;
    }

    public static String getNewDateyyyyMMddHHmmss(){
        SimpleDateFormat sdf=new SimpleDateFormat("yyyyMMddHHmmss");
        String timeStr = sdf.format(new Date());
        return timeStr;
    }

    public static String DateToStr(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String str = format.format(date);
        return str;
    }
    public static Date StrToDate(String str) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = format.parse(str);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Date getDateEndDay(Date sDate){
        Calendar c = Calendar.getInstance();
        c.setTime(sDate);
        c.add(Calendar.DAY_OF_MONTH, 1);
        //利用Calendar 实现 Date日期+1天
        sDate = c.getTime();
        return sDate;
    }

    public static Date getDateEndDayStr(String str){
        Calendar c = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date sDate = null;
        try {
            sDate = format.parse(str);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        c.setTime(sDate);
        c.add(Calendar.DAY_OF_MONTH, 1);
        //利用Calendar 实现 Date日期+1天
        sDate = c.getTime();
        return sDate;
    }

    /**
     * 计算 day 天后的时间
     *
     * @param date
     * @param day
     * @return
     */
    public static Date addDay(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DAY_OF_MONTH, day);
        return calendar.getTime();
    }

    public static String getLoanDate(String times){
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String sd = sdf.format(new Date(Long.parseLong(times))); // 时间戳转换日期
        return sd;
    }

    public static void main(String [] args){

        System.out.println(getDateEndDayStr("2019-08-18"));
    }

}
