package com.js.loan.service.impl;

import cn.hutool.core.util.IdUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.js.api.jsloan.service.ApiJsLoanRiskinfoService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsLoanRiskInfoReq;
import com.js.common.model.resp.JsLoanRiskVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsLoanRiskInfoMapper;
import com.js.dal.dao.model.JsLoanApplyInfo;
import com.js.dal.dao.model.JsLoanRiskInfo;
import com.js.loan.mq.RabbitMQJsLoanSender;
import com.js.loan.utils.DateUtils;
import com.js.loan.utils.IdCard;
import com.js.loan.utils.LoanConfigureInfo;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.apache.ibatis.session.RowBounds;
import org.apache.poi.util.StringUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import tk.mybatis.mapper.entity.Example;

import java.util.*;

@Slf4j
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
public class ApiJsLoanRiskinfoServiceImpl implements ApiJsLoanRiskinfoService {

    @Autowired
    private JsLoanRiskInfoMapper jsLoanRiskInfoMapper;

    @Autowired
    private RabbitMQJsLoanSender rabbitMQJsLoanSender;

    @Autowired
    private LoanConfigureInfo loanConfigureInfo;

    /**
     * 准入
     * @param req
     * @return
     */
    @Override
    public ResponseMessage loanRisk(JsLoanRiskInfoReq req) {
        log.info("准入信息推送小贷 执行 ..  = " + req);

        //获取该用户的性别
        req.setSex(IdCard.getGenderByIdCard(req.getBorrowerIdcard()));
        //生成准入编号
        req.setRiskNo("YFJSZR" + DateUtils.getNewDateyyyyMMddHHmmss());
        //判断该用户是否已经申请准入信息
        JsLoanRiskInfo jsLoanRiskInfoQuery = new JsLoanRiskInfo();
        jsLoanRiskInfoQuery.setKycNaturalId(req.getKycNaturalId());
        jsLoanRiskInfoQuery.setDelFlag(false);
        jsLoanRiskInfoQuery = jsLoanRiskInfoMapper.selectOne(jsLoanRiskInfoQuery);
        if(null != jsLoanRiskInfoQuery){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"该KEY已经申请了准入信息，不可重新发起");
        }
        //插入数据库
        JsLoanRiskInfo jsLoanRiskInfo = new JsLoanRiskInfo();
        BeanUtils.copyProperties(req,jsLoanRiskInfo);
        jsLoanRiskInfo.setId(IdUtil.simpleUUID());
        jsLoanRiskInfo.setStatus(CommonConstant.LOAN_RISK_STATUS_VERIFY);
        jsLoanRiskInfo.setBorrowerIdcardBack(req.getBorrowerIdCardBack());
        jsLoanRiskInfo.setBorrowerIdcardFront(req.getBorrowerIdCardFront());
        jsLoanRiskInfo.setBorrowerIdcardHold(req.getBorrowerIdCardHold());
        jsLoanRiskInfo.setEffectiveStartTime(DateUtils.StrToDate(req.getEffectiveStartTime()));
        jsLoanRiskInfo.setEffectiveEndTime(DateUtils.StrToDate(req.getEffectiveEndTime()));
        jsLoanRiskInfo.setGuaranteeIdcardStartTime(DateUtils.StrToDate(req.getGuaranteeIdcardStartTime()));
        jsLoanRiskInfo.setGuaranteeIdcardEndTime(DateUtils.StrToDate(req.getGuaranteeIdcardEndTime()));
        jsLoanRiskInfo.setCreateDts(new Date());
        jsLoanRiskInfo.setUpdateDts(new Date());
        jsLoanRiskInfo.setDelFlag(false);
        jsLoanRiskInfoMapper.insertSelective(jsLoanRiskInfo);
        //推送准入信息
        Map<String,Object> map=new HashMap();
        map.put("type",CommonConstant.CUSTOMER_RISK); //10客户准入 20准入修改  30借款 40电子签章
        map.put("data",req);
        JSONArray array=JSONArray.fromObject(map);
        //推送小贷
        rabbitMQJsLoanSender.loanRiskSender(array.toString());


        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage queryAccess(String kycNaturalId,int pageNum,int pageSize) {

        if(pageNum<=0){
             pageNum = 1;
        }
        if(pageSize < 0 || pageSize > 100){
            pageSize = 10;
        }
        JsLoanRiskInfo jsLoanRiskInfo = new JsLoanRiskInfo();
        jsLoanRiskInfo.setKycNaturalId(kycNaturalId);
        PageHelper.startPage(pageNum,pageSize);
        List<JsLoanRiskInfo> jsLoanRiskInfos = jsLoanRiskInfoMapper.select(jsLoanRiskInfo);

        List<JsLoanRiskVO> resList = new ArrayList();
        for(JsLoanRiskInfo entity : jsLoanRiskInfos){
            JsLoanRiskVO jsLoanRiskVO = new JsLoanRiskVO();
            jsLoanRiskVO.setApplyTime(entity.getCreateDts());
            if(entity.getStatus().equals(CommonConstant.LOAN_RISK_STATUS_ADOPT)){ //审核通过
                jsLoanRiskVO.setApplyType("2"); //1.授信，2.借款
            }else{
                jsLoanRiskVO.setApplyType("1");
            }
            jsLoanRiskVO.setRiskNo(entity.getRiskNo());
            jsLoanRiskVO.setApplyStatus(entity.getStatus());
            jsLoanRiskVO.setKycNaturalId(entity.getKycNaturalId());
            jsLoanRiskVO.setProduct(loanConfigureInfo.getProductName());
            resList.add(jsLoanRiskVO);
        }
        PageInfo<JsLoanRiskVO> storeLoanListVOPageInfo = new PageInfo<>(resList);
        return ResultUtil.success(storeLoanListVOPageInfo);
    }

    @Override
    public ResponseMessage queryAccessDetails(String riskNo,String kycNaturalId) {
        JsLoanRiskInfo jsLoanRiskInfo = new JsLoanRiskInfo();
        jsLoanRiskInfo.setRiskNo(riskNo);
        jsLoanRiskInfo.setKycNaturalId(kycNaturalId);
        jsLoanRiskInfo = jsLoanRiskInfoMapper.selectOne(jsLoanRiskInfo);
        if(jsLoanRiskInfo == null){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"未查询到准入信息");
        }
        Map<String,Object> resMap = new HashMap<>();
        resMap.put("riskNo",jsLoanRiskInfo.getRiskNo());
        resMap.put("name",jsLoanRiskInfo.getBorrowerName());
        resMap.put("mobile",jsLoanRiskInfo.getBorrowerPhone());
        resMap.put("cardId",jsLoanRiskInfo.getBorrowerIdcard());
        resMap.put("email",jsLoanRiskInfo.getBorrowerEmail());
        resMap.put("applyStatus",jsLoanRiskInfo.getStatus());
        return ResultUtil.success(resMap);
    }

    @Override
    public ResponseMessage queryLoanRisk(String kycNaturalId) {
        //判断该用户是否已经申请准入信息
        JsLoanRiskInfo jsLoanRiskInfoQuery = new JsLoanRiskInfo();
        jsLoanRiskInfoQuery.setKycNaturalId(kycNaturalId);
        jsLoanRiskInfoQuery.setDelFlag(false);
        jsLoanRiskInfoQuery = jsLoanRiskInfoMapper.selectOne(jsLoanRiskInfoQuery);
        if(null == jsLoanRiskInfoQuery){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"未查询到该KYC下的准入信息");
        }
        return ResultUtil.success(jsLoanRiskInfoQuery);
    }

    @Override
    public ResponseMessage updateLoanRisk(JsLoanRiskInfoReq req) {

        //判断是否为空
        if(StringUtils.isEmpty(req.getRiskNo())){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"要修改的准入编号riskNo不能为空");
        }
        //判断该用户是否已经申请准入信息
        JsLoanRiskInfo jsLoanRiskInfo = new JsLoanRiskInfo();
        jsLoanRiskInfo.setKycNaturalId(req.getKycNaturalId());
        jsLoanRiskInfo.setRiskNo(req.getRiskNo());
        jsLoanRiskInfo.setDelFlag(false);
        jsLoanRiskInfo = jsLoanRiskInfoMapper.selectOne(jsLoanRiskInfo);
        if(null == jsLoanRiskInfo){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"未查询到该KYC下的准入信息");
        }
        if(!jsLoanRiskInfo.getStatus().equals(CommonConstant.LOAN_RISK_STATUS_REPULSE)){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"准入信息只能在驳回的情况进行重新提交审核");
        }
        BeanUtils.copyProperties(req,jsLoanRiskInfo);
        jsLoanRiskInfo.setUpdateDts(new Date());
        jsLoanRiskInfo.setStatus(CommonConstant.LOAN_RISK_STATUS_VERIFY);
        jsLoanRiskInfo.setUpdateDts(new Date());
        jsLoanRiskInfo.setUpdateId(req.getKycNaturalId());

        Example example=new Example(JsLoanRiskInfo.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("kycNaturalId",req.getKycNaturalId());
        criteria.andEqualTo("riskNo",req.getRiskNo());
        criteria.andEqualTo("status",CommonConstant.LOAN_RISK_STATUS_REPULSE);
        int count = jsLoanRiskInfoMapper.updateByExampleSelective(jsLoanRiskInfo,example);
        if(count < 1){
            log.info("修改准入信息数据库操作失败 kyc:{},riskNo:{}",req.getRiskNo(),req.getKycNaturalId());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"修改准入信息数据库操作失败");
        }
        //推送准入信息
        Map<String,Object> map=new HashMap();
        map.put("type",CommonConstant.CUSTOMER_RISK_UPDATE); //10客户准入 20准入修改  30借款 40电子签章
        map.put("data",req);
        log.info("推送修改准入信息MQ req:{}",req);
        JSONArray array=JSONArray.fromObject(map);
        //推送小贷
        rabbitMQJsLoanSender.loanRiskSender(array.toString());
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

}







