package com.js.loan.mq;

import com.js.api.jsloan.service.JsTradeService;
import com.js.common.constant.CommonConstant;
import com.js.common.enums.TradeSubTypeEnum;
import com.js.common.model.req.JsTradeReq;
import com.js.dal.dao.mapper.JsLoanApplyInfoMapper;
import com.js.dal.dao.mapper.JsLoanRiskInfoMapper;
import com.js.dal.dao.model.JsLoanApplyInfo;
import com.js.dal.dao.model.JsLoanRiskInfo;
import com.js.loan.utils.DateUtils;
import com.js.loan.utils.LoanConfigureInfo;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;
import tk.mybatis.mapper.entity.Example;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

/**
 * @Author yjzhao
 * @Description 监听 mq 准入贷款信息状态信息接收
 * @Date 2019/3/1 14:51
 * @Param
 * @return
 **/
@Slf4j
@Component
public class RabbitMQJsLoanReceiver {

    @Resource
    private JsLoanRiskInfoMapper jsLoanRiskInfoMapper;
    @Resource
    private JsLoanApplyInfoMapper jsLoanApplyInfoMapper;

    @Resource
    private JsTradeService jsTradeService;

    @Autowired
    private LoanConfigureInfo loanConfigureInfo;

    @RabbitListener(
            bindings = @QueueBinding(
                    value = @Queue(value = "${spring.rabbitmq.queueLoanNotity}", durable = "true"),
                    exchange = @Exchange(value = "${spring.rabbitmq.exchangeLoanNotity}"),
                    key = "${spring.rabbitmq.loanKeyNotity}"
                    //key = "${spring.rabbitmq.loanKeySend}"
            )
    )
    @RabbitHandler
    public void loanMessage(@Payload Message message,
                              @Headers Map<String,Object> headers,
                              Channel channel) {

        log.info("接收数据：message：{}",message);
        String mesStr = null;
        try{
            mesStr = new String(message.getBody(),"utf-8");
        }catch (Exception e){
            log.error("MQ接收转换错误");
        }

        log.info("com.js.loan.mq.RabbitMQJsLoanRiskReceiver.loanMessage message:{},headers:{} ,channel{}", mesStr,headers,channel);
        //解析贷款端通知结果
        JSONArray jSONArray = JSONArray.fromObject(mesStr);
        JSONObject jsonObject = jSONArray.getJSONObject(0);
        Map<String,Object> map = jsonObject.getJSONObject("data");
        String type = jsonObject.getString("type"); //10准入，10借款申请

        if("10".equals(type)){//准入通知
            JsLoanRiskInfo jsLoanRiskInfo = new JsLoanRiskInfo();
            jsLoanRiskInfo.setRiskNo(map.get("riskNo").toString());
            jsLoanRiskInfo.setDelFlag(false);
            jsLoanRiskInfo = jsLoanRiskInfoMapper.selectOne(jsLoanRiskInfo);
            if(jsLoanRiskInfo != null){
                Example example=new Example(JsLoanRiskInfo.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("riskNo",map.get("riskNo").toString());
                JsLoanRiskInfo updateJsLoanRiskInfo = new JsLoanRiskInfo();
                if(map.get("auditStatus").toString().equals(CommonConstant.LOAN_RISK_STATUS_REFUSE)){
                    updateJsLoanRiskInfo.setDelFlag(true);
                }
                updateJsLoanRiskInfo.setStatus(map.get("auditStatus").toString());
                updateJsLoanRiskInfo.setAuditMsg(map.get("auditOpinion").toString());
                updateJsLoanRiskInfo.setJsRemark(map.get("auditRemark").toString());
                jsLoanRiskInfoMapper.updateByExampleSelective(updateJsLoanRiskInfo,example);
            }

        }else if("20".equals(type)){ //申请通知
            JsLoanApplyInfo jsLoanApplyInfo = new JsLoanApplyInfo();
            jsLoanApplyInfo.setLoanNo(map.get("loanNo").toString());
            jsLoanApplyInfo.setKycNaturalId(map.get("kycNaturalId").toString());
            jsLoanApplyInfo = jsLoanApplyInfoMapper.selectOne(jsLoanApplyInfo);
            if(null != jsLoanApplyInfo){
                JsLoanApplyInfo updateJsLoanApplyInfo = new JsLoanApplyInfo();
                updateJsLoanApplyInfo.setLoanStatus(map.get("loanStatus").toString());
                if(map.get("loanStatus").toString().equals(CommonConstant.LOAN_APPLY_STATUS_C_VERIFY_ADOPT)){//复审通过
                    updateJsLoanApplyInfo.setAdoptAmt(new BigDecimal(map.get("loanAmount").toString()));
                }
//                if(map.get("loanStatus").toString().equals(CommonConstant.LOAN_APPLY_STATUS_REPAYMENT_ING)){ //放款后还款通知
//                    //updateJsLoanApplyInfo.setRepaymentDate(DateUtils.StrToDate(map.get("repaymentDate").toString())); //还款日期
//                    //updateJsLoanApplyInfo.setAdoptAmt(new BigDecimal(map.get("loanAmount").toString())); //设置放款实际金额
//                    JsTradeReq jsTradeReq = new JsTradeReq();
//                    jsTradeReq.setTradeNo(map.get("tradeNo").toString());
//                    jsTradeReq.setAccType("2");
//                    jsTradeReq.setTradeSubType(TradeSubTypeEnum.RECEIVABLES);
//                    jsTradeReq.setCurId("CNY"); //人民币
//                    jsTradeReq.setTradeAmt(new BigDecimal(map.get("loanAmount").toString()));
//                    jsTradeReq.setTradeDts(new Date());
//                    jsTradeReq.setProcessStatus("TRADE_PROCESSED");
//                    jsTradeReq.setAcctA(jsLoanApplyInfo.getAcctNo());
//                    jsTradeReq.setAcctNameA(jsLoanApplyInfo.getAcctName());
//                    jsTradeReq.setAcctB(loanConfigureInfo.getChannelSmallLoanId()); //小贷账户
//                    jsTradeReq.setAcctNameB("鹰潭市信江广达小额贷款股份有限公司");
//                    jsTradeReq.setKycNaturalIdA(jsLoanApplyInfo.getKycNaturalId());
//                    jsTradeReq.setKycNaturalIdB(loanConfigureInfo.getChannelSmallLoanId());
//                    jsTradeService.record(jsTradeReq);
//                }
                //4正常结清，5催收减免结清，6正常提前结清，7催收提前结清 -1合同废止
                if(map.get("loanStatus").toString().equals(CommonConstant.LOAN_APPLY_STATUS_NORMAL_SETTLE)
                               || map.get("loanStatus").toString().equals(CommonConstant.LOAN_APPLY_STATUS_RED_SETTLE)
                               ||map.get("loanStatus").toString().equals(CommonConstant.LOAN_APPLY_STATUS_NORMAL_ADVANCE_SETTLE)
                               ||map.get("loanStatus").toString().equals(CommonConstant.LOAN_APPLY_STATUS_COLL_ADVANCE_SETTLE)
                               ||map.get("loanStatus").toString().equals(CommonConstant.LOAN_APPLY_STATUS_CONTRACT_TER)){
                    updateJsLoanApplyInfo.setIsEnd("1");//完结
                }
                Example example=new Example(JsLoanApplyInfo.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("kycNaturalId",map.get("kycNaturalId").toString());
                criteria.andEqualTo("loanNo",map.get("loanNo").toString());
                jsLoanApplyInfoMapper.updateByExampleSelective(updateJsLoanApplyInfo,example);
            }
        }

    }
}
