package com.js.loan.service.fadada.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.file.FileWriter;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fadada.sdk.client.FddClientBase;
import com.fadada.sdk.client.FddClientExtra;
import com.fadada.sdk.client.authForplatform.ApplyClientNumCert;
import com.fadada.sdk.client.authForplatform.CompanyDeposit;
import com.fadada.sdk.client.authForplatform.PersonDeposit;
import com.fadada.sdk.client.authForplatform.model.*;
import com.fadada.sdk.client.request.ExtsignReq;
import com.js.api.jsloan.service.fadada.ApiFadadaService;
import com.js.common.JsException.LogicException;
import com.js.common.constant.Constant;
import com.js.common.enums.*;
import com.js.common.model.req.FadadaSignContractResultReq;
import com.js.common.model.req.FadadaUploadContractReq;
import com.js.common.model.resp.FadadaContractVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.*;
import com.js.dal.dao.model.*;
import com.js.loan.properties.FadadaProperty;
import com.js.loan.service.JsFileForOSSSerivce;
import com.js.loan.utils.LoanConfigureInfo;
import com.js.loan.utils.ResponseMessageWraper;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;
import tk.mybatis.mapper.entity.Example;

import java.io.*;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
public class ApiFadadaServiceImpl implements ApiFadadaService {

    @Autowired
    FadadaProperty fadadaProperty;
    @Autowired
    LoanConfigureInfo loanConfigureInfo;
    @Autowired
    JsLoanRiskInfoMapper jsLoanRiskInfoMapper;
    @Autowired
    JsLoanApplyInfoMapper jsLoanApplyInfoMapper;
    @Autowired
    FadadaOpenAccountMapper fadadaOpenAccountMapper;
    @Autowired
    FadadaCertiPersonalMapper fadadaCertiPersonalMapper;
    @Autowired
    FadadaCertiCompanyMapper fadadaCertiCompanyMapper;
    @Autowired
    FadadaSignatureMapper fadadaSignatureMapper;
    @Autowired
    FadadaContractMapper fadadaContractMapper;
    @Autowired
    FadadaContractSignMapper fadadaContractSignMapper;
    @Autowired
    KycCertiHKCompanyMapper kycCertiHKCompanyMapper;
    @Autowired
    KycCertiLinkFileMapper kycCertiLinkFileMapper;
    @Autowired
    KycNaturalMapper kycNaturalMapper;
    @Autowired
    JsFileForOSSSerivce jsFileForOSSSerivce;

    /**
     * 根据法大大电子签章 excel 根据情况不同。用户可能需要开二，三个户。
     *
     * @param riskNo
     * @param loanNo
     */
    @Override
    public ResponseMessage sign(String riskNo, String loanNo) {
        log.info("开始签合同......riskNo: {}.........loanNo: {}.................", riskNo, loanNo);
        JsLoanRiskInfo jsLoanRiskInfoCondition = new JsLoanRiskInfo();
        jsLoanRiskInfoCondition.setRiskNo(riskNo);
        JsLoanRiskInfo jsLoanRiskInfo = jsLoanRiskInfoMapper.selectOne(jsLoanRiskInfoCondition);

        JsLoanApplyInfo jsLoanApplyInfoCondition = new JsLoanApplyInfo();
        jsLoanApplyInfoCondition.setLoanNo(loanNo);
        JsLoanApplyInfo jsLoanApplyInfo = jsLoanApplyInfoMapper.selectOne(jsLoanApplyInfoCondition);

        // 根据准入与申请信息计算个人实名存证
        final FadadaCertiPersonal fadadaCertiPersonal = getFadadaCertiPersonal(jsLoanRiskInfo, jsLoanApplyInfo);
        log.info("合同签署流程1...................................");
        if (fadadaCertiPersonal.getId() == null) {
            log.info("需要重新开户 fadadaCertiPersonal");
            // 需要重新开户
            ResponseMessage responseMessage = openAccount(jsLoanRiskInfo.getKycNaturalId(), "1");
            ResponseMessage message = ResponseMessageWraper.wrap(responseMessage)
                    .andThen((FadadaOpenAccount e) -> {
                        return personDeposit(e.getId(), jsLoanRiskInfo.getId(), jsLoanApplyInfo.getId());
                    }).andThen((FadadaCertiPersonal e) -> {
                        BeanUtil.copyProperties(e, fadadaCertiPersonal);
                        return applyClientNumCert(e.getId());
                    }).andThen(e -> {
                        return customSignature(fadadaCertiPersonal.getKycNaturalId(),
                                fadadaCertiPersonal.getName(), fadadaCertiPersonal.getCustomerId());
                    }).andThen((FadadaSignature e) -> {
                        return addSignature2(e.getId());
                    }).unwrap();
            if (!message.isSuccess()) {
                return message;
            }
        }

        log.info("合同签署流程2...................................");
        final FadadaCertiCompany fadadaCertiCompany = getFadadaCertiCompany(jsLoanRiskInfo);
        if (fadadaCertiCompany.getId() == null) {
            log.info("需要重新开户 fadadaCertiCompany");
            // 需要重新开户
            ResponseMessage responseMessage = openAccount(jsLoanRiskInfo.getKycNaturalId(), "2");
            ResponseMessage message = ResponseMessageWraper.wrap(responseMessage)
                    .andThen((FadadaOpenAccount e) -> {
                        return companyDeposit(e.getId(), jsLoanRiskInfo.getId(),
                                fadadaCertiPersonal.getId());
                    }).andThen((FadadaCertiCompany e) -> {
                        BeanUtil.copyProperties(e, fadadaCertiCompany);
                        return applyClientNumCert2(e.getId());
                    }).andThen(e -> {
                        return customSignature(fadadaCertiCompany.getKycNaturalId(),
                                fadadaCertiCompany.getName(), fadadaCertiCompany.getCustomerId());
                    }).andThen((FadadaSignature e) -> {
                        return addSignature2(e.getId());
                    }).unwrap();
            if (!message.isSuccess()) {
                return message;
            }
        }
        log.info("合同签署流程3...................................");
        // 香港企业，还需要多查一个香港的担保企业
        // 如果是香港企业，则这个一定是 kyc，直接从 kyc 中获取对应的信息
        final FadadaCertiCompany fadadaCertiHKCompany;
        final KycCertiHKCompany kycCertiHKCompany = getKycCertiHKCompany(jsLoanRiskInfo);
        if (kycCertiHKCompany != null) {
            log.info("需要重新开户 kycCertiHKCompany");
            // 重新开户
            JsLoanRiskInfo condition = new JsLoanRiskInfo();
            condition.setKycNaturalId(jsLoanRiskInfo.getKycNaturalId());
            // 法大大验不了这个，而且香港企业也不存在统一信用代码。
            condition.setGuaranteeCorpOrgcode(kycCertiHKCompany.getCompanyRegisteredCertificateNo());
            fadadaCertiHKCompany = getFadadaCertiCompany(condition);
            if (fadadaCertiHKCompany.getId() == null) {
                // 需要重新开户
                ResponseMessage responseMessage = openAccount(jsLoanRiskInfo.getKycNaturalId(), "2");
                ResponseMessage message = ResponseMessageWraper.wrap(responseMessage)
                        .andThen((FadadaOpenAccount e) -> {
                            return companyDeposit2(e.getId(), jsLoanRiskInfo.getId(),
                                    kycCertiHKCompany.getId(), fadadaCertiPersonal.getId());
                        }).andThen((FadadaCertiCompany e) -> {
                            BeanUtil.copyProperties(e, fadadaCertiHKCompany);
                            return applyClientNumCert2(fadadaCertiCompany.getId());
                        }).andThen(e -> {
                            return customSignature(fadadaCertiCompany.getKycNaturalId(),
                                    fadadaCertiCompany.getName(), fadadaCertiCompany.getCustomerId());
                        }).andThen((FadadaSignature e) -> {
                            return addSignature2(e.getId());
                        }).unwrap();
                if (!message.isSuccess()) {
                    return message;
                }
            }
        } else {
            // 非香港企业，不需要开香港相关的户。
            fadadaCertiHKCompany = null;
        }
        log.info("合同签署流程4...................................");
        KycNatural kycNatural = kycNaturalMapper.selectByPrimaryKey(fadadaCertiPersonal.getKycNaturalId());
        // 上传合同，签署前应提前传输完毕。
        List<FadadaContract> fadadaContracts = getFadadaContractsByLoanNo(jsLoanApplyInfo.getLoanNo());
        // 取全部合同名，除重
        List<String> contractNames = fadadaContracts.stream()
                .map(FadadaContract::getDocTitle)
                .distinct()
                .collect(Collectors.toList());
        List<String> targetContractNames = new ArrayList<>();
        // 计算使用的合同名,香港与大陆使用的是不同的合同模板
        if (kycNatural.getRegisterType().equals(RegisterType.HK_COMPANY.name())) {
            targetContractNames.add(loanConfigureInfo.getContractNameHk());
            targetContractNames.add(loanConfigureInfo.getContractName2Hk());
            targetContractNames.add(loanConfigureInfo.getContractName3());
        } else if (kycNatural.getRegisterType().equals(RegisterType.MAINLAND_COMPANY.name())
                || kycNatural.getRegisterType().equals(RegisterType.MAINLAND_PERSONAL.name())) {
            targetContractNames.add(loanConfigureInfo.getContractNameHolder());
            targetContractNames.add(loanConfigureInfo.getContractName2Holder());
            targetContractNames.add(loanConfigureInfo.getContractName3());
        } else {
            return ResultUtil.error(ResultEnum.ERROR.getCode(), "不支持香港个人进行借款");
        }

        if (contractNames.size() != 3 || !targetContractNames.containsAll(contractNames)) {
            return ResultUtil.error(ResultEnum.FADADA_SIGN_CONTRACT_NUM_FAILURE);
        }
        log.info("合同签署流程5...................................");
        // 数据齐全，开始签署合同,签署逻辑根据《法大大电子签章_0722.xlsx》 表格。
        for (FadadaContract fadadaContract : fadadaContracts) {
            String docTitle = fadadaContract.getDocTitle();

            if (loanConfigureInfo.getContractNameHolder().equals(docTitle)) {
                // 自动签小贷
                ResponseMessage responseMessage = signContractAuto(fadadaContract.getContractId(), fadadaProperty.getMyLoanCoustomId(), 400);
                log.info("小贷自动签署，合同：{}, 结果：{}", fadadaContract.getContractId(), responseMessage.isSuccess());
                // 手动签借款人
                signContract(fadadaCertiPersonal.getKycNaturalId(), fadadaCertiPersonal.getCustomerId(),
                        fadadaContract.getContractId(), fadadaCertiPersonal.getMobile());
                // 手动签担保人
                signContract(fadadaCertiCompany.getKycNaturalId(), fadadaCertiCompany.getCustomerId(),
                        fadadaContract.getContractId(), kycNatural.getPhoneNo());
            } else if (loanConfigureInfo.getContractNameHk().equals(docTitle)) {
                // 自动签小贷
                ResponseMessage responseMessage = signContractAuto(fadadaContract.getContractId(), fadadaProperty.getMyLoanCoustomId(), 400);
                log.info("小贷自动签署，合同：{}, 结果：{}", fadadaContract.getContractId(), responseMessage.isSuccess());
                // 手动签借款人
                signContract(fadadaCertiPersonal.getKycNaturalId(), fadadaCertiPersonal.getCustomerId(),
                        fadadaContract.getContractId(), fadadaCertiPersonal.getMobile());
                // 手动签担保人
                signContract(fadadaCertiCompany.getKycNaturalId(), fadadaCertiCompany.getCustomerId(),
                        fadadaContract.getContractId(), kycNatural.getPhoneNo());
                // 香港企业还需要手动签香港企业的
                signContract(fadadaCertiHKCompany.getKycNaturalId(), fadadaCertiHKCompany.getCustomerId(),
                        fadadaContract.getContractId(), kycNatural.getPhoneNo());
            } else if (loanConfigureInfo.getContractName2Holder().equals(docTitle)) {
                // 自动签源奉
                ResponseMessage responseMessage = signContractAuto(fadadaContract.getContractId(), fadadaProperty.getMyCoustomId(), 200);

                log.info("源奉自动签署，合同：{}, 结果：{}", fadadaContract.getContractId(), responseMessage.isSuccess());
                // 手动签借款人
                signContract(fadadaCertiPersonal.getKycNaturalId(), fadadaCertiPersonal.getCustomerId(),
                        fadadaContract.getContractId(), fadadaCertiPersonal.getMobile());
                // 手动签担保人
                signContract(fadadaCertiCompany.getKycNaturalId(), fadadaCertiCompany.getCustomerId(),
                        fadadaContract.getContractId(), kycNatural.getPhoneNo());
                if (fadadaCertiHKCompany != null) {
                    // 如果是香港企业还需要手动签香港企业的
                    signContract(fadadaCertiHKCompany.getKycNaturalId(), fadadaCertiHKCompany.getCustomerId(),
                            fadadaContract.getContractId(), kycNatural.getPhoneNo());
                }
            } else if (loanConfigureInfo.getContractName2Hk().equals(docTitle)) {
                // 自动签源奉
                ResponseMessage responseMessage = signContractAuto(fadadaContract.getContractId(), fadadaProperty.getMyCoustomId(), 200);

                log.info("源奉自动签署，合同：{}, 结果：{}", fadadaContract.getContractId(), responseMessage.isSuccess());
                // 手动签借款人
                signContract(fadadaCertiPersonal.getKycNaturalId(), fadadaCertiPersonal.getCustomerId(),
                        fadadaContract.getContractId(), fadadaCertiPersonal.getMobile());
                // 手动签担保人
                signContract(fadadaCertiCompany.getKycNaturalId(), fadadaCertiCompany.getCustomerId(),
                        fadadaContract.getContractId(), kycNatural.getPhoneNo());
                // 如果是香港企业还需要手动签香港企业的
                signContract(fadadaCertiHKCompany.getKycNaturalId(), fadadaCertiHKCompany.getCustomerId(),
                        fadadaContract.getContractId(), kycNatural.getPhoneNo());
            } else if (loanConfigureInfo.getContractName3().equals(docTitle)) {
                // 自动签源奉
                ResponseMessage responseMessage = signContractAuto(fadadaContract.getContractId(), fadadaProperty.getMyCoustomId(), 200);
                log.info("源奉自动签署，合同：{}, 结果：{}", fadadaContract.getContractId(), responseMessage.isSuccess());
                // 自动签小贷
                ResponseMessage responseMessage1 = signContractAuto(fadadaContract.getContractId(), fadadaProperty.getMyLoanCoustomId(), 400);
                log.info("小贷自动签署，合同：{}, 结果：{}", fadadaContract.getContractId(), responseMessage1.isSuccess());
                // 手动签借款人
                signContract(fadadaCertiPersonal.getKycNaturalId(), fadadaCertiPersonal.getCustomerId(),
                        fadadaContract.getContractId(), fadadaCertiPersonal.getMobile());
                if (!RegisterType.MAINLAND_PERSONAL.name().equals(kycNatural.getRegisterType())) {
                    if (fadadaCertiHKCompany != null) {
                        // 如果是香港企业还需要手动签香港企业的
                        signContract(fadadaCertiHKCompany.getKycNaturalId(), fadadaCertiHKCompany.getCustomerId(),
                                fadadaContract.getContractId(), kycNatural.getPhoneNo());
                    } else {
                        // 如果不是香港企业，手动签大陆企业的
                        signContract(fadadaCertiCompany.getKycNaturalId(), fadadaCertiCompany.getCustomerId(),
                                fadadaContract.getContractId(), kycNatural.getPhoneNo());
                    }
                }
            }
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage archiveContract2(String kycNatualId, String loanNo) {

        List<FadadaContract> fadadaContracts = getFadadaContractsByLoanNo(loanNo);
        KycNatural kycNatural = kycNaturalMapper.selectByPrimaryKey(kycNatualId);

        // 校验合同是不是全部签署完毕、
        // 取全部的合同 id
        List<String> contractIds = fadadaContracts.stream()
                .map(FadadaContract::getContractId)
                .collect(Collectors.toList());

        Example example = new Example(FadadaContractSign.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("contractId", contractIds);
        criteria.andEqualTo("result", FadadaContractSignResultEnum.FAILURE);
        List<FadadaContractSign> contractSignsAll = fadadaContractSignMapper.selectByExample(example);

        if (contractSignsAll.size() > 0) {
            List<String> contractSignIds = contractSignsAll.stream()
                    .map(FadadaContractSign::getContractId)
                    .distinct()
                    .collect(Collectors.toList());
            log.error("存在还未签署的合同，尚未签署的合同有: {} ,申请单号：{}", contractSignIds, loanNo);
            return ResultUtil.error(ResultEnum.FADADA_ARCHIVE_CONTRACT_FAILURE);
        }

        for (FadadaContract fadadaContract : fadadaContracts) {
            if (FadadaContractStatusEnum.ARCHIVE.ordinal() == fadadaContract.getStatus()) {
                log.info("合同已经归档，跳过");
                continue;
            } else {
                String docTitle = fadadaContract.getDocTitle();
                List<FadadaContractSign> fadadaContractSigns = getFadadaContractSignsByContractId(fadadaContract.getContractId());
                if (loanConfigureInfo.getContractNameHolder().equals(docTitle)) {
                    if (RegisterType.MAINLAND_PERSONAL.name().equals(kycNatural.getRegisterType())) {
                        if (fadadaContractSigns.size() == 3) {
                            log.info("合同归档1");
                            ResponseMessage responseMessage = contractArchive(fadadaContract.getContractId());
                            if (!responseMessage.isSuccess()) {
                                return responseMessage;
                            }
                        } else {
                            log.error("签署的成功合同数量不匹配1");
                            return ResultUtil.error(ResultEnum.FADADA_ARCHIVE_CONTRACT_FAILURE);
                        }
                    } else if (RegisterType.MAINLAND_COMPANY.name().equals(kycNatural.getRegisterType())) {
                        if (fadadaContractSigns.size() == 3) {
                            log.info("合同归档2");
                            ResponseMessage responseMessage = contractArchive(fadadaContract.getContractId());
                            if (!responseMessage.isSuccess()) {
                                return responseMessage;
                            }
                        } else {
                            log.error("签署的成功合同数量不匹配2");
                            return ResultUtil.error(ResultEnum.FADADA_ARCHIVE_CONTRACT_FAILURE);
                        }
                    } else {
                        log.error("kyc类型与合同不匹配");
                        return ResultUtil.error(ResultEnum.FADADA_ARCHIVE_CONTRACT_FAILURE);
                    }
                } else if (loanConfigureInfo.getContractNameHk().equals(docTitle)) {
                    if (RegisterType.HK_COMPANY.name().equals(kycNatural.getRegisterType())) {
                        if (fadadaContractSigns.size() == 4) {
                            log.info("合同归档3");
                            ResponseMessage responseMessage = contractArchive(fadadaContract.getContractId());
                            if (!responseMessage.isSuccess()) {
                                return responseMessage;
                            }
                        } else {
                            log.error("签署的成功合同数量不匹配3");
                            return ResultUtil.error(ResultEnum.FADADA_ARCHIVE_CONTRACT_FAILURE);
                        }
                    } else {
                        log.error("kyc类型与合同不匹配");
                        return ResultUtil.error(ResultEnum.FADADA_ARCHIVE_CONTRACT_FAILURE);
                    }
                } else if (loanConfigureInfo.getContractName2Holder().equals(docTitle)) {
                    if (RegisterType.MAINLAND_PERSONAL.name().equals(kycNatural.getRegisterType())) {
                        if (fadadaContractSigns.size() == 3) {
                            log.info("合同归档4");
                            ResponseMessage responseMessage = contractArchive(fadadaContract.getContractId());
                            if (!responseMessage.isSuccess()) {
                                return responseMessage;
                            }
                        } else {
                            log.error("签署的成功合同数量不匹配4");
                            return ResultUtil.error(ResultEnum.FADADA_ARCHIVE_CONTRACT_FAILURE);
                        }
                    } else if (RegisterType.MAINLAND_COMPANY.name().equals(kycNatural.getRegisterType())) {
                        if (fadadaContractSigns.size() == 3) {
                            log.info("合同归档5");
                            ResponseMessage responseMessage = contractArchive(fadadaContract.getContractId());
                            if (!responseMessage.isSuccess()) {
                                return responseMessage;
                            }
                        } else {
                            log.error("签署的成功合同数量不匹配5");
                            return ResultUtil.error(ResultEnum.FADADA_ARCHIVE_CONTRACT_FAILURE);
                        }
                    } else {
                        log.error("kyc类型与合同不匹配");
                        return ResultUtil.error(ResultEnum.FADADA_ARCHIVE_CONTRACT_FAILURE);
                    }
                } else if (loanConfigureInfo.getContractName2Hk().equals(docTitle)) {
                    if (RegisterType.HK_COMPANY.name().equals(kycNatural.getRegisterType())) {
                        if (fadadaContractSigns.size() == 4) {
                            log.info("合同归档6");
                            ResponseMessage responseMessage = contractArchive(fadadaContract.getContractId());
                            if (!responseMessage.isSuccess()) {
                                return responseMessage;
                            }
                        } else {
                            log.error("签署的成功合同数量不匹配6");
                            return ResultUtil.error(ResultEnum.FADADA_ARCHIVE_CONTRACT_FAILURE);
                        }
                    } else {
                        log.error("kyc类型与合同不匹配");
                        return ResultUtil.error(ResultEnum.FADADA_ARCHIVE_CONTRACT_FAILURE);
                    }
                } else if (loanConfigureInfo.getContractName3().equals(docTitle)) {
                    if (RegisterType.MAINLAND_PERSONAL.name().equals(kycNatural.getRegisterType())) {
                        if (fadadaContractSigns.size() == 3) {
                            log.info("合同归档7");
                            ResponseMessage responseMessage = contractArchive(fadadaContract.getContractId());
                            if (!responseMessage.isSuccess()) {
                                return responseMessage;
                            }
                        } else {
                            log.error("签署的成功合同数量不匹配7");
                            return ResultUtil.error(ResultEnum.FADADA_ARCHIVE_CONTRACT_FAILURE);
                        }
                    } else if (RegisterType.MAINLAND_COMPANY.name().equals(kycNatural.getRegisterType())) {
                        if (fadadaContractSigns.size() == 4) {
                            log.info("合同归档8");
                            ResponseMessage responseMessage = contractArchive(fadadaContract.getContractId());
                            if (!responseMessage.isSuccess()) {
                                return responseMessage;
                            }
                        } else {
                            log.error("签署的成功合同数量不匹配8");
                            return ResultUtil.error(ResultEnum.FADADA_ARCHIVE_CONTRACT_FAILURE);
                        }
                    } else if (RegisterType.HK_COMPANY.name().equals(kycNatural.getRegisterType())) {
                        if (fadadaContractSigns.size() == 4) {
                            log.info("合同归档9");
                            ResponseMessage responseMessage = contractArchive(fadadaContract.getContractId());
                            if (!responseMessage.isSuccess()) {
                                return responseMessage;
                            }
                        } else {
                            log.error("签署的成功合同数量不匹配9");
                            return ResultUtil.error(ResultEnum.FADADA_ARCHIVE_CONTRACT_FAILURE);
                        }
                    } else {
                        log.error("kyc类型与合同不匹配");
                        return ResultUtil.error(ResultEnum.FADADA_ARCHIVE_CONTRACT_FAILURE);
                    }
                }
            }
            // 生成合同查看与下载链接
            getContractViewAndDownLoadUrl(fadadaContract);
        }
        return ResultUtil.success(ResultEnum.FADADA_ARCHIVE_CONTRACT_SUCCESS);
    }

    private void getContractViewAndDownLoadUrl(FadadaContract fadadaContract) {
        fadadaContract = fadadaContractMapper.selectByPrimaryKey(fadadaContract.getId());
        String viewUrl = (String) viewContract(fadadaContract.getContractId()).getData();
        String downloadUrl = (String) downloadContract(fadadaContract.getContractId()).getData();
        fadadaContract.setFadadaDownloadUrl(downloadUrl);
        fadadaContract.setFadadaSelectUrl(viewUrl);
        fadadaContractMapper.updateByPrimaryKeySelective(fadadaContract);
    }

    @Override
    public ResponseMessage getUnSignContractByLoanNo(String loanNo) {
        if (ObjectUtil.isEmpty(loanNo)) {
            return ResultUtil.error(ResultEnum.FADADA_UN_SIGN_VALIDATE_FAILURE);
        }
        List<FadadaContract> fadadaContracts = getFadadaContractsByLoanNo(loanNo);
        List<String> contractIds = fadadaContracts.stream()
                .map(FadadaContract::getContractId)
                .collect(Collectors.toList());
        if (contractIds.size() == 0) {
            return ResultUtil.error(ResultEnum.QUERY_ERROR);
        }
        Example example = new Example(FadadaContractSign.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("contractId", contractIds);
        List<FadadaContractSign> fadadaContractSigns = fadadaContractSignMapper.selectByExample(example);
        if (fadadaContractSigns.size() == 0) {
            // 因为某些原因没有生成合同签署
            return ResultUtil.error(ResultEnum.QUERY_ERROR);
        }
        // 获取需要签的总条数
        List<FadadaContractSign> totalManualContract = fadadaContractSigns.stream()
                .filter(e -> e.getType() == FadadaContractSignTypeEnum.MANUAL.ordinal())
                .collect(Collectors.toList());

        // 把一类的合同分到一组
        Map<String, List<FadadaContractSign>> map = totalManualContract.stream()
                .filter(e -> e.getResult() == FadadaContractSignResultEnum.FAILURE.ordinal())
                .collect(Collectors.groupingBy(FadadaContractSign::getContractId));
        // 保留分组转成 list
        List<String> list = new ArrayList<>();
        for (Map.Entry<String, List<FadadaContractSign>> stringListEntry : map.entrySet()) {
            List<FadadaContractSign> value = stringListEntry.getValue();
            for (FadadaContractSign fadadaContractSign : value) {
                list.add(fadadaContractSign.getSignUrl());
            }
        }
        Map<String, Object> result = new HashMap<>();
        result.put("total", totalManualContract.size());
        result.put("urls", list);
        result.put("signed", totalManualContract.size() - list.size());
        return ResultUtil.success(result, ResultEnum.QUERY_SUCCESS);
    }

    @Override
    public void deleteContract(String loanNo) {
        List<FadadaContract> fadadaContracts = getFadadaContractsByLoanNo(loanNo);
        for (FadadaContract fadadaContract : fadadaContracts) {
            fadadaContract.setDelFlag(true);
            log.info("contractId: {} 删除成功", fadadaContract.getContractId());
            fadadaContractMapper.updateByPrimaryKeySelective(fadadaContract);
        }
    }

    @Override
    public ResponseMessage getSignStatus(String loanNo) {
        Map<String, Object> result = new HashMap<>();
        List<FadadaContract> fadadaContracts = getFadadaContractsByLoanNo(loanNo);
        List<String> contractIds = fadadaContracts.stream()
                .map(FadadaContract::getContractId)
                .collect(Collectors.toList());
        if (contractIds.size() == 0) {
            result.put("total", 0);
            result.put("status", FadadaContractSignStatusEnum.CAN_SIGN.getCode());
            result.put("signed", 0);
            return ResultUtil.success(result, ResultEnum.QUERY_SUCCESS);
        }
        Example example = new Example(FadadaContractSign.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("contractId", contractIds);
        List<FadadaContractSign> fadadaContractSigns = fadadaContractSignMapper.selectByExample(example);
        if (fadadaContractSigns.size() == 0) {
            log.error("getSignStatus 因为某些原因没有生成合同签署");
            result.put("total", 0);
            result.put("status", FadadaContractSignStatusEnum. CANNOT_SIGN.getCode());
            result.put("signed", 0);
            return ResultUtil.success(result, ResultEnum.QUERY_SUCCESS);
        }
        // 获取需要签的总条数
        List<FadadaContractSign> totalManualContract = fadadaContractSigns.stream()
                .filter(e -> e.getType() == FadadaContractSignTypeEnum.MANUAL.ordinal())
                .collect(Collectors.toList());

        // 计算已经签署的
        long count = totalManualContract.stream()
                .filter(e -> e.getResult() == FadadaContractSignResultEnum.SUCCESS.ordinal())
                .count();

        result.put("total", totalManualContract.size());
        result.put("status", FadadaContractSignStatusEnum. CANNOT_SIGN.getCode());
        result.put("signed", count);

        return ResultUtil.success(result, ResultEnum.QUERY_SUCCESS);
    }

    @Override
    public ResponseMessage getSignContractResultByReturnUrl(FadadaSignContractResultReq fadadaSignContractResultReq) {
        if (!checkMsgDigest(fadadaSignContractResultReq)) {
            throw LogicException.le(ResultEnum.FADADA_SIGN_CONTRACT_FAILURE2);
        }
        Example example = new Example(FadadaContractSign.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("transactionId", fadadaSignContractResultReq.getTransaction_id());
        FadadaContractSign fadadaContractSign = fadadaContractSignMapper.selectOneByExample(example);
        if ("3000".equals(fadadaSignContractResultReq.getResult_code())) {
            log.info("合同签署结果成功");
            fadadaContractSign.setResult(FadadaContractSignResultEnum.SUCCESS.ordinal());
            fadadaContractSignMapper.updateByPrimaryKeySelective(fadadaContractSign);
            return ResultUtil.success(ResultEnum.FADADA_SIGN_CONTRACT_SUCCESS2);
        } else {
            throw LogicException.le(ResultEnum.FADADA_SIGN_CONTRACT_FAILURE);
        }
    }

    /**
     * 校验签名,算法见法大大文档
     */
    private boolean checkMsgDigest(FadadaSignContractResultReq fadadaSignContractResultReq) {
        String msgDigest = fadadaSignContractResultReq.getMsg_digest();
        String timestamp = fadadaSignContractResultReq.getTimestamp();
        String timestampMD5 = SecureUtil.md5(timestamp).toUpperCase();
        String s = SecureUtil.sha1(fadadaProperty.getAppSecret() + fadadaSignContractResultReq.getTransaction_id()).toUpperCase();
        String s1 = SecureUtil.sha1(fadadaProperty.getAppId() + timestampMD5 + s).toUpperCase();
        String encode = Base64.encode(s1);
        return msgDigest.equals(encode);
    }

    @Override
    public ResponseMessage getSignContractResultByNotifyUrl(FadadaSignContractResultReq fadadaSignContractResultReq) {
        return getSignContractResultByReturnUrl(fadadaSignContractResultReq);
    }

    @Override
    public ResponseMessage getFadadaContractVOByLoanNo(String loanNo) {
        List<FadadaContractVO> fadadaContractVO = new ArrayList<>();
        List<FadadaContract> fadadaContracts = getFadadaContractsByLoanNo(loanNo);
        for (FadadaContract fadadaContract : fadadaContracts) {
            FadadaContractVO vo = new FadadaContractVO();
            vo.setId(fadadaContract.getId());
            vo.setContractNo(fadadaContract.getContractId());
            vo.setDocTitle(fadadaContract.getDocTitle());
            vo.setDownloadUrl(fadadaContract.getFadadaDownloadUrl());
            vo.setViewUrl(fadadaContract.getFadadaSelectUrl());
            vo.setFileSavePath(fadadaContract.getFileSavePath());
            fadadaContractVO.add(vo);
        }
        return ResultUtil.success(fadadaContractVO, ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage updateContract(FadadaContractVO fadadaContractVO) {
        FadadaContract fadadaContract = new FadadaContract();
        fadadaContract.setId(fadadaContractVO.getId());
        fadadaContract.setFileSavePath(fadadaContractVO.getFileSavePath());
        int i = fadadaContractMapper.updateByPrimaryKeySelective(fadadaContract);
        if (i > 0) {
            return ResultUtil.success(ResultEnum.UPDATE_SUCCESS);
        } else {
            return ResultUtil.success(ResultEnum.UPDATE_ERROR);
        }
    }

    public List<FadadaContract> getFadadaContractsByLoanNo(String loanNo) {
        Example example = new Example(FadadaContract.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("loanNo", loanNo);
        criteria.andEqualTo("delFlag", false);
        return fadadaContractMapper.selectByExample(example);
    }

    private List<FadadaContractSign> getFadadaContractSignsByContractId(String fadadaContractId) {
        Example example = new Example(FadadaContractSign.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("contractId", fadadaContractId);
        criteria.andEqualTo("result", FadadaContractSignResultEnum.SUCCESS.ordinal());
        return fadadaContractSignMapper.selectByExample(example);
    }

    private KycCertiHKCompany getKycCertiHKCompany(JsLoanRiskInfo jsLoanRiskInfo) {
        if (ObjectUtil.isEmpty(jsLoanRiskInfo.getKycNaturalId())) {
            throw LogicException.le(ResultEnum.FADADA_COMPANY_DEPOSIT_HK_VALIDATE_FAILURE);
        }
        Example example = new Example(KycCertiHKCompany.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("kycNaturalId", jsLoanRiskInfo.getKycNaturalId());
        return kycCertiHKCompanyMapper.selectOneByExample(example);
    }

    private FadadaCertiCompany getFadadaCertiCompany(JsLoanRiskInfo jsLoanRiskInfo) {
        // 参数校验
        if (ObjectUtil.isEmpty(jsLoanRiskInfo.getKycNaturalId())
                || ObjectUtil.isEmpty(jsLoanRiskInfo.getGuaranteeCorpQualification())) {
            throw LogicException.le(ResultEnum.FADADA_COMPANY_DEPOSIT_VALIDATE_FAILURE);
        }
        Example example = new Example(FadadaCertiCompany.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("kycNaturalId", jsLoanRiskInfo.getKycNaturalId());
        criteria.andEqualTo("creditCode", jsLoanRiskInfo.getGuaranteeCorpOrgcode());
        log.info("kycNaturalId: {}, creditCode: {}",
                jsLoanRiskInfo.getKycNaturalId(),
                jsLoanRiskInfo.getGuaranteeCorpOrgcode());
        // 通过 customerId 与 社会信用代码确认企业是否已经开户。
        FadadaCertiCompany one = fadadaCertiCompanyMapper.selectOneByExample(example);
        if (one == null) {
            return new FadadaCertiCompany();
        } else{
            return one;
        }
    }

    private FadadaCertiPersonal getFadadaCertiPersonal(JsLoanRiskInfo jsLoanRiskInfo, JsLoanApplyInfo jsLoanApplyInfo) {
        // 通过四要素，确认个人实名存证信息，如果不存在。需要重新开户。（表格中的借出人部分）
        // 校验参数：
        if (ObjectUtil.isEmpty(jsLoanRiskInfo.getKycNaturalId())
                || ObjectUtil.isEmpty(jsLoanRiskInfo.getKycNaturalId())
                || ObjectUtil.isEmpty(jsLoanRiskInfo.getBorrowerName())
                || ObjectUtil.isEmpty(jsLoanRiskInfo.getBorrowerIdcard())
                || ObjectUtil.isEmpty(jsLoanApplyInfo.getMobileNo())
                || ObjectUtil.isEmpty(jsLoanApplyInfo.getAcctNo())) {
            throw LogicException.le(ResultEnum.FADADA_PERSON_DEPOSIT_VALIDATE_FAILURE);
        }
        Example example = new Example(FadadaCertiPersonal.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("kycNaturalId", jsLoanRiskInfo.getKycNaturalId());
        criteria.andEqualTo("name", jsLoanRiskInfo.getBorrowerName());
        criteria.andEqualTo("idcard", jsLoanRiskInfo.getBorrowerIdcard());
        criteria.andEqualTo("mobile", jsLoanApplyInfo.getMobileNo());
        criteria.andEqualTo("bankNo", jsLoanApplyInfo.getAcctNo());
        log.info("kycNaturalId: {}, name: {}, idcard: {}, mobile: {},bankNo: {}",
                jsLoanRiskInfo.getKycNaturalId(),
                jsLoanRiskInfo.getBorrowerName(),
                jsLoanRiskInfo.getBorrowerIdcard(),
                jsLoanApplyInfo.getMobileNo(),
                jsLoanApplyInfo.getAcctNo());
        FadadaCertiPersonal one = fadadaCertiPersonalMapper.selectOneByExample(example);
        if (one == null) {
            return new FadadaCertiPersonal();
        } else {
            return one;
        }
    }

    @Override
    public ResponseMessage openAccount(String kycNaturalId, String accountType) {
        if (ObjectUtil.isEmpty(kycNaturalId)) {
            return ResultUtil.error(ResultEnum.QUERY_ERROR);
        }
        // 开户
        FadadaOpenAccount fadadaOpenAccount = regAccount(kycNaturalId, accountType);
        if (ObjectUtil.isNull(fadadaOpenAccount)) {
            return ResultUtil.error(ResultEnum.FADADA_OPEN_ACCOUTN_FAILURE);
        } else {
            return ResultUtil.success(fadadaOpenAccount, ResultEnum.FADADA_OPEN_ACCOUTN_SUCCESS);
        }
    }

    @Override
    public ResponseMessage personDeposit(String fadadaOpenAccountId, String jsLoanRiskInfoId, String jsLoanApplyInfoId) {
        // 实名信息存证
        PersonDeposit personDeposit = new PersonDeposit(fadadaProperty.getAppId(),fadadaProperty.getAppSecret(),fadadaProperty.getVersion(),fadadaProperty.getHost());
        PersonDepositReq req = new PersonDepositReq();

        FadadaOpenAccount fadadaOpenAccount = fadadaOpenAccountMapper.selectByPrimaryKey(fadadaOpenAccountId);

        JsLoanRiskInfo jsLoanRiskInfo = jsLoanRiskInfoMapper.selectByPrimaryKey(jsLoanRiskInfoId);

        JsLoanApplyInfo jsLoanApplyInfo = jsLoanApplyInfoMapper.selectByPrimaryKey(jsLoanApplyInfoId);

        //客户编号
        req.setCustomer_id(fadadaOpenAccount.getCustomerId());
        //存证名称
        req.setPreservation_name("个人实名四要素存证");
        //存证描述
        //req.setPreservation_desc("");
        //存证数据提供方
        req.setPreservation_data_provider("北京源奉济生网络科技有限公司");

        //姓名
        req.setName(jsLoanRiskInfo.getBorrowerName());
        //证件类型 默认是0：身份证
        req.setDocument_type("0");
        //证件号
        req.setIdcard(jsLoanRiskInfo.getBorrowerIdcard());
        //证件照正面
        //req.setIdcard_positive_file(file);
        //证件照反面
        //req.setIdcard_negative_file(file);
        //手机号
        req.setMobile(jsLoanApplyInfo.getMobileNo());
        //实名时间
        //req.setVerified_time("");
        //实名存证类型
        req.setVerified_type("4");

        MobileAndBankEssentialFactor mobileAndBankEssentialFactor = new MobileAndBankEssentialFactor();
        //4:四要素(姓名+身份证+手机号+银行卡)
        // 开户银行的名称
        mobileAndBankEssentialFactor.setBank(jsLoanApplyInfo.getBankName());
        // 开户银行号
        mobileAndBankEssentialFactor.setBankAccount(jsLoanApplyInfo.getAcctNo());
        mobileAndBankEssentialFactor.setTransactionId(IdUtil.simpleUUID());
        //verified_type =4四要素
        req.setMobile_and_bank_essential_factor(mobileAndBankEssentialFactor);
        String result = personDeposit.invokePersonDeposit(req);

        log.info("personDeposit 四要素打印：bank: {}, bankAccout: {}, transactionId: {}",
                mobileAndBankEssentialFactor.getBank(), mobileAndBankEssentialFactor.getBankAccount(), mobileAndBankEssentialFactor.getTransactionId());

        JSONObject parse = JSONObject.parseObject(result);
        String code = parse.getString("code");
        if ("1".equals(code)) {
            String evidenceNo = parse.getString("data");
            FadadaCertiPersonal fadadaCertiPersonal = new FadadaCertiPersonal();
            init(fadadaCertiPersonal);
            fadadaCertiPersonal.setKycNaturalId(fadadaOpenAccount.getKycNaturalId());
            fadadaCertiPersonal.setCustomerId(fadadaOpenAccount.getCustomerId());
            fadadaCertiPersonal.setPreservationName("个人实名四要素存证");
            fadadaCertiPersonal.setPreservationDataProvider("北京源奉济生网络科技有限公司");
            fadadaCertiPersonal.setName(jsLoanRiskInfo.getBorrowerName());
            fadadaCertiPersonal.setDocumentType("0");
            fadadaCertiPersonal.setIdcard(jsLoanRiskInfo.getBorrowerIdcard());
            fadadaCertiPersonal.setMobile(jsLoanApplyInfo.getMobileNo());
            fadadaCertiPersonal.setBankName(jsLoanApplyInfo.getBankName());
            fadadaCertiPersonal.setBankNo(jsLoanApplyInfo.getAcctNo());
            fadadaCertiPersonal.setEvidenceNo(evidenceNo);
            fadadaCertiPersonalMapper.insertSelective(fadadaCertiPersonal);
            log.info(result);
            return ResultUtil.success(fadadaCertiPersonal, ResultEnum.FADADA_PERSON_DEPOSIT_SUCCESS);
        } else {
            log.error(result);
            return ResultUtil.error(ResultEnum.FADADA_PERSON_DEPOSIT_FAILURE);
        }
    }

    @Override
    public ResponseMessage companyDeposit(String fadadaOpenAccountId, String jsLoanRiskInfoId, String fadadaCertiPersonalId) {

        FadadaOpenAccount fadadaOpenAccount = fadadaOpenAccountMapper.selectByPrimaryKey(fadadaOpenAccountId);

        JsLoanRiskInfo jsLoanRiskInfo = jsLoanRiskInfoMapper.selectByPrimaryKey(jsLoanRiskInfoId);

        FadadaCertiPersonal fadadaCertiPersonal = fadadaCertiPersonalMapper.selectByPrimaryKey(fadadaCertiPersonalId);

        CompanyDeposit companyDeposit = new CompanyDeposit(fadadaProperty.getAppId(),fadadaProperty.getAppSecret(),fadadaProperty.getVersion(),fadadaProperty.getHost());
        CompanyDepositReq req = new CompanyDepositReq();
        req.setCustomer_id(fadadaOpenAccount.getCustomerId());

        String transactionId = IdUtil.simpleUUID();
        String applyNum = IdUtil.simpleUUID();

        /**=======存证相关===========*/
        req.setPreservation_name("企业实名信息存证");//存证名称
        req.setPreservation_data_provider("北京源奉济生网络科技有限公司");//存证数据提供方

        req.setCompany_name(jsLoanRiskInfo.getGuaranteeCorp());//企业名称

        /**=======证件相关===========*/
        req.setDocument_type("1"); //证件类型1:三证合一 2：旧版营业执照

        req.setCredit_code(jsLoanRiskInfo.getGuaranteeCorpOrgcode()); //统一社会信用代码 document_type =1时必填
        File fileByOss = getFileByOss(jsLoanRiskInfo.getGuaranteeCorpQualification());
        req.setCredit_code_file(fileByOss);
        /**=======认证方式相关===========*/
        req.setVerified_mode("2");//实名认证方式 1:授权委托书2:银行对公打款
        //己方银行支行 verified_mode =2填
        req.setPublic_branch_bank(fadadaProperty.getPublicBranchBank());
        //己方银行账号 verified_mode =2填
        req.setPublic_bank_account(fadadaProperty.getPublicBankAccount());

        req.setCustomer_bank(jsLoanRiskInfo.getCorpAcctBank());//客户打款银行
        req.setCustomer_branch_bank(jsLoanRiskInfo.getCorpAcctBranchBank());//客户银行支行
        req.setCustomer_bank_account(jsLoanRiskInfo.getCorpAcct());//客户银行帐号

        req.setPay_type("2");//打款类型  1.随机码 2.随机金额

        // 本系统统一法人就是企业负责人
        req.setCompany_principal_type("1");//企业负责人身份:1.法人，2代理人

        /**=======法人信息===========*/
        req.setTransaction_id(transactionId);//交易号

        /**=======企业负责人实名存证信息===========*/
        CompanyPrincipalVerifiedMsg msg = new CompanyPrincipalVerifiedMsg();
        msg.setCustomer_id(fadadaCertiPersonal.getCustomerId());//企业负责人客户编号

        //存证描述相关
        msg.setPreservation_name("企业负责人实名存证");//存证名称
        msg.setPreservation_data_provider("北京源奉济生网络科技有限公司");//存证数据提供方

        //负责人信息相关
        msg.setDocument_type("1");//证件类型 默认是1：身份证 TODO 这个和接口文档的不一致，以哪个为准
        /**
         * 1:公安部二要素(姓名+身份证);
         * 2:手机三要素(姓名+身份证+手机号);
         * 3:银行卡三要素(姓名+身份证+银行卡);
         * 4:四要素(姓名+身份证+手机号+银行卡)
         */
        msg.setVerified_type("4");
        msg.setName(fadadaCertiPersonal.getName());//姓名
        msg.setIdcard(fadadaCertiPersonal.getIdcard());//证件号
        msg.setMobile(fadadaCertiPersonal.getMobile());
        MobileAndBankEssentialFactor mobileAndBankEssentialFactor = new MobileAndBankEssentialFactor();
        mobileAndBankEssentialFactor.setBank(fadadaCertiPersonal.getBankName());
        mobileAndBankEssentialFactor.setBankAccount(fadadaCertiPersonal.getBankNo());
        mobileAndBankEssentialFactor.setTransactionId(IdUtil.simpleUUID());
        mobileAndBankEssentialFactor.setVerifiedProvider("北京源奉济生网络科技有限公司");
        msg.setMobile_and_bank_essential_factor(mobileAndBankEssentialFactor);
        req.setCompany_principal_verified_msg(msg);//json 企业负责人实名存证信息

        String result = companyDeposit.invokeCompanyDeposit(req);
        fileByOss.delete();
        JSONObject parse = JSONObject.parseObject(result);
        String code = parse.getString("code");
        if ("1".equals(code)) {
            String evidenceNo = parse.getString("data");
            FadadaCertiCompany fadadaCertiCompany = new FadadaCertiCompany();
            init(fadadaCertiCompany);
            fadadaCertiCompany.setKycNaturalId(fadadaOpenAccount.getKycNaturalId());
            fadadaCertiCompany.setCustomerId(fadadaOpenAccount.getCustomerId());
            fadadaCertiCompany.setPreservationName("企业实名信息存证");
            fadadaCertiCompany.setPreservationDataProvider("北京源奉济生网络科技有限公司");
            fadadaCertiCompany.setDocumentType("1");
            fadadaCertiCompany.setCreditCode(jsLoanRiskInfo.getGuaranteeCorpOrgcode());
            fadadaCertiCompany.setCreditCodeFile(jsLoanRiskInfo.getGuaranteeCorpQualification());
            fadadaCertiCompany.setVerifiedMode("2");
            fadadaCertiCompany.setPublicBranchBank(fadadaProperty.getPublicBranchBank());
            fadadaCertiCompany.setPublicBankAccount(fadadaProperty.getPublicBankAccount());
            fadadaCertiCompany.setCustomerBank(jsLoanRiskInfo.getCorpAcctBank());
            fadadaCertiCompany.setCustomerBranchBank(jsLoanRiskInfo.getCorpAcctBranchBank());
            fadadaCertiCompany.setCustomerBankAccount(jsLoanRiskInfo.getCorpAcct());
            fadadaCertiCompany.setPayType("2");
            fadadaCertiCompany.setCompanyPrincipalType("1");
            fadadaCertiCompany.setTransactionId(transactionId);
            fadadaCertiCompany.setName(jsLoanRiskInfo.getGuaranteeCorpLegalname());
            fadadaCertiCompany.setIdCard(jsLoanRiskInfo.getGuaranteeCorpIdcard());
            fadadaCertiCompany.setEvidenceNo(evidenceNo);
            fadadaCertiCompany.setPrincipalPersonCustomerId(fadadaCertiPersonal.getCustomerId());
            fadadaCertiCompanyMapper.insertSelective(fadadaCertiCompany);
            log.info(result);
            return ResultUtil.success(fadadaCertiCompany, ResultEnum.FADADA_COMPANY_DEPOSIT_SUCCESS);
        } else {
            log.error(result);
            return ResultUtil.error(ResultEnum.FADADA_COMPANY_DEPOSIT_FAILURE);
        }
    }

    @Override
    public ResponseMessage companyDeposit2(String fadadaOpenAccountId, String jsLoanRiskInfoId,
                                           String kycCertiHKCompanyId, String fadadaCertiPersonalId) {

        FadadaOpenAccount fadadaOpenAccount = fadadaOpenAccountMapper.selectByPrimaryKey(fadadaOpenAccountId);

        JsLoanRiskInfo jsLoanRiskInfo = jsLoanRiskInfoMapper.selectByPrimaryKey(jsLoanRiskInfoId);

        KycCertiHKCompany kycCertiHKCompany = kycCertiHKCompanyMapper.selectByPrimaryKey(kycCertiHKCompanyId);

        FadadaCertiPersonal fadadaCertiPersonal = fadadaCertiPersonalMapper.selectByPrimaryKey(fadadaCertiPersonalId);

        Example example = new Example(KycCertiLinkFile.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("priId", kycCertiHKCompany.getId());
        KycCertiLinkFile kycCertiLinkFile = kycCertiLinkFileMapper.selectOneByExample(example);

        CompanyDeposit companyDeposit = new CompanyDeposit(fadadaProperty.getAppId(),fadadaProperty.getAppSecret(),fadadaProperty.getVersion(),fadadaProperty.getHost());
        CompanyDepositReq req = new CompanyDepositReq();
        req.setCustomer_id(fadadaOpenAccount.getCustomerId());

        String transactionId = IdUtil.simpleUUID();
        String applyNum = IdUtil.simpleUUID();

        /**=======存证相关===========*/
        req.setPreservation_name("企业实名信息存证");//存证名称
        req.setPreservation_data_provider("北京源奉济生网络科技有限公司");//存证数据提供方

        req.setCompany_name(kycCertiHKCompany.getCompanyName());//企业名称

        /**=======证件相关===========*/
        req.setDocument_type("1"); //证件类型1:三证合一2：旧版营业执照

        req.setCredit_code(kycCertiHKCompany.getCompanyRegisteredCertificateNo()); //统一社会信用代码 document_type =1时必填
        //
        File fileByOss = getFileByOss(kycCertiLinkFile.getFileSavePath());
        req.setCredit_code_file(fileByOss);
        /**=======认证方式相关===========*/
        req.setVerified_mode("2");//实名认证方式 1:授权委托书2:银行对公打款
        //己方银行支行 verified_mode =2填
        req.setPublic_branch_bank(fadadaProperty.getPublicBranchBank());
        //己方银行账号 verified_mode =2填
        req.setPublic_bank_account(fadadaProperty.getPublicBankAccount());

        req.setCustomer_bank(jsLoanRiskInfo.getCorpAcctBank());//客户打款银行
        req.setCustomer_branch_bank(jsLoanRiskInfo.getCorpAcctBranchBank());//客户银行支行
        req.setCustomer_bank_account(jsLoanRiskInfo.getCorpAcct());//客户银行帐号

        req.setPay_type("2");//打款类型  1.随机码 2.随机金额

        // 本系统统一法人就是企业负责人
        req.setCompany_principal_type("1");//企业负责人身份:1.法人，2代理人

        /**=======法人信息===========*/
        req.setTransaction_id(transactionId);//交易号

        /**=======企业负责人实名存证信息===========*/
        CompanyPrincipalVerifiedMsg msg = new CompanyPrincipalVerifiedMsg();
        msg.setCustomer_id(fadadaCertiPersonal.getCustomerId());//企业负责人客户编号

        //存证描述相关
        msg.setPreservation_name("企业负责人实名存证");//存证名称
        msg.setPreservation_data_provider("北京源奉济生网络科技有限公司");//存证数据提供方

        //负责人信息相关
        msg.setDocument_type("1");//证件类型 默认是1：身份证 TODO 这个和接口文档的不一致，以哪个为准
        /**
         * 1:公安部二要素(姓名+身份证);
         * 2:手机三要素(姓名+身份证+手机号);
         * 3:银行卡三要素(姓名+身份证+银行卡);
         * 4:四要素(姓名+身份证+手机号+银行卡)
         */
        msg.setVerified_type("4");
        msg.setName(fadadaCertiPersonal.getName());//姓名
        msg.setIdcard(fadadaCertiPersonal.getIdcard());//证件号
        msg.setMobile(fadadaCertiPersonal.getMobile());
        MobileAndBankEssentialFactor mobileAndBankEssentialFactor = new MobileAndBankEssentialFactor();
        mobileAndBankEssentialFactor.setBank(fadadaCertiPersonal.getBankName());
        mobileAndBankEssentialFactor.setBankAccount(fadadaCertiPersonal.getBankNo());
        mobileAndBankEssentialFactor.setTransactionId(IdUtil.simpleUUID());
        mobileAndBankEssentialFactor.setVerifiedProvider("北京源奉济生网络科技有限公司");
        msg.setMobile_and_bank_essential_factor(mobileAndBankEssentialFactor);
        req.setCompany_principal_verified_msg(msg);//json 企业负责人实名存证信息

        String result = companyDeposit.invokeCompanyDeposit(req);
        fileByOss.delete();

        JSONObject parse = JSONObject.parseObject(result);
        String code = parse.getString("code");
        if ("1".equals(code)) {
            String evidenceNo = parse.getString("data");
            FadadaCertiCompany fadadaCertiCompany = new FadadaCertiCompany();
            init(fadadaCertiCompany);
            fadadaCertiCompany.setCustomerId(fadadaOpenAccount.getCustomerId());
            fadadaCertiCompany.setPreservationName("企业实名信息存证");
            fadadaCertiCompany.setPreservationDataProvider("北京源奉济生网络科技有限公司");
            fadadaCertiCompany.setDocumentType("1");
            fadadaCertiCompany.setCreditCode(jsLoanRiskInfo.getGuaranteeCorpOrgcode());
            fadadaCertiCompany.setCreditCodeFile(jsLoanRiskInfo.getGuaranteeCorpQualification());
            fadadaCertiCompany.setVerifiedMode("2");
            fadadaCertiCompany.setPublicBranchBank(fadadaProperty.getPublicBranchBank());
            fadadaCertiCompany.setPublicBankAccount(fadadaProperty.getPublicBankAccount());
            fadadaCertiCompany.setCustomerBank(jsLoanRiskInfo.getCorpAcctBank());
            fadadaCertiCompany.setCustomerBranchBank(jsLoanRiskInfo.getCorpAcctBranchBank());
            fadadaCertiCompany.setCustomerBankAccount(jsLoanRiskInfo.getCorpAcct());
            fadadaCertiCompany.setPayType("2");
            fadadaCertiCompany.setCompanyPrincipalType("1");
            fadadaCertiCompany.setTransactionId(transactionId);
            fadadaCertiCompany.setName(jsLoanRiskInfo.getGuaranteeCorpLegalname());
            fadadaCertiCompany.setIdCard(jsLoanRiskInfo.getGuaranteeCorpIdcard());
            fadadaCertiCompany.setEvidenceNo(evidenceNo);
            fadadaCertiCompany.setPrincipalPersonCustomerId(fadadaCertiPersonal.getCustomerId());
            fadadaCertiCompanyMapper.insertSelective(fadadaCertiCompany);
            log.info(result);
            return ResultUtil.success(fadadaCertiCompany, ResultEnum.FADADA_COMPANY_DEPOSIT_SUCCESS);
        } else {
            log.error(result);
            return ResultUtil.error(ResultEnum.FADADA_COMPANY_DEPOSIT_FAILURE);
        }
    }

    @Override
    public ResponseMessage applyClientNumCert(String fadadaCertiPersonalId) {
        FadadaCertiPersonal fadadaCertiPersonal = fadadaCertiPersonalMapper.selectByPrimaryKey(fadadaCertiPersonalId);

        ApplyClientNumCert applyClientNumCert = new ApplyClientNumCert(fadadaProperty.getAppId(),fadadaProperty.getAppSecret(),fadadaProperty.getVersion(),fadadaProperty.getHost());
        String result = applyClientNumCert.invokeapplyClinetNumcert(fadadaCertiPersonal.getCustomerId(), fadadaCertiPersonal.getEvidenceNo());
        JSONObject parse = JSONObject.parseObject(result);
        String code = parse.getString("code");
        if ("1".equals(code)) {
            fadadaCertiPersonal.setApplyCa(true);
            fadadaCertiPersonalMapper.updateByPrimaryKeySelective(fadadaCertiPersonal);
            log.info(result);
            return ResultUtil.success(fadadaCertiPersonal, ResultEnum.FADADA_APPLAY_CA_SUCCESS);
        } else {
            fadadaCertiPersonal.setApplyCa(false);
            log.error(result);
            return ResultUtil.error(ResultEnum.FADADA_APPLAY_CA_FAILURE);
        }
    }

    @Override
    public ResponseMessage applyClientNumCert2(String fadadaCertiCompanyId) {
        FadadaCertiCompany fadadaCertiCompany = fadadaCertiCompanyMapper.selectByPrimaryKey(fadadaCertiCompanyId);

        ApplyClientNumCert applyClientNumCert = new ApplyClientNumCert(fadadaProperty.getAppId(),fadadaProperty.getAppSecret(),fadadaProperty.getVersion(),fadadaProperty.getHost());
        String result = applyClientNumCert.invokeapplyClinetNumcert(fadadaCertiCompany.getCustomerId(), fadadaCertiCompany.getEvidenceNo());
        JSONObject parse = JSONObject.parseObject(result);
        String code = parse.getString("code");
        if ("1".equals(code)) {
            fadadaCertiCompany.setApplyCa(true);
            fadadaCertiCompanyMapper.updateByPrimaryKeySelective(fadadaCertiCompany);
            log.info(result);
            return ResultUtil.success(fadadaCertiCompany, ResultEnum.FADADA_APPLAY_CA_SUCCESS);
        } else {
            fadadaCertiCompany.setApplyCa(false);
            log.error(result);
            return ResultUtil.error(ResultEnum.FADADA_APPLAY_CA_FAILURE);
        }
    }

    @Override
    public ResponseMessage customSignature(String kycNaturalId, String name, String customerId) {

        FddClientBase base = new FddClientBase(fadadaProperty.getAppId(), fadadaProperty.getAppSecret(),
                fadadaProperty.getVersion(), fadadaProperty.getHost());
        String content = name;
        String result = base.invokecustomSignature(customerId, content);
        JSONObject parse = (JSONObject)JSONObject.parse(result);
        String code = parse.getString("code");
        if ("1".equals(code)) {
            String signatureImgBase64 = parse.getJSONObject("data").getString("signature_img_base64");
            FadadaSignature fadadaSignature = new FadadaSignature();
            init(fadadaSignature);
            fadadaSignature.setKycNaturalId(kycNaturalId);
            fadadaSignature.setCustomerId(customerId);
            fadadaSignature.setContent(name);
            fadadaSignature.setSignatureImgBase64(signatureImgBase64);
            fadadaSignatureMapper.insertSelective(fadadaSignature);
            log.info(result);
            return ResultUtil.success(fadadaSignature, ResultEnum.FADADA_CUSTOM_SIGNATURE_SUCCESS);
        } else {
            log.error(result);
            return ResultUtil.error(ResultEnum.FADADA_CUSTOM_SIGNATURE_FAILURE);
        }
    }

    @Override
    public ResponseMessage addSignature2(String fadadaSignatureId) {
        FadadaSignature fadadaSignature = fadadaSignatureMapper.selectByPrimaryKey(fadadaSignatureId);
        FddClientBase base = new FddClientBase(fadadaProperty.getAppId(), fadadaProperty.getAppSecret(),
                fadadaProperty.getVersion(), fadadaProperty.getHost());
        String result = base.invokeaddSignature(fadadaSignature.getCustomerId(),fadadaSignature.getSignatureImgBase64());
        JSONObject parse = (JSONObject)JSONObject.parse(result);
        String code = parse.getString("code");
        if ("1".equals(code)) {
            String signatureId = parse.getJSONObject("data").getString("signature_id");
            fadadaSignature.setSignatureId(signatureId);
            fadadaSignatureMapper.updateByPrimaryKeySelective(fadadaSignature);
            log.info(result);
            return ResultUtil.success(fadadaSignature, ResultEnum.FADADA_ADD_SIGNATURE_SUCCESS);
        } else {
            log.error(result);
            return ResultUtil.error(ResultEnum.FADADA_ADD_SIGNATURE_FAILURE);
        }
    }

    @Override
    public ResponseMessage uploadContract(String loanNo, String fileName, String contractId, String filePath) {
        log.info("uploadContract 合同上传使用的 contractId: {}, loanNO: {}", contractId, loanNo);
        JsLoanApplyInfo jsLoanApplyInfo = new JsLoanApplyInfo();
        jsLoanApplyInfo.setLoanNo(loanNo);
        jsLoanApplyInfo = jsLoanApplyInfoMapper.selectOne(jsLoanApplyInfo);
        FadadaContract searchCondition = new FadadaContract();
        searchCondition.setLoanNo(loanNo);
        searchCondition.setDelFlag(false);
        List<FadadaContract> contracts = fadadaContractMapper.select(searchCondition);
        if (contracts.size() >= 3) {
            return ResultUtil.error(ResultEnum.FADADA_UPLOAD_CONTRACT_FAILURE.getCode(),
                    "已经存在 loanNo: "+ loanNo +" 的合同数量已经3份以上");
        }
        FddClientBase base = new FddClientBase(fadadaProperty.getAppId(), fadadaProperty.getAppSecret(),
                fadadaProperty.getVersion(), fadadaProperty.getHost());
        File file = new File(filePath);
        if (!file.exists()) {
            log.error("合同文件路径不存在: {}", file.getAbsolutePath());
        }
        String result = base.invokeUploadDocs(contractId, fileName, file, "", ".pdf");
        JSONObject parse = (JSONObject)JSONObject.parse(result);
        String code = parse.getString("code");
        String result2 = parse.getString("result");
        FadadaContract fadadaContract = new FadadaContract();
        init(fadadaContract);
        fadadaContract.setKycNaturalId(jsLoanApplyInfo.getKycNaturalId());
        fadadaContract.setLoanNo(jsLoanApplyInfo.getLoanNo());
        fadadaContract.setContractId(contractId);
        fadadaContract.setDocTitle(fileName);
        fadadaContract.setDocType(".pdf");
        fadadaContract.setFileSavePath(file.getAbsolutePath());
        if ("1000".equals(code)) {
            fadadaContract.setResult(result2);
            fadadaContractMapper.insertSelective(fadadaContract);
            log.info(result);
            return ResultUtil.success(fadadaContract, ResultEnum.FADADA_UPLOAD_CONTRACT_SUCCESS);
        } else {
            //fadadaContract.setResult(result2);
            //fadadaContractMapper.insertSelective(fadadaContract);
            log.error(result);
            return ResultUtil.error(fadadaContract, ResultEnum.FADADA_UPLOAD_CONTRACT_FAILURE);
        }
    }

    @Override
    public ResponseMessage uploadContract2(FadadaUploadContractReq fadadaUploadContractReq) {
        List<FadadaUploadContractReq.Contract> contracts = fadadaUploadContractReq.getContracts();
        for (FadadaUploadContractReq.Contract contract : contracts) {
            File tempFile;
            try {
                tempFile = File.createTempFile(contract.getFileName(), null);
                try (FileOutputStream fileOutputStream = new FileOutputStream(tempFile)) {
                    fileOutputStream.write(contract.getFileBytes());
                    fileOutputStream.flush();
                }
            } catch (IOException e) {
                e.printStackTrace();
                return ResultUtil.error(ResultEnum.FADADA_UPLOAD_CONTRACT_FAILURE);
            }
            ResponseMessage responseMessage = uploadContract(contract.getLoanNo(), contract.getFileName(), contract.getContractId(), tempFile.getAbsolutePath());
            tempFile.delete();
            if (!responseMessage.isSuccess()) {
                return responseMessage;
            }
        }
        return ResultUtil.success(ResultEnum.FADADA_UPLOAD_CONTRACT_SUCCESS);

    }

    @Override
    public ResponseMessage signContract(String kycNaturalId, String customerId, String contractId, String mobile) {

        FadadaContract fadadaContractCondition = new FadadaContract();
        fadadaContractCondition.setContractId(contractId);
        fadadaContractCondition.setDelFlag(false);
        FadadaContract fadadaContract = fadadaContractMapper.selectOne(fadadaContractCondition);

        // 通过 kycId, 客户 id, 合同 id 查看是否已经生成了签署合同
        FadadaContractSign fadadaContractSign = getFadadaContractSign(customerId, contractId);

        if (fadadaContractSign != null) {
            return ResultUtil.success(fadadaContractSign, ResultEnum.SUCCESS.getCode(), "已经触发过该用户该合同的签署");
        }

        FddClientBase base = new FddClientBase(fadadaProperty.getAppId(), fadadaProperty.getAppSecret(),
                fadadaProperty.getVersion(), fadadaProperty.getHost());
        String transactionId = IdUtil.simpleUUID();
        ExtsignReq req = new ExtsignReq();
        req.setCustomer_id(customerId);
        req.setOuth_customer_id(""); // 必须置成空字符串
        req.setTransaction_id(transactionId);
        req.setContract_id(contractId);
        req.setDoc_title(fadadaContract.getDocTitle());
        req.setReturn_url(fadadaProperty.getSignContractReturnUrl());
        req.setNotify_url(fadadaProperty.getSignContractNotifyUrl());
        String result = base.invokeExtSign(req, mobile, "", "");
        log.info(result);

        fadadaContractSign = new FadadaContractSign();
        init(fadadaContractSign);
        fadadaContractSign.setKycNaturalId(kycNaturalId);
        fadadaContractSign.setTransactionId(transactionId);
        fadadaContractSign.setContractId(contractId);
        fadadaContractSign.setCustomerId(customerId);
        // 手动签
        fadadaContractSign.setType(FadadaContractSignTypeEnum.MANUAL.ordinal());
        fadadaContractSign.setSignUrl(result);
        fadadaContractSignMapper.insertSelective(fadadaContractSign);
        return ResultUtil.success(result, ResultEnum.SUCCESS);
    }

    private FadadaContractSign getFadadaContractSign(String customerId, String contractId) {
        Example example = new Example(FadadaContractSign.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("customerId", customerId);
        criteria.andEqualTo("contractId", contractId);
        return fadadaContractSignMapper.selectOneByExample(example);
    }

    @Override
    public ResponseMessage signContract2(String customerId, String contractId) {
        FddClientBase clientbase = new FddClientBase(fadadaProperty.getAppId(), fadadaProperty.getAppSecret(),
                fadadaProperty.getVersion(), fadadaProperty.getHost());
        String transactionId = IdUtil.simpleUUID();

        FadadaContract fadadaContractCondition = new FadadaContract();
        fadadaContractCondition.setContractId(contractId);
        fadadaContractCondition.setDelFlag(false);
        FadadaContract fadadaContract = fadadaContractMapper.selectOne(fadadaContractCondition);
        // TODO 这个 acrosspage_customer_id 与 customer_id 有什么不同？注册CA 指的是实名存证吗？
        //  只返回了一个序列号。另外接口文档中的示例是不是没有新的缘故。并没有这样的方法。
        //  正常的手动签与骑缝章的手动签是不是区别只在 acrosspge_customer_id 上？
//        String sign_url = clientbase.invokeExtSign(transactionId, customerId, contractId,
//                fadadaContract.getDocTitle(), sign_keyword, fadadaProperty.getSignContractReturnUrl(), fadadaProperty.getSignContractNotifyUrl());
//        sign_url += "&acrosspage_customer_id=" + acrosspage_customer_id;
        // sign_url 是组装好的地址，请重定向到这个地址呈现签署页面给用户
        // 例如：HttpServletResponse().sendRedirect(sign_url);
        return null;
    }

    @Override
    public ResponseMessage signContractAuto(String contractId, String customerId, int y) {

        FadadaContractSign fadadaContractSign = getFadadaContractSign(customerId, contractId);
        if (fadadaContractSign != null) {
            return ResultUtil.success(fadadaContractSign, ResultEnum.SUCCESS.getCode(), "已经触发过该用户该合同的签署");
        }

        // TODO 使用关键字还是使用绝对定位？骑缝章是不是不可以使用自动签署？
        FddClientBase base = new FddClientBase(fadadaProperty.getAppId(),fadadaProperty.getAppSecret(),fadadaProperty.getVersion(),fadadaProperty.getHost());
        ExtsignReq req = new ExtsignReq();
        req.setCustomer_id(customerId);
        String transactionId = IdUtil.simpleUUID();
        req.setTransaction_id(transactionId);
        req.setContract_id(contractId);
        FadadaContract fadadaContractCondition = new FadadaContract();
        fadadaContractCondition.setContractId(contractId);
        fadadaContractCondition.setDelFlag(false);
        FadadaContract fadadaContract = fadadaContractMapper.selectOne(fadadaContractCondition);
        String clientRole = "1";
        req.setClient_role(clientRole);  // 我们应该是用 1、2、4。4 不行现在
        req.setDoc_title(fadadaContract.getDocTitle());
        // 使用关键词定位
        //req.setSign_keyword("");
        // 使用绝对定位
        req.setPosition_type("1");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("pagenum", 0);
        jsonObject.put("x", 200);
        jsonObject.put("y", y);
        JSONArray objects = new JSONArray();
        objects.add(jsonObject);
        req.setSignature_positions(objects.toJSONString());
        String result = base.invokeExtSignAuto(req);
        JSONObject parse = (JSONObject)JSONObject.parse(result);
        String code = parse.getString("code");
        String result2 = parse.getString("result");

        fadadaContractSign = new FadadaContractSign();
        init(fadadaContractSign);
        fadadaContractSign.setKycNaturalId(fadadaContract.getKycNaturalId());
        fadadaContractSign.setTransactionId(transactionId);
        fadadaContractSign.setContractId(contractId);
        fadadaContractSign.setCustomerId(customerId);
        // 自动签
        fadadaContractSign.setType(FadadaContractSignTypeEnum.AUTO.ordinal());
        fadadaContractSign.setClientRole(clientRole);
        if ("1000".equals(code)) {
            fadadaContractSign.setResult(FadadaContractSignResultEnum.SUCCESS.ordinal());
            fadadaContractSignMapper.insertSelective(fadadaContractSign);
            log.info(result);
            return ResultUtil.success(ResultEnum.SUCCESS);
        } else {
            fadadaContractSign.setResult(FadadaContractSignResultEnum.FAILURE.ordinal());
            fadadaContractSignMapper.insertSelective(fadadaContractSign);
            log.error(result);
            return ResultUtil.error(ResultEnum.ERROR);
        }
    }

    @Override
    public ResponseMessage contractArchive(String contractId) {
        FddClientBase base = new FddClientBase(fadadaProperty.getAppId(), fadadaProperty.getAppSecret(), fadadaProperty.getVersion(), fadadaProperty.getHost());
        String result = base.invokeContractFilling(contractId);
        JSONObject parse = (JSONObject) JSONObject.parse(result);
        String code = parse.getString("code");

        FadadaContract fadadaContractCondition = new FadadaContract();
        fadadaContractCondition.setContractId(contractId);
        fadadaContractCondition.setDelFlag(false);
        FadadaContract fadadaContract = fadadaContractMapper.selectOne(fadadaContractCondition);
        if ("1000".equals(code)) {
            fadadaContract.setStatus(FadadaContractStatusEnum.ARCHIVE.ordinal());
            fadadaContractMapper.updateByPrimaryKeySelective(fadadaContract);
            log.info("contractArchive: " + result);
            return ResultUtil.success(ResultEnum.SUCCESS);
        } else {
            log.error("contractArchive: " + result);
            return ResultUtil.error(ResultEnum.ERROR);
        }
    }

    @Override
    public ResponseMessage viewContract(String contractId) {
        FddClientExtra extra = new FddClientExtra(fadadaProperty.getAppId(), fadadaProperty.getAppSecret(),
                fadadaProperty.getVersion(), fadadaProperty.getHost());
        String result = extra.invokeViewPdfURL(contractId);
        return ResultUtil.success(result, ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage downloadContract(String contractId) {
        FddClientExtra extra = new FddClientExtra(fadadaProperty.getAppId(), fadadaProperty.getAppSecret(),
                fadadaProperty.getVersion(), fadadaProperty.getHost());
        String result = extra.invokeDownloadPdf(contractId);
        return ResultUtil.success(result, ResultEnum.SUCCESS);
    }

    /**
     * 注册账号
     * 一个用户，如果有多张银行卡，即四要素不同则需要给同一个用户开多个户。
     *
     * @param accountType "1" 个人 "2" 企业
     */
    private FadadaOpenAccount regAccount(String kycNaturalId, String accountType) {
        FddClientBase base = new FddClientBase(fadadaProperty.getAppId(), fadadaProperty.getAppSecret(),
                fadadaProperty.getVersion(), fadadaProperty.getHost());
        String openId = IdUtil.simpleUUID();
        String result = base.invokeregisterAccount(openId, accountType);
        JSONObject parse = JSONObject.parseObject(result);
        String code = parse.getString("code");
        if ("1".equals(code)) {
            String customerId = parse.getString("data");
            FadadaOpenAccount fadadaOpenAccount = new FadadaOpenAccount();
            init(fadadaOpenAccount);
            fadadaOpenAccount.setKycNaturalId(kycNaturalId);
            fadadaOpenAccount.setOpenId(openId);
            fadadaOpenAccount.setAccountType(accountType);
            fadadaOpenAccount.setCustomerId(customerId);
            fadadaOpenAccountMapper.insertSelective(fadadaOpenAccount);
            log.info(result);
            return fadadaOpenAccount;
        } else {
            log.error(result);
            return null;
        }
    }

    private <T extends IBaseModel> void init(T object) {
        object.setId(IdUtil.simpleUUID());
        object.setCreateId(IdUtil.simpleUUID());
        object.setCreateDts(new Date());
        object.setDelFlag(false);
    }

    private File getFileByOss(String ossPath) {
        InputStream file = jsFileForOSSSerivce.findFile(ossPath);
        try {
            File ossTemp = File.createTempFile("ossTemp", null);
            FileWriter fileWriter = FileWriter.create(ossTemp);
            fileWriter.writeFromStream(file);
            return ossTemp;
        } catch (IOException e) {
            e.printStackTrace();
            log.error("oss 文件获取失败");
            return null;
        }
    }
}
