package com.js.loan.service;

import com.js.common.constant.Constant;
import com.js.common.util.RedisUtil;
import com.js.dal.dao.mapper.JsPublicCommonCodeMapper;
import com.js.dal.dao.model.JsPublicCommonCode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import javax.annotation.Resource;
import java.util.List;

/**
 * 启动程序后初始化公共代码
 */
@Configuration
@Slf4j
public class PublicCommonRun {

    @Autowired
    private RedisUtil redisUtil;

    @Resource
    private JsPublicCommonCodeMapper jsPublicCommonCodeMapper;

    @Bean
    public void init(){

        log.info("初始化公用代码配置转换表....");
        JsPublicCommonCode jsPublicCommonCode = new JsPublicCommonCode();
        jsPublicCommonCode.setStatus("010");
        List<JsPublicCommonCode> jsPublicCommonCodes = jsPublicCommonCodeMapper.select(jsPublicCommonCode);
        log.info("初始化的数据有 List : {}" , jsPublicCommonCodes);
        for(JsPublicCommonCode entity : jsPublicCommonCodes){
            //删除
            redisUtil.del(Constant.REDIS_JS_PAY_BANCK + entity.getCode() + "_" + entity.getType());
            //新增
            redisUtil.setnx(Constant.REDIS_JS_PAY_BANCK + entity.getCode() + "_" + entity.getType(),entity.getMappingCode());
        }
        log.info("初始化完毕");
    }

}



