package com.js.loan.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.common.utils.DateUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.js.api.jsloan.service.ApiJsLoanApplicationService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.RegisterType;
import com.js.common.enums.ResultEnum;
import com.js.common.enums.TradeSubTypeEnum;
import com.js.common.enums.TradeTypeEnum;
import com.js.common.model.req.*;
import com.js.common.model.resp.JsTradesVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.RedisUtil;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.*;
import com.js.dal.dao.model.*;
import com.js.loan.mq.RabbitMQJsLoanSender;
import com.js.loan.utils.*;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import tk.mybatis.mapper.entity.Example;

import java.math.BigDecimal;
import java.util.*;

@Slf4j
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
/**
 * 贷款申请
 */
public class ApiJsLoanApplicationServiceImpl implements ApiJsLoanApplicationService {

    @Autowired
    private JsLoanApplyInfoMapper jsLoanApplyInfoMapper;

    @Autowired
    private JsLoanRiskInfoMapper jsLoanRiskInfoMapper;

    @Autowired
    private JsTradeMapper jsTradeMapper;

    @Autowired
    private KycCertiHKCompanyMapper kycCertiHKCompanyMapper;

    @Autowired
    private RabbitMQJsLoanSender rabbitMQJsLoanSender;

    @Autowired
    private LoanConfigureInfo loanConfigureInfo;

    @Autowired
    private KycCertiMainLandCompanyMapper kycCertiMainLandCompanyMapper;

    @Autowired
    private RedisUtil redisUtil;


    /**
     * 贷款申请
     */
    @Override
    public ResponseMessage loanApply(JsLoanApplyInfoReq req) {

        log.info("贷款申请开始 执行 ..KycNaturalId:{} " , req.getKycNaturalId());

        //查询该用户是否可以贷款
        JsLoanRiskInfo jsLoanRiskInfoQuery = new JsLoanRiskInfo();
        jsLoanRiskInfoQuery.setKycNaturalId(req.getKycNaturalId());
        jsLoanRiskInfoQuery.setDelFlag(false);
        jsLoanRiskInfoQuery = jsLoanRiskInfoMapper.selectOne(jsLoanRiskInfoQuery);
        if(null == jsLoanRiskInfoQuery){
            log.info("该用户未进行准入申请不可以进行贷款申请 KycNaturalId:{} " , req.getKycNaturalId());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"该用户未进行准入申请不可以进行贷款申请");
        }
        if(!jsLoanRiskInfoQuery.getStatus().equals(CommonConstant.LOAN_RISK_STATUS_ADOPT)){
            log.info("该用户准入信息未审核通过，不可以进行贷款申请 KycNaturalId:{} " , req.getKycNaturalId());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"该用户准入信息未审核通过，不可以进行贷款申请");
        }
        //判断是否有未结束的贷款信息
        JsLoanApplyInfo selectLoanApplyInfo = new JsLoanApplyInfo();
        selectLoanApplyInfo.setKycNaturalId(req.getKycNaturalId());
        selectLoanApplyInfo.setIsEnd("0");//未结束
        selectLoanApplyInfo.setDelFlag(false);
        selectLoanApplyInfo = jsLoanApplyInfoMapper.selectOne(selectLoanApplyInfo);
        if(null != selectLoanApplyInfo){
            log.info("有未处理完毕的贷款信息，请核实");
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"有未处理完毕的贷款信息，请核实");
        }
        //初始化
        req.setProductNo(loanConfigureInfo.getProductNo());
        req.setLoanNo("YFJSXD" + DateUtils.getNewDateyyyyMMddHHmmss());
        req.setApplyDate(DateUtils.getNewyyyyMMddHHmmss());
        req.setRiskNo(jsLoanRiskInfoQuery.getRiskNo());
        String bankCode = redisUtil.get(Constant.REDIS_JS_PAY_BANCK + req.getBankCode() +"_020");
        if(null == bankCode || "".equals(bankCode)){
            log.info("贷款申请获取银行信息失败,请核实绑卡信息");
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR.getCode(),"贷款申请获取银行信息失败,请核实绑卡信息");
        }
        //添加借款信息
        JsLoanApplyInfo jsLoanApplyInfo = new JsLoanApplyInfo();
        BeanUtils.copyProperties(req,jsLoanApplyInfo);
        jsLoanApplyInfo.setId(IdUtil.simpleUUID());
        if(StringUtils.isEmpty(jsLoanApplyInfo.getCertNo())){
            jsLoanApplyInfo.setCertNo(jsLoanRiskInfoQuery.getBorrowerIdcard());
        }
        jsLoanApplyInfo.setProductName(loanConfigureInfo.getProductName());
        jsLoanApplyInfo.setInterestRate(loanConfigureInfo.getInterestRate());
        jsLoanApplyInfo.setYearRate(loanConfigureInfo.getYearRate());
        jsLoanApplyInfo.setApplyDate(new Date());
        jsLoanApplyInfo.setLoanStatus(CommonConstant.LOAN_APPLY_STATUS_INIT);//等待初审
        jsLoanApplyInfo.setProductName(loanConfigureInfo.getProductName());
        jsLoanApplyInfo.setIsEnd("0");//设置未结束
        jsLoanApplyInfo.setDelFlag(false);
        jsLoanApplyInfo.setRepaymentStatus(CommonConstant.LOAN_REPAYMENT_STATUS_INIT);
        int count = jsLoanApplyInfoMapper.insertSelective(jsLoanApplyInfo);
        if(count < 1){
             log.info("贷款申请添加到数据操作失败 count{}",count);
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"贷款申请添加到数据操作失败，添加记录小于1");
        }
        //推送准入信息
        Map<String,Object> map=new HashMap();
        map.put("type",CommonConstant.CUSTOMER_LOAN_APPLY); //10客户准入 20修改  30借款  40合同签署通知
        req.setBankCode(bankCode);
        map.put("data",req);
        JSONArray array=JSONArray.fromObject(map);
        log.info("推送小贷贷款申请报文: reqMap:{}",array.toArray());
        //推送小贷
        rabbitMQJsLoanSender.loanRiskSender(array.toString());
        return ResultUtil.success(array.toString(), ResultEnum.SUCCESS);
    }

    /**
     * 放款记录查询（贷款记录详情）
     * @param loanNo
     * @param kycNaturalId
     * @return
     */
    @Override
    public ResponseMessage loanApplicationDetailed(String loanNo, String kycNaturalId) {
        //判断是否有未结束的贷款信息
        JsLoanApplyInfo selectLoanApplyInfo = new JsLoanApplyInfo();
        selectLoanApplyInfo.setKycNaturalId(kycNaturalId);
        selectLoanApplyInfo.setLoanNo(loanNo);
        selectLoanApplyInfo = jsLoanApplyInfoMapper.selectOne(selectLoanApplyInfo);
        if(null == selectLoanApplyInfo){
            log.info("未查询到贷款记录 ...loanNo:{}" ,loanNo);
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"未查询到贷款记录，请核实");
        }
        return ResultUtil.success(selectLoanApplyInfo);
    }

    @Override
    public ResponseMessage queryLoan(LoanApplicationReq loanApplicationReq) {

        if(null == loanApplicationReq){
            log.info("借款记录查询不能为空 ");
            return ResultUtil.error(ResultEnum.ERROR);
        }
        log.info("借款记录查询请求参数  loanApplicationReq:{}" ,loanApplicationReq);

        Example example=new Example(JsLoanApplyInfo.class);
        Example.Criteria criteria = example.createCriteria();
        //条件筛选
        if(null != loanApplicationReq.getLoanQueryStartTime()
                && !loanApplicationReq.getLoanQueryStartTime().equals("")
                && null != loanApplicationReq.getLoanQueryEndTime()
                && !loanApplicationReq.getLoanQueryEndTime().equals("")){
            criteria.andBetween("applyDate",loanApplicationReq.getLoanQueryStartTime(),DateUtils.getDateEndDay(loanApplicationReq.getLoanQueryEndTime()));
        }
        if(null != loanApplicationReq.getLoanTermDay() && !loanApplicationReq.getLoanTermDay().equals("")){
            criteria.andEqualTo("repaymentDate",loanApplicationReq.getLoanTermDay());//
        }
        if(null != loanApplicationReq.getRepayType() && !loanApplicationReq.getRepayType().equals("")){
            criteria.andEqualTo("repayType",loanApplicationReq.getRepayType());//
        }
        if(null != loanApplicationReq.getLoanStatus() && !loanApplicationReq.getLoanStatus().equals("")){
            List<String> loanStatusList = new ArrayList<>();
            if(CommonConstant.QUERY_LOAN_APPLY_STATUS_INIT.equals(loanApplicationReq.getLoanStatus())){ //申请中
                loanStatusList.add(CommonConstant.LOAN_APPLY_STATUS_INIT);
                loanStatusList.add(CommonConstant.LOAN_APPLY_STATUS_I_VERIFY_ADOPT);
                loanStatusList.add(CommonConstant.LOAN_APPLY_STATUS_I_VERIFY_ADOPT);
                loanStatusList.add(CommonConstant.LOAN_APPLY_STATUS_C_VERIFY_ADOPT);
                loanStatusList.add(CommonConstant.LOAN_APPLY_STATUS_CONTRACT_ADOPT);
            }else if(CommonConstant.QUERY_LOAN_APPLY_STATUS_UES.equals(loanApplicationReq.getLoanStatus())){ //使用中
                loanStatusList.add(CommonConstant.LOAN_APPLY_STATUS_REPAYMENT_ING);
            }else if(CommonConstant.QUERY_LOAN_APPLY_STATUS_SETTLE.equals(loanApplicationReq.getLoanStatus())){//已结清
                loanStatusList.add(CommonConstant.LOAN_APPLY_STATUS_NORMAL_SETTLE);
                loanStatusList.add(CommonConstant.LOAN_APPLY_STATUS_RED_SETTLE);
                loanStatusList.add(CommonConstant.LOAN_APPLY_STATUS_NORMAL_ADVANCE_SETTLE);
                loanStatusList.add(CommonConstant.LOAN_APPLY_STATUS_COLL_ADVANCE_SETTLE);
            }else if(CommonConstant.QUERY_LOAN_APPLY_STATUS_EXPECT.equals(loanApplicationReq.getLoanStatus())){ //已逾期
                loanStatusList.add(CommonConstant.LOAN_APPLY_STATUS_BEOVERDUE);
            }else if(CommonConstant.QUERY_LOAN_APPLY_STATUS_GRANT.equals(loanApplicationReq.getLoanStatus())){ //发放中
                loanStatusList.add(CommonConstant.LOAN_APPLY_STATUS_LOAN_ING);
            }else if(CommonConstant.QUERY_LOAN_APPLY_STATUS_ERRER.equals(loanApplicationReq.getLoanStatus())){ //失败
                loanStatusList.add(CommonConstant.LOAN_APPLY_STATUS_I_VERIFY_REFUSE);
                loanStatusList.add(CommonConstant.LOAN_APPLY_STATUS_C__VERIFY_ADOPT);
                loanStatusList.add(CommonConstant.LOAN_APPLY_STATUS_CONTRACT_ERROR);
                loanStatusList.add(CommonConstant.LOAN_APPLY_STATUS_LOAN_REFUSE);
            }
            log.info("请求的贷款状态为loanStatusList:{}",loanStatusList);
            criteria.andIn("loanStatus", loanStatusList);
        }
        criteria.andEqualTo("kycNaturalId",loanApplicationReq.getKycNaturalId());
        criteria.andEqualTo("delFlag",false);
        PageHelper.startPage(loanApplicationReq);
        List<JsLoanApplyInfo> jsLoanApplyInfos =  jsLoanApplyInfoMapper.selectByExample(example);
        PageInfo<JsLoanApplyInfo> jsLoanApplyInfoPageInfo = new PageInfo<>(jsLoanApplyInfos);
        return ResultUtil.success(jsLoanApplyInfoPageInfo);
    }

    @Override
    public ResponseMessage loanDetailed(String loanNo,String kycNaturalId) {

        log.info("请求参loanNO:{}",loanNo);
        //判断贷款编号
        if(null == loanNo || "".equals(loanNo)){
            log.info(" 借款明细查询请求贷款编号为空");
            return ResultUtil.error(ResultEnum.ERROR.getCode()," 借款明细查询请求贷款编号为空");
        }
        //请求贷款
        Map<String,String> reqMap = new HashMap<>();
        reqMap.put("loanNo",loanNo);
        log.info("借款明细查询请求贷款编号参数：loanNo{}" ,loanNo);
        String  paramString= JSON.toJSONString(reqMap);
        log.info("请求地址url:{}",loanConfigureInfo.getDetailLoanUrl());
        String resultString = HttpUtil.post(loanConfigureInfo.getDetailLoanUrl(),paramString);
        log.info("请求贷款返回结构：resultString{}",resultString);
        JSONObject jSONObject = JSON.parseObject(resultString);
        return ResultUtil.success(jSONObject);
    }

    @Override
    public ResponseMessage queryContract(String loanNo,String kycNaturalId) {
        log.info("查询合同-借款基本信息... loanNo:{},keyNaturalId:{}",loanNo,kycNaturalId);
        //查询借款信息
        JsLoanApplyInfo jsLoanApplyInfo = new JsLoanApplyInfo();
        jsLoanApplyInfo.setKycNaturalId(kycNaturalId);
        jsLoanApplyInfo.setLoanNo(loanNo);
        jsLoanApplyInfo = jsLoanApplyInfoMapper.selectOne(jsLoanApplyInfo);
        if(null == jsLoanApplyInfo){
            log.info("查询合同 - 未查询到贷款申请信息... loanNo:{},keyNaturalId:{}",loanNo,kycNaturalId);
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"查询合同 - 未查询到贷款申请信息");
        }
        Map<String,Object> resMap = new HashMap<>();
        resMap.put("loanDays",jsLoanApplyInfo.getLoanDays());
        resMap.put("repaymentDate",jsLoanApplyInfo.getRepaymentDate());
        resMap.put("interestRate",jsLoanApplyInfo.getInterestRate());
        resMap.put("repayType",jsLoanApplyInfo.getRepayType());
        resMap.put("loanNo",loanNo);
        resMap.put("productName",jsLoanApplyInfo.getProductName());
        resMap.put("applyDate",jsLoanApplyInfo.getApplyDate());
        return ResultUtil.success(resMap);
    }

    @Override
    public ResponseMessage loanContract(String loanNo, String kycNaturalId) {

        log.info("查询合同参数loanNo:{},keyNaturalId:{}",loanNo,kycNaturalId);
        //查询借款信息
        JsLoanApplyInfo jsLoanApplyInfo = new JsLoanApplyInfo();
        jsLoanApplyInfo.setKycNaturalId(kycNaturalId);
        jsLoanApplyInfo.setLoanNo(loanNo);
        jsLoanApplyInfo = jsLoanApplyInfoMapper.selectOne(jsLoanApplyInfo);
        if(null == jsLoanApplyInfo){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"未查询到贷款申请信息");
        }
        if(!jsLoanApplyInfo.getLoanStatus().equals(CommonConstant.LOAN_APPLY_STATUS_C_VERIFY_ADOPT)){ //是否复审通过
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"贷款申请提额信息未审核通过，不能签署合同");
        }
        Map<String,Object> resMap = new HashMap();
        resMap.put("loanNo",jsLoanApplyInfo.getLoanNo());
        resMap.put("adoptAmt",jsLoanApplyInfo.getAdoptAmt());//审核通过金额
        resMap.put("repayWay",jsLoanApplyInfo.getRepayType()); //还款方式
        if(jsLoanApplyInfo.getRealAmt().compareTo(BigDecimal.ZERO) == 0){
            resMap.put("realAmt",jsLoanApplyInfo.getAdoptAmt());
        }else{
            resMap.put("realAmt",jsLoanApplyInfo.getRealAmt());
        }
        //日利费率
        resMap.put("interestRate",jsLoanApplyInfo.getInterestRate());
        //最早还款日期
        resMap.put("startDate",DateUtils.getNewDate());
        //最晚还款日期
        resMap.put("endDate",DateUtils.DateToStr(DateUtils.addDay(new Date(),jsLoanApplyInfo.getLoanDays())));
        return ResultUtil.success(resMap);
    }

    @Override
    public ResponseMessage signContract(SignContractReq signContractReq,KycNaturalVO kycNaturalVO) {
        log.info("签署合同请求参数signContractReq:{} ",signContractReq);
        Map<String,Object> resMap = new HashMap<>();
        //查询准入信息是否审核通过
        JsLoanRiskInfo jsLoanRiskInfo = new JsLoanRiskInfo();
        jsLoanRiskInfo.setKycNaturalId(kycNaturalVO.getId());
        jsLoanRiskInfo.setDelFlag(false);
        jsLoanRiskInfo = jsLoanRiskInfoMapper.selectOne(jsLoanRiskInfo);
        if(jsLoanRiskInfo == null){
            log.info("未查询到贷款准入信息 loanNo:{}",signContractReq.getLoanNo());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"未查询到贷款准入信息");
        }
        //查询借款信息
        JsLoanApplyInfo jsLoanApplyInfo = new JsLoanApplyInfo();
        jsLoanApplyInfo.setLoanNo(signContractReq.getLoanNo());
        jsLoanApplyInfo.setKycNaturalId(kycNaturalVO.getId());
        jsLoanApplyInfo = jsLoanApplyInfoMapper.selectOne(jsLoanApplyInfo);
        if(null == jsLoanApplyInfo){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"签署合同-未查询到贷款申请信息");
        }
        if(!jsLoanApplyInfo.getLoanStatus().equals(CommonConstant.LOAN_APPLY_STATUS_C_VERIFY_ADOPT)){ //是否复审通过
            log.info("贷款申请提额信息未审核通过，不能签署合同 loanNo:{}",signContractReq.getLoanNo());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"贷款申请提额信息未审核通过，不能签署合同");
        }

        //借款金额小于100元
        if(signContractReq.getRealAmt().compareTo(new BigDecimal(100)) == -1){
            log.info("实际贷款金额小于指定金额大小，不能签署合同 realAmt:{}",signContractReq.getRealAmt());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"实际贷款金额小于指定金额大小，不能签署合同");
        }
        if(signContractReq.getRealAmt().compareTo(jsLoanApplyInfo.getAdoptAmt()) == 1){
            log.info("实际贷款金额大于贷款审批金额，不能签署合同 realAmt:{},adoptAmt:{}",signContractReq.getRealAmt(),jsLoanApplyInfo.getAdoptAmt());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"实际贷款金额大于贷款审批金额，不能签署合同");
        }
        //更新实际放款金额
        JsLoanApplyInfo updateJsLoanApplyInfo = new JsLoanApplyInfo();
        updateJsLoanApplyInfo.setRealAmt(signContractReq.getRealAmt());
        Example example=new Example(JsLoanApplyInfo.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("kycNaturalId",kycNaturalVO.getId());
        criteria.andEqualTo("loanNo",signContractReq.getLoanNo());
        int count = jsLoanApplyInfoMapper.updateByExampleSelective(updateJsLoanApplyInfo,example);
        if(count < 1){
            log.info("更新贷款实际金额失败 loanNo:{},realAmt:{}",signContractReq.getLoanNo(),signContractReq.getRealAmt());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"更新贷款实际金额失败");
        }

        //借款协议含担保条款parameter
        Map<String, Object> parameter = new HashMap<>();
        //服务合同含担保条款parameter2
        Map<String, Object> parameter2 = new HashMap<>();
        //委托扣款授权书parameter3
        Map<String, Object> parameter3 = new HashMap<>();
        parameter.put("borrowerName",jsLoanRiskInfo.getBorrowerName());
        parameter.put("borrowerIdcard",jsLoanRiskInfo.getBorrowerIdcard());
        parameter.put("borrowerAddress",jsLoanRiskInfo.getBorrowerAddress());
        parameter.put("borrowerPhone",jsLoanRiskInfo.getBorrowerPhone());
        parameter.put("acctNo",jsLoanApplyInfo.getAcctNo());
        parameter.put("guaranteeCorp",jsLoanRiskInfo.getGuaranteeCorp());
        parameter.put("guaranteeCorpLegalname",jsLoanRiskInfo.getGuaranteeCorpLegalname());
        parameter.put("guaranteeCorpOrgcode",jsLoanRiskInfo.getGuaranteeCorpOrgcode());

        String contractName = null;
        String contractName2 = null;
        //判断是否是香港企业
        RegisterType registerType = kycNaturalVO.getRegisterType();
        if(registerType == RegisterType.HK_COMPANY) {
            KycCertiHKCompany kycCertiHKCompanyQuery = new KycCertiHKCompany();
            kycCertiHKCompanyQuery.setKycNaturalId(kycNaturalVO.getId());
            kycCertiHKCompanyQuery = kycCertiHKCompanyMapper.selectOne(kycCertiHKCompanyQuery);
            //借款协议含担保条款
            contractName = loanConfigureInfo.getContractNameHk();
            parameter.put("companyName",kycCertiHKCompanyQuery.getCompanyName());
            parameter.put("directorName",kycCertiHKCompanyQuery.getDirectorName());
            parameter.put("companyRegisteredCertificateNo",kycCertiHKCompanyQuery.getCompanyRegisteredCertificateNo());
            //服务合同含担保条款
            contractName2 = loanConfigureInfo.getContractName2Hk();
            parameter2.put("companyName",kycCertiHKCompanyQuery.getCompanyName());
            parameter2.put("directorName",kycCertiHKCompanyQuery.getDirectorName());
            //委托扣款授权书
            parameter3.put("companyName",kycCertiHKCompanyQuery.getCompanyName());
            parameter3.put("contractCompanyDate",DateUtils.getNewDateCN());
        }else{
            if(registerType == RegisterType.MAINLAND_COMPANY){
                KycCertiMainLandCompany kycCertiMainLandCompanyQuery = new KycCertiMainLandCompany();
                kycCertiMainLandCompanyQuery.setKycNaturalId(kycNaturalVO.getId());
                kycCertiMainLandCompanyQuery = kycCertiMainLandCompanyMapper.selectOne(kycCertiMainLandCompanyQuery);
                //委托扣款授权书
                parameter3.put("companyName",kycCertiMainLandCompanyQuery.getCompanyName());
                parameter3.put("contractCompanyDate",DateUtils.getNewDateCN());
            }else{
                parameter3.put("companyName","");
                parameter3.put("contractCompanyDate","");
            }
            //借款协议含担保条款
            contractName = loanConfigureInfo.getContractNameHolder();
            //服务合同含担保条款
            contractName2 =  loanConfigureInfo.getContractName2Holder();
        }
        //借款协议含担保条款
        parameter.put("contractName", contractName);
        //服务合同含担保条款
        parameter2.put("contractName", contractName2);

        parameter.put("realAmt",signContractReq.getRealAmt());
        parameter.put("rateYear",new BigDecimal(jsLoanApplyInfo.getYearRate()).multiply(new BigDecimal(100)).setScale(2)); //贷款利息：年利率
        parameter.put("bankName",jsLoanApplyInfo.getBankName());
        parameter.put("acctName",jsLoanApplyInfo.getAcctName());
        parameter.put("borrowerEmail",jsLoanRiskInfo.getBorrowerEmail());
        byte[]  bytesParameter = ContratUtils.contrat(parameter,loanConfigureInfo.getContractUrl());

        //借款协议含担保条款
        String borrowerIdcardNum = jsLoanRiskInfo.getBorrowerIdcard().substring(jsLoanRiskInfo.getBorrowerIdcard().length()-4,jsLoanRiskInfo.getBorrowerIdcard().length());
        String contractNo ="SA" + DateUtils.getNewDateyyyyMMddHHmmss() + RandomUtils.getRandom(100,999) + borrowerIdcardNum;

        //服务合同含担保条款
        String contractNo2 = "LA" + DateUtils.getNewDateyyyyMMddHHmmss() + RandomUtils.getRandom(100,999) + borrowerIdcardNum;
        parameter2.put("contractNo",contractNo2);
        parameter2.put("contractDate", DateUtils.getNewDateCN());
        parameter2.put("borrowerName",jsLoanRiskInfo.getBorrowerName());
        parameter2.put("borrowerIdcard",jsLoanRiskInfo.getBorrowerIdcard());
        parameter2.put("guaranteeCorp",jsLoanRiskInfo.getGuaranteeCorp());
        parameter2.put("guaranteeCorpLegalname",jsLoanRiskInfo.getGuaranteeCorpLegalname());
        byte[]  bytesParameter2 = ContratUtils.contrat(parameter2,loanConfigureInfo.getContractUrl());

        //委托扣款授权书
        String contractNo3 = "EDA" + DateUtils.getNewDateyyyyMMddHHmmss() + RandomUtils.getRandom(100,999) + borrowerIdcardNum;
        String contractName3 = loanConfigureInfo.getContractName3();
        //parameter3.put("authorizerIdNo",jsLoanRiskInfo.getBorrowerIdcard());
        parameter3.put("borrowerAddress",jsLoanRiskInfo.getBorrowerAddress());
        parameter3.put("authorizer",jsLoanRiskInfo.getBorrowerName());
        parameter3.put("signDate",DateUtils.getNewDateCN());

        parameter3.put("contractName",contractName3);
        parameter3.put("borrowerIdcard",jsLoanRiskInfo.getBorrowerIdcard());
        parameter3.put("agreementDate",DateUtils.getNewDateCN());
        parameter3.put("agreementNo",contractNo2); //本人与北京源奉济生网络科技有限公司于 平台服务合同
        parameter3.put("contractDate",DateUtils.getNewDateCN());
        parameter3.put("contractNo",contractNo);
        parameter3.put("jsMerchant",loanConfigureInfo.getChannelChinapnrId());
        parameter3.put("loanMerchant",loanConfigureInfo.getChannelSmallLoanId());
        byte[]  bytesParameter3 = ContratUtils.contrat(parameter3,loanConfigureInfo.getContractUrl());

        //参数fadada签章
        FadadaUploadContractReq fadadaUploadContractReq = new FadadaUploadContractReq();
        List<FadadaUploadContractReq.Contract> contractList = new ArrayList<>();
        FadadaUploadContractReq.Contract contract = fadadaUploadContractReq.new Contract();
        contract.setContractId(contractNo);
        contract.setFileBytes(bytesParameter);
        contract.setFileName(contractName);
        contract.setLoanNo(signContractReq.getLoanNo());
        contractList.add(contract);
        FadadaUploadContractReq.Contract contract2 = fadadaUploadContractReq.new Contract();
        contract2.setContractId(contractNo2);
        contract2.setFileName(contractName2);
        contract2.setFileBytes(bytesParameter2);
        contract2.setLoanNo(signContractReq.getLoanNo());
        contractList.add(contract2);
        FadadaUploadContractReq.Contract contract3 = fadadaUploadContractReq.new Contract();
        contract3.setFileBytes(bytesParameter3);
        contract3.setFileName(contractName3);
        contract3.setLoanNo(signContractReq.getLoanNo());
        contract3.setContractId(contractNo3);
        contractList.add(contract3);
        fadadaUploadContractReq.setContracts(contractList);

        //返回Map
        resMap.put("riskNo",jsLoanRiskInfo.getRiskNo());
        resMap.put("loanNo",jsLoanApplyInfo.getLoanNo());
        resMap.put("fadadaUploadContractReq",fadadaUploadContractReq);
        log.info("合同号 contractNo：{}，contractNo2：{}，contractNo3{}",contractNo,contractNo2,contractNo3);
        log.info("组装发大大签署合同成功reqMap-riskNo:{},loanNO:{}",resMap.get("riskNo"),resMap.get("loanNo"));
        return ResultUtil.success(resMap,ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage capitalDetailed(LoanCapitalReq loanCapitalReq) {

        Map<String,Object> reqMap = new HashMap<>();
       if(null != loanCapitalReq.getFromTradeDate() && !loanCapitalReq.getFromTradeDate().equals("")){
           reqMap.put("fromTradeDate",loanCapitalReq.getFromTradeDate());
       }
        if(null != loanCapitalReq.getToTradeDate() && !loanCapitalReq.getToTradeDate().equals("")){
            reqMap.put("toTradeDate",loanCapitalReq.getToTradeDate());
        }
        if(StringUtils.isNotEmpty(loanCapitalReq.getTradeType())){
            reqMap.put("tradeType",loanCapitalReq.getTradeType());
        }
        reqMap.put("kycNaturalId",loanCapitalReq.getKycNaturalId());
        reqMap.put("pageNum",loanCapitalReq.getPageNum()+"");
        reqMap.put("pageSize",loanCapitalReq.getPageSize()+"");
        log.info("资金明细查询，请求记录：resMap:{}",reqMap);
        String  paramString= JSON.toJSONString(reqMap);
        String resultString = HttpUtil.post(loanConfigureInfo.getRecordsLoanUrl(),paramString);
        JSONObject jSONObject = JSON.parseObject(resultString);
        return ResultUtil.success(jSONObject);
    }

    @Override
    public ResponseMessage capitalDetailedDetails(String loanNo, String applyId) {

        //判断贷款编号
        if(StringUtils.isEmpty(loanNo)){
            log.info(" 资金明细详情查询请求贷款编号为空");
            return ResultUtil.error(ResultEnum.ERROR.getCode()," 资金明细详情查询请求贷款编号为空");
        }
        if(StringUtils.isEmpty(applyId)){
            log.info(" 资金明细详情查询资金明细Id不能为空");
            return ResultUtil.error(ResultEnum.ERROR.getCode()," 资金明细详情查询资金明细Id不能为空");
        }
        //请求贷款
        Map<String,String> reqMap = new HashMap<>();
        reqMap.put("loanNo",loanNo);
        reqMap.put("applyId",applyId);
        log.info("资金明细详情查询查询请求loanNo：{}，applyId:{}" ,loanNo,applyId);
        String  paramString= JSON.toJSONString(reqMap);
        String resultString = HttpUtil.post(loanConfigureInfo.getDetailLoanUrl(),paramString);
        JSONObject jSONObject = JSON.parseObject(resultString);
        return ResultUtil.success(jSONObject);
    }

    /**
     * 合同归档
     * @param loanNo
     * @param kycNaturalVO
     * @return
     */
    @Override
    public ResponseMessage signVerification(String loanNo, KycNaturalVO kycNaturalVO) {
        log.info("合同归档成功后更新状态 loanNo:{}",loanNo);

        //查询准入信息是否审核通过
        JsLoanRiskInfo jsLoanRiskInfo = new JsLoanRiskInfo();
        jsLoanRiskInfo.setKycNaturalId(kycNaturalVO.getId());
        jsLoanRiskInfo.setDelFlag(false);
        jsLoanRiskInfo = jsLoanRiskInfoMapper.selectOne(jsLoanRiskInfo);
        if(jsLoanRiskInfo == null){
            log.info("未查询到贷款准入信息 loanNo:{}",loanNo);
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"未查询到贷款准入信息");
        }
        //查询数据
        JsLoanApplyInfo jsLoanApplyInfo = new JsLoanApplyInfo();
        jsLoanApplyInfo.setLoanNo(loanNo);
        jsLoanApplyInfo.setKycNaturalId(kycNaturalVO.getId());
        jsLoanApplyInfo.setLoanStatus(CommonConstant.LOAN_APPLY_STATUS_C_VERIFY_ADOPT);//复审通过
        jsLoanApplyInfo = jsLoanApplyInfoMapper.selectOne(jsLoanApplyInfo);
        if(null == jsLoanApplyInfo){
            log.info("未查询到复审通过需签合同的借款单 loanNo:{}",loanNo);
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"未查询到复审通过需签合同的借款单");
        }
        Example example=new Example(JsLoanApplyInfo.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("loanNo",loanNo);
        criteria.andEqualTo("kycNaturalId",kycNaturalVO.getId());
        JsLoanApplyInfo updateJsLoanApplyInfo = new JsLoanApplyInfo();
        updateJsLoanApplyInfo.setLoanStatus(CommonConstant.LOAN_APPLY_STATUS_CONTRACT_ADOPT); //合同签署成功
        int count = jsLoanApplyInfoMapper.updateByExampleSelective(updateJsLoanApplyInfo,example);
        if(count < 1){
            log.info("更新贷款合同状态失败 loanNo:{}",loanNo);
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"更新贷款合同状态失败");
        }
        //合同签署成功推送MQ到小贷
        //推送准入信息
        Map<String,Object> mqMap = new HashMap();
        mqMap.put("loanNo",loanNo);
        mqMap.put("loanStatus",CommonConstant.LOAN_APPLY_STATUS_CONTRACT_ADOPT);
        mqMap.put("kycNaturalId",kycNaturalVO.getId());
        mqMap.put("realAmt",jsLoanApplyInfo.getRealAmt() + "");
        mqMap.put("riskNo",jsLoanRiskInfo.getRiskNo());
        Map<String,Object> map=new HashMap();
        map.put("type",CommonConstant.CUSTOMER_LOAN_CONTRACT); //10客户准入 20修改  30借款 40电子签章
        map.put("data",mqMap);
        JSONArray array=JSONArray.fromObject(map);
        //推送小贷
        log.info("推送贷款端电子签章签署信息 map:{}",array.toString());
        rabbitMQJsLoanSender.loanRiskSender(array.toString());
        return ResultUtil.success(ResultEnum.SUCCESS);
    }
}
