package com.js.loan.properties;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Getter
@Setter
@ConfigurationProperties(prefix = "fadada")
@Component
public class FadadaProperty {

    private String appId;
    private String appSecret;
    private String myCoustomId; // 我们自己的客户编号
    private String myLoanCoustomId; // 小贷的客户编号
    private String version;
    private String host;
    private String signContractReturnUrl;
    private String signContractNotifyUrl;
    // 我方对公银行卡名称
    private String publicBranchBank;
    // 我方对公银行卡号
    private String publicBankAccount;

}
