package com.js.loan.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jsloan.service.ApiJsLoanRepaymentService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.enums.SiteEnum;
import com.js.common.model.req.RepaymentLoanReq;
import com.js.common.model.req.RepaymentOperationReq;
import com.js.common.model.req.RepaymentTrialReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsLoanApplyInfoMapper;
import com.js.dal.dao.mapper.JsLoanPlanDetailMapper;
import com.js.dal.dao.mapper.JsLoanRiskInfoMapper;
import com.js.dal.dao.mapper.JsPaySunrateBankMapper;
import com.js.dal.dao.model.JsLoanApplyInfo;
import com.js.dal.dao.model.JsLoanPlanDetail;
import com.js.dal.dao.model.JsLoanRiskInfo;
import com.js.loan.utils.DateUtils;
import com.js.loan.utils.HttpUtil;
import com.js.loan.utils.LoanConfigureInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;
import tk.mybatis.mapper.entity.Example;

import java.math.BigDecimal;
import java.util.*;

@Slf4j
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
public class ApiJsLoanRepaymentServiceImpl implements ApiJsLoanRepaymentService {

    @Autowired
    JsPaySunrateBankMapper jsPaySunrateBankMapper;

    @Autowired
    JsLoanApplyInfoMapper jsLoanApplyInfoMapper;

    @Autowired
    private LoanConfigureInfo loanConfigureInfo;

    @Autowired
    private JsLoanPlanDetailMapper jsLoanPlanDetailMapper;

    @Autowired
    private JsLoanRiskInfoMapper jsLoanRiskInfoMapper;

    /**
     * 还款明细查询
     * @return
     */
    @Override
    public ResponseMessage detailed(String loanNo) {
        //判断贷款编号
        if(StringUtils.isEmpty(loanNo)){
             log.info(" 还款明细查询请求贷款编号未空");
            return ResultUtil.error(ResultEnum.ERROR.getCode()," 还款明细查询请求贷款编号未空");
        }

        //请求贷款
        Map<String,String> reqMap = new HashMap<>();
        reqMap.put("loanNo",loanNo);
        String  paramString= JSON.toJSONString(reqMap);
        String resultString = HttpUtil.post(loanConfigureInfo.getDetailLoanUrl(),paramString);
        JSONObject jSONObject = JSON.parseObject(resultString);
        log.info("还款明细返回结果resultString:{}",resultString);
        return ResultUtil.success(jSONObject);
    }
    /**
     * 待还款记录查询
     * @return
     */
    @Override
    public ResponseMessage loanSituation(RepaymentLoanReq repaymentLoanReq) {
        Map<String,Object> reqMap = new HashMap<>();
        if(null != repaymentLoanReq.getFromStartDate() && !repaymentLoanReq.getFromStartDate().equals("")){
           // reqMap.put("fromStartDate",repaymentLoanReq.getFromStartDate());
        }
        if(null != repaymentLoanReq.getToEndDate() && !repaymentLoanReq.getToEndDate().equals("")){
           // reqMap.put("toEndDate",repaymentLoanReq.getToEndDate());
        }
        reqMap.put("kycNaturalId",repaymentLoanReq.getKycNaturalId());
        reqMap.put("pageSize",repaymentLoanReq.getPageSize());
        reqMap.put("pageNum",repaymentLoanReq.getPageNum());
        //请求贷款
        String  paramString= JSON.toJSONString(reqMap);
        String resultString = HttpUtil.post(loanConfigureInfo.getQueryLoanUrl(),paramString);
        JSONObject jSONObject = JSON.parseObject(resultString);
        log.info("待还款记录返回结果 resultString：{}",resultString);
        return ResultUtil.success(jSONObject);
    }
    /**
     * 还款操作
     * @return
     */
    @Override
    public ResponseMessage operation(RepaymentOperationReq repaymentOperationReq) {

        //查询该用户是否可以贷款
        JsLoanRiskInfo jsLoanRiskInfoQuery = new JsLoanRiskInfo();
        jsLoanRiskInfoQuery.setKycNaturalId(repaymentOperationReq.getKycNaturalId());
        jsLoanRiskInfoQuery.setDelFlag(false);
        jsLoanRiskInfoQuery = jsLoanRiskInfoMapper.selectOne(jsLoanRiskInfoQuery);
        if(null == jsLoanRiskInfoQuery){
            log.info("未查询到该用户准入信息KycNaturalId:{} " , repaymentOperationReq.getKycNaturalId());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"查询到该用户准入信息");
        }
        //查询待还款记录
        JsLoanApplyInfo selectLoanApplyInfo = new JsLoanApplyInfo();
        selectLoanApplyInfo.setKycNaturalId(repaymentOperationReq.getKycNaturalId());
        selectLoanApplyInfo.setLoanNo(repaymentOperationReq.getLoanNo());
        selectLoanApplyInfo = jsLoanApplyInfoMapper.selectOne(selectLoanApplyInfo);
        if(null == selectLoanApplyInfo){
            log.info("还款-未查询到贷款记录 ...loanNo:{}" ,repaymentOperationReq.getLoanNo());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"未查询到贷款记录，请核实");
        }
        //判断该借款是否在还款中
        if(!CommonConstant.LOAN_REPAYMENT_STATUS_INIT.equals(selectLoanApplyInfo.getRepaymentStatus())){
            log.info("该还款记录在还款中，请核实 ...loanNo:{}" ,repaymentOperationReq.getLoanNo());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"该还款记录在还款中，请核实");
        }
        //查询贷款端贷还款情况
        Map<String,Object> reqMap = new HashMap<>();
        reqMap.put("kycNaturalId",repaymentOperationReq.getKycNaturalId());
        reqMap.put("loanNo",repaymentOperationReq.getLoanNo());
        log.info("贷还款查询LoanNo:{}的还款金额",repaymentOperationReq.getLoanNo());
        String  paramString= JSON.toJSONString(reqMap);
        String resultString = HttpUtil.post(loanConfigureInfo.getQueryLoanUrl(),paramString);
        log.info("贷款还款查询响应结果resultString:{}",resultString);
        JSONObject jsonObject = JSON.parseObject(resultString);
        JSONArray loans = jsonObject.getJSONArray("loans");
        JSONObject loanParam = loans.getJSONObject(0);
        BigDecimal plannedTotal = new BigDecimal(loanParam.get("plannedTotal").toString());
        //判断还款金额是否大于应还总额
        if(repaymentOperationReq.getRepaymentAllAmt().compareTo(plannedTotal) == 1){
            log.info("还款总金额大于应还总额，请核实！loanNo:{}",repaymentOperationReq.getLoanNo());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"还款总金额大于应还总额，请核实！");
        }

        //修改还款状态
        Example example=new Example(JsLoanApplyInfo.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("kycNaturalId",repaymentOperationReq.getKycNaturalId());
        criteria.andEqualTo("loanNo",repaymentOperationReq.getLoanNo());
        JsLoanApplyInfo updateLoanApplyInfo = new JsLoanApplyInfo();
        updateLoanApplyInfo.setRepaymentStatus(CommonConstant.LOAN_REPAYMENT_STATUS_INIT);
        jsLoanApplyInfoMapper.updateByExampleSelective(updateLoanApplyInfo,example);
        //添加还款记录
        JsLoanPlanDetail jsLoanPlanDetail = new JsLoanPlanDetail();
        jsLoanPlanDetail.setId(IdUtil.simpleUUID());
        jsLoanPlanDetail.setApplyInfoId(IdUtil.simpleUUID()); //贷款申请id
        jsLoanPlanDetail.setLoanNo(repaymentOperationReq.getLoanNo());//贷款申请编号
        jsLoanPlanDetail.setKycNaturalId(repaymentOperationReq.getKycNaturalId());
        jsLoanPlanDetail.setName(jsLoanRiskInfoQuery.getBorrowerName()); //还款人名称
        jsLoanPlanDetail.setPhone(jsLoanRiskInfoQuery.getBorrowerPhone());//还款人手机号
        jsLoanPlanDetail.setUnpayPrincipal(new BigDecimal(loanParam.get("plannedCapital").toString()));// 未还本金
        jsLoanPlanDetail.setUnpayInterest(new BigDecimal(loanParam.get("plannedInterest").toString()));// 未还利息
        jsLoanPlanDetail.setUnpayFee(new BigDecimal(loanParam.get("plannedAccountAmt").toString()));// 未还服务费
        jsLoanPlanDetail.setUnpayPenalty(new BigDecimal(loanParam.get("plannedAmerce").toString()));// 未还罚息
        jsLoanPlanDetail.setUnpayPrepaymentFee(new BigDecimal(loanParam.get("plannedPreFee").toString()));// 未还罚息
        //试算
        //查询贷款端贷还款情况
        Map<String,Object> reqMap2 = new HashMap<>();
        reqMap2.put("repayTotal",repaymentOperationReq.getRepaymentAllAmt());
        reqMap2.put("loanNo",repaymentOperationReq.getLoanNo());
        log.info("贷款请求还款试算参数map:{}",reqMap2);
        String  paramString2= JSON.toJSONString(reqMap2);
        String resultString2 = HttpUtil.post(loanConfigureInfo.getLoanTrialUrl(),paramString2);
        log.info("贷款还款查询响应结果resultString:{}",resultString2);
        JSONObject jsonObject2 = JSON.parseObject(resultString2);
        JSONObject  resultObject = jsonObject2.getJSONObject("data");

        jsLoanPlanDetail.setPaidPrincipal(new BigDecimal(resultObject.get("indeedCapital").toString()));// 已还本金
        jsLoanPlanDetail.setPaidInterest(new BigDecimal(resultObject.get("indeedInterest").toString())); //已还利息
        jsLoanPlanDetail.setPaidFee(new BigDecimal(resultObject.get("indeedAccountAmt").toString())); //已还服务费
        jsLoanPlanDetail.setPaidPenalty(new BigDecimal(resultObject.get("indeedAmerce").toString())); //已还罚息
        jsLoanPlanDetail.setRepayTime(new Date());//还款时间
        jsLoanPlanDetail.setRepaymentStatus(CommonConstant.LOAN_REPAYMENT_DETAILED_STATUS_INIT);//还款状态 0初始化1还款中2成功3失败
        jsLoanPlanDetail.setUnpayTotal(new BigDecimal(loanParam.get("plannedTotal").toString()));//未还总额
        jsLoanPlanDetail.setPaidTotal(new BigDecimal(resultObject.get("indeedTotal").toString()));//已还总额
        jsLoanPlanDetailMapper.insert(jsLoanPlanDetail);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage trial(RepaymentTrialReq repaymentTrialReq) {

        //判断该试算LoanNo和金额是否正确
        //判断是否有未结束的贷款信息
        JsLoanApplyInfo selectLoanApplyInfo = new JsLoanApplyInfo();
        selectLoanApplyInfo.setKycNaturalId(repaymentTrialReq.getKycNaturalId());
        selectLoanApplyInfo.setLoanNo(repaymentTrialReq.getLoanNo());
        selectLoanApplyInfo.setIsEnd("0");//未结束
        selectLoanApplyInfo.setDelFlag(false);
        selectLoanApplyInfo = jsLoanApplyInfoMapper.selectOne(selectLoanApplyInfo);
        if(null == selectLoanApplyInfo){
            log.info("未查询到借款记录 loanNo:{}" ,repaymentTrialReq.getLoanNo());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"还款试算未查询到借款记录");
        }
        if(selectLoanApplyInfo.getRealAmt().compareTo(repaymentTrialReq.getRepayTotal()) == -1){
            log.info("试算还款的金额大于实际还款金额 loanNo:{}" ,repaymentTrialReq.getLoanNo());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"算还款的金额大于实际还款金额");
        }
        //请求贷款
        Map<String,Object> reqMap = new HashMap<>();
        reqMap.put("loanNo",repaymentTrialReq.getLoanNo());
        reqMap.put("repayTotal",repaymentTrialReq.getRepayTotal());
        log.info("试算请求参数reqMap:{}",reqMap);
        String  paramString= JSON.toJSONString(reqMap);
        String resultString = HttpUtil.post(loanConfigureInfo.getLoanTrialUrl(),paramString);
        log.info("试算返回结果paramString:{}",paramString);
        JSONObject jSONObject = JSON.parseObject(resultString);
        if(!jSONObject.get("retCode").equals(CommonConstant.LOAN_POST_SUCCESS)){
            log.info("贷款端核心试算失败 loanNo:{}" ,repaymentTrialReq.getLoanNo());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),jSONObject.get("retMsg").toString());
        }
        //返回结果
        JSONObject resultObject = jSONObject.getJSONObject("data");

        Map<String,Object> loanApplyMap = new HashMap<>();
        loanApplyMap.put("loanNo",selectLoanApplyInfo.getLoanNo());
        //请求贷款
        String  loanApplyString= JSON.toJSONString(loanApplyMap);
        String resultLoanApply = HttpUtil.post(loanConfigureInfo.getQueryLoanUrl(),loanApplyString);
        JSONObject loanApplyJSONObject = JSON.parseObject(resultLoanApply);
        log.info("接口信息查询记录返回结果 resultString：{}",resultLoanApply);
        JSONArray jSONArrays = loanApplyJSONObject.getJSONArray("loans");
        JSONObject loanApplyJSONObject2 = jSONArrays.getJSONObject(0);
        resultObject.put("startDate",loanApplyJSONObject2.get("startDate"));
        resultObject.put("endDate",loanApplyJSONObject2.get("endDate"));
        resultObject.put("loanDate",loanApplyJSONObject2.get("loanDate"));
        resultObject.put("repayWay",loanApplyJSONObject2.get("repayWay"));
        return ResultUtil.success(resultObject);
    }

    /**
     * 店铺账户查询
     * @param kycNaturalId
     * @return
     */
    @Override
    public ResponseMessage queryStoreAccount(String kycNaturalId) {
        log.info("查询可还款店铺信息 ...  keyNaturalId:{}",kycNaturalId);
        Map<String,String> params = new HashMap<>();
        params.put("kycNaturalId",kycNaturalId);
        List<Map<String,Object>> canWithdrawStoreList = jsPaySunrateBankMapper.findCanWithdrawStoreAccountList(params);
        return ResultUtil.success(canWithdrawStoreList);
    }
}
