package com.js.loan.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.js.api.jsloan.service.ApiStoreLoanService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiFileType;
import com.js.common.enums.RegisterType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.KycStoreLoanReq;
import com.js.common.model.vo.StoreLoanListVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.*;
import com.js.dal.dao.model.*;
import com.js.loan.utils.DateUtils;
import com.js.loan.utils.HttpUtil;
import com.js.loan.utils.LoanConfigureInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.*;
import java.util.HashMap;

/**
 * 店铺贷服务
 */
@Slf4j
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
public class ApiStoreLoanServiceImpl implements ApiStoreLoanService {

    @Autowired
    PlatformStatisticsByStoreMapper platformStatisticsByStoreMapper;
    @Autowired
    JsLoanRiskInfoMapper jsLoanRiskInfoMapper;
    @Autowired
    JsLoanApplyInfoMapper jsLoanApplyInfoMapper;

    @Autowired
    KycCertiMainLandPersonalMapper kycCertiMainLandPersonalMapper;
    @Autowired
    KycCertiMainLandCompanyMapper kycCertiMainLandCompanyMapper;

    @Autowired
    KycCertiHKCompanyMapper kycCertiHKCompanyMapper;

    @Autowired
    KycCertiLinkFileMapper kycCertiLinkFileMapper;

    @Autowired
    private LoanConfigureInfo loanConfigureInfo;

    @Override
    public ResponseMessage getStoreLoanList(KycStoreLoanReq kycStoreLoanReq) {
        if (ObjectUtil.isEmpty(kycStoreLoanReq.getKycNaturalId())) {
            return ResultUtil.error(ResultEnum.QUERY_ERROR);
        }

        PageHelper.startPage(kycStoreLoanReq);
        List<StoreLoanListVO> storeLoanList = platformStatisticsByStoreMapper.getStoreLoanList(kycStoreLoanReq);
        PageInfo<StoreLoanListVO> storeLoanListVOPageInfo = new PageInfo<>(storeLoanList);

        return ResultUtil.success(storeLoanListVOPageInfo, ResultEnum.QUERY_SUCCESS);
    }

    /**
     * //1.店铺授权 2.贷款申请 3.等待贷款申请审核 4.贷款申请修改 5.申请提额 6贷款提额审核  7合同签署 8.等待放款 9放款完成 10 还款
     * @param kycNatural
     * @return
     */
    @Override
    public ResponseMessage condition(String kycNatural) {

        //查询店铺情况
        Map<String, Object> calMap = calStoreStatusAndQuota(kycNatural);
        Map<String,Object> resMap = new HashMap<>();
        boolean authStatus = (boolean)calMap.get("authStatus");
        resMap.put("estimateLoanQuota",calMap.get("quota"));//预计可借款额度
        resMap.put("plannedTotal",new BigDecimal(0));//应还总金额
        resMap.put("endPlannedDate", DateUtils.getNewDate());//还款截止日期
        //店铺未授权
        if(!authStatus){
            resMap.put("reverseStatus", CommonConstant.STORE_LOAN_AUTHORIZE);
            return ResultUtil.success(resMap);
        }
        //如果店铺已经授权查询 准入信息已经存在
        JsLoanRiskInfo jsLoanRiskInfo = new JsLoanRiskInfo();
        jsLoanRiskInfo.setKycNaturalId(kycNatural);
        jsLoanRiskInfo.setDelFlag(false);
        jsLoanRiskInfo = jsLoanRiskInfoMapper.selectOne(jsLoanRiskInfo);
        if(null == jsLoanRiskInfo){
            resMap.put("reverseStatus",CommonConstant.STORE_LOAN_APPLY);//贷款申请
            return ResultUtil.success(resMap);
        }
        resMap.put("riskNo",jsLoanRiskInfo.getRiskNo());
        //判断准入信息是否已经审核通过
        if(jsLoanRiskInfo.getStatus().equals(CommonConstant.LOAN_RISK_STATUS_VERIFY)){ //审核中
            resMap.put("reverseStatus",CommonConstant.STORE_LOAN_APPLY_VERIFY_ING); //等待贷款申请审核
            return ResultUtil.success(resMap);
        }
        if(jsLoanRiskInfo.getStatus().equals(CommonConstant.LOAN_RISK_STATUS_REPULSE)){ //驳回
            resMap.put("reverseStatus",CommonConstant.STORE_LOAN_APPLY_UPDATE); //贷款申请修改
            return ResultUtil.success(resMap);
        }
        if(jsLoanRiskInfo.getStatus().equals(CommonConstant.LOAN_RISK_STATUS_REFUSE) ){ //审核失败
            resMap.put("reverseStatus",CommonConstant.STORE_LOAN_APPLY); //贷款申请
            return ResultUtil.success(resMap);
        }
        //判断是否已经申请了贷款
        JsLoanApplyInfo jsLoanApplyInfo = new JsLoanApplyInfo();
        jsLoanApplyInfo.setKycNaturalId(kycNatural);
        jsLoanApplyInfo.setIsEnd("0"); //未结束的
        jsLoanApplyInfo.setDelFlag(false);
        jsLoanApplyInfo = jsLoanApplyInfoMapper.selectOne(jsLoanApplyInfo);
        if(null == jsLoanApplyInfo){
            resMap.put("reverseStatus",CommonConstant.STORE_LOAN_APPLY_QUOTA);//申请提额
            return ResultUtil.success(resMap);
        }
        resMap.put("loanNo",jsLoanApplyInfo.getLoanNo());
        //10等待初审，11初审通过
        if(jsLoanApplyInfo.getLoanStatus().equals(CommonConstant.LOAN_APPLY_STATUS_INIT)
                 || jsLoanApplyInfo.getLoanStatus().equals(CommonConstant.LOAN_APPLY_STATUS_I_VERIFY_ADOPT)
                 ||jsLoanApplyInfo.getLoanStatus().equals(CommonConstant.LOAN_APPLY_STATUS_CONTRACT_ERROR)){
            resMap.put("reverseStatus",CommonConstant.STORE_LOAN_APPLY_QUOTA_VERIFY_ING_);//6贷款提额审核
            return ResultUtil.success(resMap);
        }
        //12初审拒绝，21复审拒绝 23电子签章审核不通过
        if(jsLoanApplyInfo.getLoanStatus().equals(CommonConstant.LOAN_APPLY_STATUS_I_VERIFY_REFUSE)
                 || jsLoanApplyInfo.getLoanStatus().equals(CommonConstant.LOAN_APPLY_STATUS_C__VERIFY_ADOPT)){
            resMap.put("reverseStatus",CommonConstant.STORE_LOAN_APPLY_QUOTA_NOT);//提额审核不通过
            return ResultUtil.success(resMap);
        }
        //20复审通过
        if(jsLoanApplyInfo.getLoanStatus().equals(CommonConstant.LOAN_APPLY_STATUS_C_VERIFY_ADOPT)){
            resMap.put("reverseStatus",CommonConstant.STORE_LOAN_APPLY_QUOTA_VERIFY_ADOPT);// 7审核通过 合同签署
            return ResultUtil.success(resMap);
        }
        //22电子签章成功 0未放款
        if(jsLoanApplyInfo.getLoanStatus().equals(CommonConstant.LOAN_APPLY_STATUS_CONTRACT_ADOPT)
                || jsLoanApplyInfo.getLoanStatus().equals(CommonConstant.LOAN_APPLY_STATUS_NOT_LOAN)){
            resMap.put("reverseStatus",CommonConstant.STORE_LOAN_APPLY_QUOTA_LOAN_ING);// 8.等待放款
            return ResultUtil.success(resMap);
        }
        //8放款中
//        if(jsLoanApplyInfo.getLoanStatus().equals(CommonConstant.LOAN_APPLY_STATUS_LOAN_ING)){
//            resMap.put("reverseStatus",CommonConstant.STORE_LOAN_APPLY_QUOTA_LOAN_SUCCESS);// 8.放款中
//            return ResultUtil.success(resMap);
//        }
        //-1合同废止  1还款中，2逾期，3案件
        resMap.put("reverseStatus",CommonConstant.STORE_LOAN_APPLY_QUOTA_REPAYMENT);// 9 还款
        //请求贷款
        Map<String,String> reqMap = new HashMap<>();
        reqMap.put("kycNaturalId",kycNatural);
        String  paramString= JSON.toJSONString(reqMap);
        String resultString = HttpUtil.post(loanConfigureInfo.getQueryLoanUrl(),paramString);
        JSONObject jsonObject = JSON.parseObject(resultString);
        resMap.put("plannedTotal",new BigDecimal(jsonObject.get("plannedTotalAll").toString()));//应还总金额
        return ResultUtil.success(resMap);
    }

    @Override
    public ResponseMessage getKeyNatural(String kycNaturalId, RegisterType registerType) {

        Map<String,Object> resMap = new HashMap<>();
        if(registerType == RegisterType.MAINLAND_PERSONAL){
            KycCertiMainLandPersonal kycCertiMainLandPersonalQuery = new KycCertiMainLandPersonal();
            kycCertiMainLandPersonalQuery.setKycNaturalId(kycNaturalId);
            kycCertiMainLandPersonalQuery = kycCertiMainLandPersonalMapper.selectOne(kycCertiMainLandPersonalQuery);
            resMap.put("borrowerName",kycCertiMainLandPersonalQuery.getCusName());
            resMap.put("borrowerIdcard",kycCertiMainLandPersonalQuery.getIdNo());
            resMap.put("effectiveStartTime",DateUtils.DateToStr(kycCertiMainLandPersonalQuery.getEffectiveStartTime()));
            resMap.put("effectiveEndTime",DateUtils.DateToStr(kycCertiMainLandPersonalQuery.getEffectiveEndTime()));
            resMap.put("address",kycCertiMainLandPersonalQuery.getLiveAddress());
            resMap.put("longFlag",kycCertiMainLandPersonalQuery.getLongFlag());
        }else if(registerType == RegisterType.MAINLAND_COMPANY){
            KycCertiMainLandCompany kycCertiMainLandCompanyQuery = new KycCertiMainLandCompany();
            kycCertiMainLandCompanyQuery.setKycNaturalId(kycNaturalId);
            kycCertiMainLandCompanyQuery = kycCertiMainLandCompanyMapper.selectOne(kycCertiMainLandCompanyQuery);
            resMap.put("borrowerName",kycCertiMainLandCompanyQuery.getLegalRepresentativeName());
            resMap.put("borrowerIdcard",kycCertiMainLandCompanyQuery.getLegalRepresentativeIdNo());
            resMap.put("effectiveStartTime",DateUtils.DateToStr(kycCertiMainLandCompanyQuery.getEffectiveStartTime()));
            resMap.put("effectiveEndTime",DateUtils.DateToStr(kycCertiMainLandCompanyQuery.getEffectiveEndTime()));
            resMap.put("longFlag",kycCertiMainLandCompanyQuery.getLongFlag());
            resMap.put("address",kycCertiMainLandCompanyQuery.getCompanyAddress());

            resMap.put("companyName",kycCertiMainLandCompanyQuery.getCompanyName());
            resMap.put("unifiedSocialCreditCode",kycCertiMainLandCompanyQuery.getUnifiedSocialCreditCode());
            resMap.put("companyAddress",kycCertiMainLandCompanyQuery.getCompanyAddress());
        }else if(registerType == RegisterType.HK_COMPANY){
            KycCertiHKCompany kycCertiHKCompanyQuery = new KycCertiHKCompany();
            kycCertiHKCompanyQuery.setKycNaturalId(kycNaturalId);
            kycCertiHKCompanyQuery = kycCertiHKCompanyMapper.selectOne(kycCertiHKCompanyQuery);
            resMap.put("borrowerName",kycCertiHKCompanyQuery.getDirectorName());
            resMap.put("borrowerIdcard",kycCertiHKCompanyQuery.getDirectorIdNo());
            resMap.put("effectiveStartTime",DateUtils.DateToStr(kycCertiHKCompanyQuery.getEffectiveStartTime()));
            resMap.put("effectiveEndTime",DateUtils.DateToStr(kycCertiHKCompanyQuery.getEffectiveEndTime()));
            resMap.put("longFlag",kycCertiHKCompanyQuery.getLongFlag());
            resMap.put("address",kycCertiHKCompanyQuery.getDirectorAddress());
        }
        //查询身份证图片
        KycCertiLinkFile kycCertiLinkFile = new KycCertiLinkFile();
        kycCertiLinkFile.setKycNaturalId(kycNaturalId);
        List<KycCertiLinkFile> kycCertiLinkFiles = kycCertiLinkFileMapper.select(kycCertiLinkFile);
        for(KycCertiLinkFile entity : kycCertiLinkFiles){
            if(StringUtils.isEmpty(entity.getContactsId())){
                if(entity.getFileType().equals(CertiFileType.CARD_FRONT_IMAGE)){
                    resMap.put("borrowerIdCardFront",entity.getFileSavePath());
                }else if(entity.getFileType().equals(CertiFileType.CARD_BACK_IMAGE)){
                    resMap.put("borrowerIdCardBack",entity.getFileSavePath());
                }else if(entity.getFileType().equals(CertiFileType.CARD_HANDID_IMAGE)){
                    resMap.put("borrowerIdCardHold",entity.getFileSavePath());
                }else if(entity.getFileType().equals(CertiFileType.BUSINESS_LICENSE_IMAGE)){
                    resMap.put("mainlandCompanyImg",entity.getFileSavePath());
                }
            }
        }
        resMap.put("registerTypeCode",registerType.getEnumCode());
        resMap.put("registerTypeName",registerType.getEnumName());
        resMap.put("kycNaturalId",kycNaturalId);
        return ResultUtil.success(resMap);
    }

    /**
     * 计算目前客户下的铺店授权状态与预估计额度
     *
     * 计算规则如下：
     * 用户如果存在一个店铺为授权状态则认为该店铺已经授权。
     * 预计额度计算方式：
     * 该用户所有店铺的笔均入账加和 * 0.7
     */
    private Map<String, Object> calStoreStatusAndQuota(String kycNaturalId) {
        KycStoreLoanReq kycStoreLoanReq = new KycStoreLoanReq();
        kycStoreLoanReq.setKycNaturalId(kycNaturalId);
        kycStoreLoanReq.setAuthStatus(CollUtil.newArrayList(2, 3));
        List<StoreLoanListVO> storeLoanList = platformStatisticsByStoreMapper.getStoreLoanList(kycStoreLoanReq);
        Map<String, Object> result = new HashMap<>();
        if (storeLoanList.size() <= 0) {
            result.put("authStatus", false);
            result.put("quota", new BigDecimal(0));
        } else {
            result.put("authStatus", true);
            BigDecimal quota = storeLoanList.stream()
                    .filter(e -> e.getAverageIncome() != null)
                    .map(StoreLoanListVO::getAverageIncome)
                    .reduce(new BigDecimal(0), BigDecimal::add)
                    .multiply(new BigDecimal("0.7"));
            result.put("quota", quota);
        }
        return result;
    }
}
