package com.js.loan.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jsloan.service.ApiJsLoanRepaymentService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.enums.SiteEnum;
import com.js.common.model.req.RepaymentLoanReq;
import com.js.common.model.req.RepaymentOperationReq;
import com.js.common.model.req.RepaymentTrialReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsLoanApplyInfoMapper;
import com.js.dal.dao.mapper.JsPaySunrateBankMapper;
import com.js.dal.dao.model.JsLoanApplyInfo;
import com.js.loan.utils.DateUtils;
import com.js.loan.utils.HttpUtil;
import com.js.loan.utils.LoanConfigureInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.*;

@Slf4j
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
public class ApiJsLoanRepaymentServiceImpl implements ApiJsLoanRepaymentService {

    @Autowired
    JsPaySunrateBankMapper jsPaySunrateBankMapper;

    @Autowired
    JsLoanApplyInfoMapper jsLoanApplyInfoMapper;

    @Autowired
    private LoanConfigureInfo loanConfigureInfo;

    /**
     * 还款明细查询
     * @return
     */
    @Override
    public ResponseMessage detailed(String loanNo) {
        //判断贷款编号
        if(StringUtils.isEmpty(loanNo)){
             log.info(" 还款明细查询请求贷款编号未空");
            return ResultUtil.error(ResultEnum.ERROR.getCode()," 还款明细查询请求贷款编号未空");
        }

        //请求贷款
        Map<String,String> reqMap = new HashMap<>();
        reqMap.put("loanNo",loanNo);
        String  paramString= JSON.toJSONString(reqMap);
        String resultString = HttpUtil.post(loanConfigureInfo.getDetailLoanUrl(),paramString);
        JSONObject jSONObject = JSON.parseObject(resultString);
        log.info("还款明细返回结果resultString:{}",resultString);
        return ResultUtil.success(jSONObject);
    }
    /**
     * 待还款记录查询
     * @return
     */
    @Override
    public ResponseMessage loanSituation(RepaymentLoanReq repaymentLoanReq) {
        Map<String,Object> reqMap = new HashMap<>();
        if(null != repaymentLoanReq.getFromStartDate() && !repaymentLoanReq.getFromStartDate().equals("")){
            reqMap.put("fromStartDate",repaymentLoanReq.getFromStartDate());
        }
        if(null != repaymentLoanReq.getToEndDate() && !repaymentLoanReq.getToEndDate().equals("")){
            reqMap.put("toEndDate",repaymentLoanReq.getToEndDate());
        }
        reqMap.put("kycNaturalId",repaymentLoanReq.getKycNaturalId());
        reqMap.put("pageSize",repaymentLoanReq.getPageSize());
        reqMap.put("pageNum",repaymentLoanReq.getPageNum());
        //请求贷款
        String  paramString= JSON.toJSONString(reqMap);
        String resultString = HttpUtil.post(loanConfigureInfo.getQueryLoanUrl(),paramString);
        JSONObject jSONObject = JSON.parseObject(resultString);
        log.info("待还款记录返回结果 resultString：{}",resultString);
        return ResultUtil.success(jSONObject);
    }
    /**
     * 还款操作
     * @return
     */
    @Override
    public ResponseMessage operation(RepaymentOperationReq repaymentOperationReq) {
        //Map<String,String> resMap = new HashMap<>();
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage trial(RepaymentTrialReq repaymentTrialReq) {

        //判断该试算LoanNo和金额是否正确
        //判断是否有未结束的贷款信息
        JsLoanApplyInfo selectLoanApplyInfo = new JsLoanApplyInfo();
        selectLoanApplyInfo.setKycNaturalId(repaymentTrialReq.getKycNaturalId());
        selectLoanApplyInfo.setLoanNo(repaymentTrialReq.getLoanNo());
        selectLoanApplyInfo.setIsEnd("0");//未结束
        selectLoanApplyInfo.setDelFlag(false);
        selectLoanApplyInfo = jsLoanApplyInfoMapper.selectOne(selectLoanApplyInfo);
        if(null == selectLoanApplyInfo){
            log.info("未查询到借款记录 loanNo:{}" ,repaymentTrialReq.getLoanNo());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"还款试算未查询到借款记录");
        }
        if(selectLoanApplyInfo.getRealAmt().compareTo(repaymentTrialReq.getRepaymentAllAmt()) == -1){
            log.info("试算还款的金额大于实际还款金额 loanNo:{}" ,repaymentTrialReq.getLoanNo());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"算还款的金额大于实际还款金额");
        }
        //请求贷款
        String  paramString= JSON.toJSONString(repaymentTrialReq);
        String resultString = HttpUtil.post(loanConfigureInfo.getLoanTrialUrl(),paramString);

        JSONObject jSONObject = JSON.parseObject(resultString);
        if(!jSONObject.get("retCode").equals(CommonConstant.LOAN_POST_SUCCESS)){
            log.info("贷款端核心试算失败 loanNo:{}" ,repaymentTrialReq.getLoanNo());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),jSONObject.get("retMsg").toString());
        }
        JSONObject resultObject = jSONObject.getJSONObject("data");
        return ResultUtil.success(resultObject);
    }

    /**
     * 店铺账户查询
     * @param kycNaturalId
     * @return
     */
    @Override
    public ResponseMessage queryStoreAccount(String kycNaturalId) {
        log.info("查询可还款店铺信息 ...  keyNaturalId:{}",kycNaturalId);
        Map<String,String> params = new HashMap<>();
        params.put("kycNaturalId",kycNaturalId);
        List<Map<String,Object>> canWithdrawStoreList = jsPaySunrateBankMapper.findCanWithdrawStoreAccountList(params);
        return ResultUtil.success(canWithdrawStoreList);
    }
}
