package com.js.loan.service.impl;

import com.js.api.jsloan.service.ApiJsLoanRepaymentService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.enums.SiteEnum;
import com.js.common.model.req.RepaymentLoanReq;
import com.js.common.model.req.RepaymentOperationReq;
import com.js.common.model.req.RepaymentTrialReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsPaySunrateBankMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.*;

@Slf4j
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
public class ApiJsLoanRepaymentServiceImpl implements ApiJsLoanRepaymentService {

    @Autowired
    JsPaySunrateBankMapper jsPaySunrateBankMapper;

    /**
     * 还款明细查询
     * @return
     */
    @Override
    public ResponseMessage detailed(String loanNo) {

        Map<String,Object> resMap = new HashMap<>();
        //贷款编号
        resMap.put("loanNo","12345678900");
        //应还金额
        resMap.put("plannedTotal","100000.00");
        //还款日期
        resMap.put("repayDate","2019-07-17");
        //借款总额
        resMap.put("loanTotal","1000000.00");
        //放款时间
        resMap.put("LoanDate","2019-07-17");

        //放款机构
        resMap.put("loanOrg","小贷");
        //收款账号
        resMap.put("repayNumber","243343434334");
        //还款方式
        resMap.put("repayWay","01");
        //日利费率
        resMap.put("interestRate","10");
        //最早还款日期
        resMap.put("startDate","2019-07-17");
        //最晚还款日期
        resMap.put("endDate","2019-07-17");
        //最早还款日应还本息费
        resMap.put("beginPlannedTotal","12");
        // 最晚还款日应还本息费
        resMap.put("endPlannedTotal","12");

        Map<String,Object> resMap2 = new HashMap<>();
        //借款总额
        resMap2.put("loanTotall","1000000.00");
        //还款时间
        resMap2.put("repayDate","2019-07-17");
        //第几次还款
        resMap2.put("severalNuml","1");
        //应还总额
        resMap2.put("plannedTotal","100000");
        //应还本金
        resMap2.put("plannedCapital","50000");
        //实还总额
        resMap2.put("indeedTotal","120000");
        //实还本金
        resMap2.put("indeedCapital","191919");
        //应还利息及费用
        resMap2.put("plannedInterest","100");
        resMap2.put("plannedInstFee","100");
        //实还利息及费用
        resMap2.put("indeedInterest","100");
        resMap2.put("indeedInstFee","100");
        //还款账号
        resMap2.put("repayAccount","32434343433");
        //还款方式
        resMap2.put("repayWay","01");

        Map<String,Object> resMap3 = new HashMap<>();
        //借款总额
        resMap3.put("loanTotall","1000000.00");
        //还款时间
        resMap3.put("repayDate","2019-07-17");
        //第几次还款
        resMap3.put("severalNuml","2");
        //应还总额
        resMap3.put("plannedTotal","100000");
        //应还本金
        resMap3.put("plannedCapital","50000");
        //实还总额
        resMap3.put("indeedTotal","120000");
        //实还本金
        resMap3.put("indeedCapital","30000");
        //应还利息及费用
        resMap3.put("plannedInterest","100");
        resMap3.put("plannedInstFee","100");
        //实还利息及费用
        resMap3.put("indeedInterest","100");
        resMap3.put("indeedInstFee","200");
        //还款账号
        resMap3.put("repayAccount","32434343433");
        //还款方式
        resMap3.put("repayWay","01");

        List<Map<String,Object>> resList = new ArrayList<>();
        resList.add(resMap2);
        resList.add(resMap3);
        resMap.put("resList",resList);

        return ResultUtil.success(resMap);
    }
    /**
     * 需还款记录查询
     * @return
     */
    @Override
    public ResponseMessage loanSituation(RepaymentLoanReq repaymentLoanReq) {
        Map<String,String> resMap = new HashMap<>();
        //贷款编号
        resMap.put("loanNo","12345678900");
        //最早还款日
        resMap.put("startDate","2019-07-17");
        //最晚还款日
        resMap.put("endDate","2019-07-17");
        //应还总额
        resMap.put("plannedTotal","10000.00");
        //本金
        resMap.put("plannedCapital","5000.00");
        //利息及费用
        resMap.put("plannedInterest","20.00");
        resMap.put("plannedInstFee","20.00");
        //借款时间
        resMap.put("loanDate","2019-07-17");
        //最长使用期限（天）
        resMap.put("maxTerm","90");
        //还款方式
        resMap.put("repayWay","01");
        //手续费
        resMap.put("plannedPreFee","");
        List<Map<String,String>> list = new ArrayList();

        list.add(resMap);

        Map<String,Object> resMap2 = new HashMap<>();
        resMap2.put("loanSituationList",list);
        resMap2.put("pageNum",1);
        resMap2.put("pageSize",10);
        resMap2.put("total",1);
        resMap2.put("plannedTotalAll",new BigDecimal(10000.00));
        resMap2.put("plannedCapitalAll",new BigDecimal(10000.00));
        return ResultUtil.success(resMap2);
    }
    /**
     * 还款操作
     * @return
     */
    @Override
    public ResponseMessage operation(RepaymentOperationReq repaymentOperationReq) {
        //Map<String,String> resMap = new HashMap<>();
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage trial(RepaymentTrialReq repaymentTrialReq) {

        Map<String,String> resMap = new HashMap<>();
        //贷款编号
        resMap.put("loanNo","12345678900");
        //还款总金额
        resMap.put("repaymentAllAmt","10000.00");
        //还款本金
        resMap.put("principalAmt","99000.00");
        //手续费
        resMap.put("proceduresAmt","44.00");
        //利息
        resMap.put("plannedInterest","44.00");
        //费用
        resMap.put("plannedInstFee","44.00");

        //最早还款日期
        resMap.put("startDate","2020-09-09");
        //最晚还款日期
        resMap.put("endDate","2030-09-09");
        //还款方式
        resMap.put("repayWay","01");
        //借款时间
        resMap.put("loanDate","2019-08-09");

        return ResultUtil.success(resMap);
    }

    /**
     * 店铺账户查询
     * @param kycNaturalId
     * @return
     */
    @Override
    public ResponseMessage queryStoreAccount(String kycNaturalId) {
        log.info("查询可还款店铺信息 ...  keyNaturalId:{}",kycNaturalId);
        Map<String,String> params = new HashMap<>();
        params.put("kycNaturalId",kycNaturalId);
        List<Map<String,Object>> canWithdrawStoreList = jsPaySunrateBankMapper.findCanWithdrawStoreAccountList(params);
        return ResultUtil.success(canWithdrawStoreList);
    }
}
