//package com.js.service.qichacha;
//
//import cn.hutool.core.util.IdUtil;
//import cn.hutool.core.util.ObjectUtil;
//import cn.hutool.crypto.SecureUtil;
//import cn.hutool.http.HttpRequest;
//import cn.hutool.http.HttpResponse;
//import cn.hutool.json.JSONArray;
//import cn.hutool.json.JSONObject;
//import cn.hutool.json.JSONUtil;
//import com.js.common.model.req.QiChaChaEnterpriseInfoReq;
//import com.js.dal.dao.mapper.QiChaChaEnterpriseInfoMapper;
//import com.js.dal.dao.model.QiChaChaEnterpriseInfo;
//import com.js.loan.JsLoanServiceAppliaction;
//import lombok.extern.slf4j.Slf4j;
//import org.junit.Test;
//import org.junit.runner.RunWith;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.beans.factory.annotation.Value;
//import org.springframework.boot.test.context.SpringBootTest;
//import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
//import tk.mybatis.mapper.entity.Example;
//
//import java.math.BigDecimal;
//import java.time.Instant;
//import java.time.LocalDateTime;
//import java.time.ZoneOffset;
//import java.util.Date;
//import java.util.HashMap;
//import java.util.List;
//import java.util.Map;
//
//@Slf4j
//@RunWith(SpringJUnit4ClassRunner.class)
//@SpringBootTest(classes= JsLoanServiceAppliaction.class)
//public class QiChaChaEnterpriseInfoServiceTest {
//
//    @Value("${qichacha.appKey}")
//    private String appKey;
//
//    @Value("${qichacha.secretKey}")
//    private String secretKey;
//
//    private final String url = "http://api.qichacha.com/ECIV4/GetFullDetailsByName";
//
//    @Autowired
//    QiChaChaEnterpriseInfoMapper qiChaChaEnterpriseInfoMapper;
//
//    @Test
//    public void run () {
//        QiChaChaEnterpriseInfoReq qiChaChaEnterpriseInfoReq = new QiChaChaEnterpriseInfoReq();
////        qiChaChaEnterpriseInfoReq.setKeyWord("91440300312081655t");
//        qiChaChaEnterpriseInfoReq.setKeyWord("北京源奉济生网络科技有限公司");
//        getFullDetailsByName(qiChaChaEnterpriseInfoReq);
//    }
//
//    public void getFullDetailsByName(QiChaChaEnterpriseInfoReq qiChaChaEnterpriseInfoReq) {
//        if (ObjectUtil.isEmpty(qiChaChaEnterpriseInfoReq.getKeyWord())) {
//            return;
//        }
//        QiChaChaEnterpriseInfo oldEnterpriseInfo = getOldEnterpriseInfo(qiChaChaEnterpriseInfoReq);
//        if (!qiChaChaEnterpriseInfoReq.getForce() && ObjectUtil.isNotEmpty(oldEnterpriseInfo)) {
//            return;
//        }
//
//        // 库中没有符合条件数据，向三方接口查询
//        Date requestDate = Date.from(Instant.now());
//        long timespan = requestDate.toInstant().getEpochSecond();
//        String token = calToken(timespan);
//
//        Map<String, Object> parameter = new HashMap<>();
//        parameter.put("key", appKey);
//        parameter.put("keyWord", qiChaChaEnterpriseInfoReq.getKeyWord());
//
//        HttpResponse response = HttpRequest.get(url)
//                .header("Token", token)
//                .header("Timespan", new Long(timespan).toString())
//                .form(parameter)
//                .execute();
//        log.info("result: {}", response.body());
//        if (response.getStatus() == 200) {
//            QiChaChaEnterpriseInfo qiChaChaEnterpriseInfo = new QiChaChaEnterpriseInfo();
//            qiChaChaEnterpriseInfo.setReqestTime(requestDate);
//            qiChaChaEnterpriseInfo.setId(IdUtil.simpleUUID());
//            qiChaChaEnterpriseInfo.setCreateId("sys");
//            qiChaChaEnterpriseInfo.setCreateName("sys");
//            qiChaChaEnterpriseInfo.setCreateDts(new Date());
//            qiChaChaEnterpriseInfo.setResponseBodyData(response.body());
//            analysisData(qiChaChaEnterpriseInfo);
//            if (ObjectUtil.isNotEmpty(oldEnterpriseInfo)) {
//                qiChaChaEnterpriseInfo.setId(oldEnterpriseInfo.getId());
//                qiChaChaEnterpriseInfoMapper.updateByPrimaryKey(qiChaChaEnterpriseInfo);
//            } else {
//                qiChaChaEnterpriseInfoMapper.insertSelective(qiChaChaEnterpriseInfo);
//            }
//        }
//    }
//
//    private QiChaChaEnterpriseInfo getOldEnterpriseInfo(QiChaChaEnterpriseInfoReq qiChaChaEnterpriseInfoReq) {
//        // 非强制查询，优先上数据库中查找
//        Example example = new Example(QiChaChaEnterpriseInfo.class);
//        example.setOrderByClause("create_dts desc");
//        Example.Criteria criteria = example.createCriteria();
//        criteria.orEqualTo("keyNo", qiChaChaEnterpriseInfoReq.getKeyWord());
//        criteria.orEqualTo("name", qiChaChaEnterpriseInfoReq.getKeyWord());
//        criteria.orEqualTo("no", qiChaChaEnterpriseInfoReq.getKeyWord());
//        criteria.orEqualTo("creditCode", qiChaChaEnterpriseInfoReq.getKeyWord());
//        List<QiChaChaEnterpriseInfo> qiChaChaEnterpriseInfos = qiChaChaEnterpriseInfoMapper.selectByExample(example);
//        if (qiChaChaEnterpriseInfos.size() == 0) {
//            return qiChaChaEnterpriseInfos.get(0);
//        } else if (qiChaChaEnterpriseInfos.size() > 1) {
//            log.error("企业工商旧数据条目异常,目前只取第一条");
//            return qiChaChaEnterpriseInfos.get(0);
//        }
//        return null;
//    }
//
//    /**
//     * 解析 json 中关键数据
//     *
//     * 如果查询失败，则放弃解析
//     * @param qiChaChaEnterpriseInfo
//     */
//    private void analysisData(QiChaChaEnterpriseInfo qiChaChaEnterpriseInfo) {
//        String responseBodyData = qiChaChaEnterpriseInfo.getResponseBodyData();
//        JSONObject jsonObject = JSONUtil.parseObj(responseBodyData);
//        String status = jsonObject.getStr("Status");
//        String message = jsonObject.getStr("Message");
//        if ("200".equals(status)) {
//            log.info("企查查工商数据查询成功 code: {}, message: {}", status, message);
//            // 查询成功则断续解析
//            JSONObject result = jsonObject.getJSONObject("Result");
//            String keyNo = result.getStr("KeyNo");
//            String name = result.getStr("Name");
//            String operName = result.getStr("OperName");
//            String no = result.getStr("No");
//            String creditCode = result.getStr("CreditCode");
//            Date startDate = result.getDate("StartDate");
//            JSONArray partners = result.getJSONArray("Partners");
//            JSONObject area = result.getJSONObject("Area");
//            // 变更项
//            JSONArray changeRecords = result.getJSONArray("ChangeRecords");
//            // 法院执行
//            JSONArray zhiXingItems = result.getJSONArray("ZhiXingItems");
//            // 行政处罚
//            JSONArray penalty = result.getJSONArray("Penalty");
//            // 经营异常
//            JSONArray exceptions = result.getJSONArray("Exceptions");
//
//            String province = area.getStr("Provice");
//            String city = area.getStr("City");
//            String partner50 = calPartner50(partners);
//            Boolean operIsPartner = calOperIsPartner(operName, partners);
//            Boolean operChange = calOperChange(changeRecords);
//            Boolean partnerChange = calPartnerChange(changeRecords);
//            Boolean hasExecution = calHasItemNearlyYear(zhiXingItems, "Updatedate");
//            Boolean hasPenalty = calHasItemNearlyYear(penalty, "PenaltyDate");
//            Boolean hasException = calHasItemNearlyYear(exceptions, "AddDate");
//            qiChaChaEnterpriseInfo.setKeyNo(keyNo);
//            qiChaChaEnterpriseInfo.setName(name);
//            qiChaChaEnterpriseInfo.setNo(no);
//            qiChaChaEnterpriseInfo.setStartDate(startDate);
//            qiChaChaEnterpriseInfo.setCreditCode(creditCode);
//            qiChaChaEnterpriseInfo.setProvince(province);
//            qiChaChaEnterpriseInfo.setCity(city);
//            qiChaChaEnterpriseInfo.setPartner50(partner50);
//            qiChaChaEnterpriseInfo.setOperIsPartner(operIsPartner);
//            qiChaChaEnterpriseInfo.setOperChange(operChange);
//            qiChaChaEnterpriseInfo.setPartnerChange(partnerChange);
//            qiChaChaEnterpriseInfo.setHasExecution(hasExecution);
//            qiChaChaEnterpriseInfo.setHasPenalty(hasPenalty);
//            qiChaChaEnterpriseInfo.setHasException(hasException);
//        } else {
//            log.error("企查查工商数据查询失败 code: {}, message: {}", status, message);
//        }
//    }
//
//    /**
//     * 检查近期有无相关记录
//     *
//     * @param items 检查项目
//     * @param key 使用的检查项
//     * @return
//     */
//    private Boolean calHasItemNearlyYear(JSONArray items, String key) {
//        if (ObjectUtil.isEmpty(items)) {
//            return false;
//        } else {
//            LocalDateTime localDateTime = LocalDateTime.now().minusYears(1);
//            for (int i = 0; i < items.size(); i++) {
//                JSONObject item = items.getJSONObject(i);
//                Date addDate = item.getDate(key);
//                // 只取近一年的。
//                if (addDate.getTime() > localDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli()) {
//                    return true;
//                }
//            }
//            return false;
//        }
//    }
//
//    // TODO 需要资询一下可能的项，再做计算
//    private Boolean calOperChange(JSONArray changeRecords) {
//        return false;
//    }
//
//    private Boolean calPartnerChange(JSONArray changeRecords) {
//        return false;
//    }
//
//    private Boolean calOperIsPartner(String operName, JSONArray partners) {
//        if (ObjectUtil.isEmpty(partners) || ObjectUtil.isEmpty(operName)) {
//            log.error("公司认证数据不正确，法人或股东为空");
//            return false;
//        } else {
//            for (int i = 0; i < partners.size(); i++) {
//                JSONObject partner = partners.getJSONObject(i);
//                String stockName = partner.getStr("StockName");
//                if (operName.equals(stockName)) {
//                    return true;
//                }
//            }
//            return false;
//        }
//    }
//
//    private String calPartner50(JSONArray partners) {
//        if (ObjectUtil.isEmpty(partners)) {
//            return "";
//        } else {
//            for (int i = 0; i < partners.size(); i++) {
//                JSONObject partner = partners.getJSONObject(i);
//                String stockPercent = partner.getStr("StockPercent").replace("%", "");
//                if (new BigDecimal(stockPercent).compareTo(new BigDecimal(50)) > 0) {
//                    return partner.getStr("StockName");
//                }
//            }
//            return "";
//        }
//    }
//
//    /**
//     * 计算规则：
//     * 验证加密值（key+Timespan+SecretKey组成的32位md5加密的大写字符串）
//     *
//     * @param timespan 精确到秒的Unix时间戳
//     * @return
//     */
//    private String calToken (long timespan) {
//        return SecureUtil.md5(appKey + timespan + secretKey).toUpperCase();
//    }
//
//}
