package com.js.loan.utils;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 加载汇付配置信息
 */
@Component
@ConfigurationProperties(prefix = "loan")
@Data
public class LoanConfigureInfo {

    private String productNo;
    private String productName;
    private String interestRate;
    private String yearRate;
    /**
     * 北京源奉济生网络科技有限公司-支付商户号
     */
    private String channelChinapnrId;
    private String channelChinapnrName;
    /**
     * 鹰潭市信江广达小额贷款股份有限公司-支付商户号
     */
    private String channelSmallLoanId;
    private String channelSmallLoanName;
    /**
     * 合同生成地址
     */
    private String contractUrl;
    /**
     * 借款协议含担保条款_大陆
     */
    private String contractNameHolder;
    /**
     * 借款协议含担保条款_香港企业
     */
    private String contractNameHk;
    /**
     * 服务合同含担保条款_大陆
     */
    private String contractName2Holder;
    /**
     * 服务合同含担保条款_香港企业
     */
    private String contractName2Hk;
    /**
     * 委托扣款授权书含划扣顺序
     */
    private String contractName3;
}
