package com.js.loan.service.impl;

import cn.hutool.core.util.IdUtil;
import com.js.api.jsloan.service.ApiKycLoanBankService;
import com.js.common.constant.Constant;
import com.js.common.enums.*;
import com.js.common.model.req.KycLoanBankReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.ChinaPNROpenAccountMapper;
import com.js.dal.dao.mapper.KycBankMapper;
import com.js.dal.dao.model.ChinaPNROpenAccount;
import com.js.dal.dao.model.KycBank;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;

@Slf4j
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
public class ApiKycLoanBankServiceImpl implements ApiKycLoanBankService {


    @Autowired
    KycBankMapper kycBankMapper;

    @Autowired
    ChinaPNROpenAccountMapper chinaPNROpenAccountMapper;

    @Override
    public ResponseMessage addBank(KycLoanBankReq kycLoanBankReq) {
        //添加
        log.info("添加到数据库银行信息执行 key:{}" ,kycLoanBankReq);
        KycBank addBank = new KycBank();
        BeanUtils.copyProperties(kycLoanBankReq,addBank);
        addBank.setId(IdUtil.simpleUUID());
        addBank.setBindingType(BindingBankCardType.BINDING_LOANS);
        addBank.setEffectiveFlag(true);
        addBank.setCompanyAcctType(BankAcctTypeEnum.COMPANY_SELF);
        addBank.setCreateDts(new Date());
        addBank.setUpdateDts(new Date());
        addBank.setRouteType(SysPlateformType.HFGJ);
        addBank.setStateOrRegion(BankAreaType.MAIN_LAND);
        addBank.setCurrencyCode("CNY");
        int count = kycBankMapper.insertSelective(addBank);

        if(count < 1){
            log.info("该添加到数据库银行信息执行失败 count < 1 key:{}" ,kycLoanBankReq);
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"该银行卡已经绑卡，请重新绑定");
        }
        log.info("该添加到数据库银行信息执行成功  key:{}" ,kycLoanBankReq);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage queryBankList(String kycNaturalId) {
        KycBank bank = new KycBank();
        bank.setKycNaturalId(kycNaturalId);
        bank.setBindingType(BindingBankCardType.BINDING_LOANS);
        bank.setEffectiveFlag(true);
        List<KycBank> bankList = kycBankMapper.select(bank);
        return ResultUtil.success(bankList,ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage queryBankFlag(KycLoanBankReq kycLoanBankReq) {
        //查询该用户的卡是否已经绑卡
        KycBank bank = new KycBank();
        bank.setKycNaturalId(kycLoanBankReq.getKycNaturalId());
        bank.setAccountNo(kycLoanBankReq.getAccountNo());
        bank.setBindingType(BindingBankCardType.BINDING_LOANS);
        KycBank banks = kycBankMapper.selectOne(bank);
        if(null != banks){
            log.info("该银行卡已经绑卡，请重新绑定 key:{}" ,kycLoanBankReq);
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"该银行卡已经绑卡，请重新绑定");
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage accountFalg(String kycNaturalId) {

        ChinaPNROpenAccount chinaPNROpenAccount = new ChinaPNROpenAccount();
        chinaPNROpenAccount.setKycNaturalId(kycNaturalId);
        chinaPNROpenAccount.setAcctType("2");
        ChinaPNROpenAccount chinaPNROpenAccounts  = chinaPNROpenAccountMapper.selectOne(chinaPNROpenAccount);
        if(null != chinaPNROpenAccounts){
            log.info("该用户已经在汇付申请了开户信息 kycNaturalId:{}" ,kycNaturalId);
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"该用户已经在汇付申请了开户信息");
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }
}
