package com.js.loan.service.impl;

import cn.hutool.core.util.IdUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.js.api.jsloan.service.ApiJsLoanBillFileService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsLoanBillFilePageReq;
import com.js.common.model.req.JsLoanBillFileReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsLoanApplyInfoMapper;
import com.js.dal.dao.mapper.JsLoanBillFileMapper;
import com.js.dal.dao.model.JsLoanApplyInfo;
import com.js.dal.dao.model.JsLoanBillFile;
import com.js.loan.utils.DateUtils;
import com.js.loan.utils.ExcelUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import tk.mybatis.mapper.entity.Example;
import java.util.Date;
import java.util.List;

@Slf4j
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
public class ApiJsLoanBillFileServiceImpl implements ApiJsLoanBillFileService {

    @Autowired
    private JsLoanBillFileMapper jsLoanBillFileMapper;

    @Autowired
    private JsLoanApplyInfoMapper jsLoanApplyInfoMapper;

    /**
     * 对账申请查询
     * @param jsLoanBillFilePageReq
     * @return
     */
    @Override
    public ResponseMessage applyQuery(JsLoanBillFilePageReq jsLoanBillFilePageReq) {
        log.info("对账申请查询 kyc:{}",jsLoanBillFilePageReq.getKycNaturalId());
        Example example=new Example(JsLoanBillFile.class);
        example.setOrderByClause("apply_date DESC");
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("kycNaturalId",jsLoanBillFilePageReq.getKycNaturalId());
        PageHelper.startPage(jsLoanBillFilePageReq);
        List<JsLoanBillFile> jsLoanBillFileList = jsLoanBillFileMapper.selectByExample(example);
        PageInfo<JsLoanBillFile> jsLoanBillFileVo = new PageInfo<>(jsLoanBillFileList);
        return ResultUtil.success(jsLoanBillFileVo);
    }

    /**
     * 对账申请
     * @param jsLoanBillFileReq
     * @return
     */
    @Override
    public ResponseMessage applyOperation(JsLoanBillFileReq jsLoanBillFileReq) {

        log.info("申请对账文件开始 req:{}",jsLoanBillFileReq);
        JsLoanBillFile jsLoanBillFileSel = new JsLoanBillFile();
        jsLoanBillFileSel.setKycNaturalId(jsLoanBillFileReq.getKycNaturalId());
        jsLoanBillFileSel.setBillStartDate(DateUtils.StrToDate(jsLoanBillFileReq.getBillStartDate()));
        jsLoanBillFileSel.setBillEndDate(DateUtils.StrToDate(jsLoanBillFileReq.getBillEndDate()));
        List<JsLoanBillFile> jsLoanBillFileList  = jsLoanBillFileMapper.select(jsLoanBillFileSel);
        if(jsLoanBillFileList.size() > 0){
            log.info("已经申请下载过相同时间段的账单，请至【可下载账单】查看下载 kyc:{}",jsLoanBillFileReq.getKycNaturalId());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"已经申请下载过相同时间段的账单，请至【可下载账单】查看下载");
        }
        JsLoanBillFile jsLoanBillFileIns = new JsLoanBillFile();
        jsLoanBillFileIns.setKycNaturalId(jsLoanBillFileReq.getKycNaturalId());
        jsLoanBillFileIns.setApplyDate(new Date());
        jsLoanBillFileIns.setBillStartDate(DateUtils.StrToDate(jsLoanBillFileReq.getBillStartDate()));
        jsLoanBillFileIns.setBillEndDate(DateUtils.StrToDate(jsLoanBillFileReq.getBillEndDate()));
        jsLoanBillFileIns.setApplyStatus(CommonConstant.LOAN_BILL_FILE_APPLY_STATUS_INIT);//初始化
        jsLoanBillFileIns.setBillType("010");//账单类型 010贷款账单
        jsLoanBillFileIns.setLoanBillNo(IdUtil.simpleUUID());
        jsLoanBillFileIns.setId(IdUtil.simpleUUID());
        int count = jsLoanBillFileMapper.insertSelective(jsLoanBillFileIns);
        if(count < 1){
            log.info("贷款申请插入数据库失败 kyc:{}",jsLoanBillFileReq.getKycNaturalId());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"贷款申请失败");
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    /**
     * 对账下载
     * @param loanBillNo
     * @return
     */
    @Override
    public ResponseMessage download(String kycNaturalId,String loanBillNo) {

        log.info("查询导出数据 ...kyc:{},loanBillNo:{}",kycNaturalId,loanBillNo);
        //查询申请记录
        JsLoanBillFile jsLoanBillFile = new JsLoanBillFile();
        jsLoanBillFile.setKycNaturalId(kycNaturalId);
        jsLoanBillFile.setLoanBillNo(loanBillNo);
        jsLoanBillFile = jsLoanBillFileMapper.selectOne(jsLoanBillFile);
        if(null == jsLoanBillFile){
             log.info("查询导出数据失败未查询到申请记录");
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"查询导出数据失败未查询到申请记录");
        }
        //查询贷款记录
        Example example=new Example(JsLoanApplyInfo.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("kycNaturalId",kycNaturalId);
        criteria.andBetween("applyDate",jsLoanBillFile.getBillStartDate(),jsLoanBillFile.getBillEndDate());
        List<JsLoanApplyInfo> jsLoanApplyInfoList = jsLoanApplyInfoMapper.selectByExample(example);

        //excel标题
        String[] title = {"贷款编号","放款时间","放款金额","还款方式","贷款期限","日利率","还款日","放款账户","待还本金","待还利息+费用","已还金额","已还本金","已还利息+费用","结清时间"};

        //sheet名
        String sheetName = "贷款对账单";
        String [][] content = new String [jsLoanApplyInfoList.size()][];
        for (int i = 0; i < jsLoanApplyInfoList.size(); i++) {
            content[i] = new String[title.length];
            JsLoanApplyInfo jsLoanApplyInfo = jsLoanApplyInfoList.get(i);
            content[i][0] = jsLoanApplyInfo.getLoanNo();
            content[i][1] = "2019-09-09"; //放款时间
            content[i][2] = jsLoanApplyInfo.getRealAmt()+"";
            if(jsLoanApplyInfo.getRepayType().equals("01")){//自动还款
                content[i][3] = "按日计息";
            }
            content[i][4] = jsLoanApplyInfo.getLoanDays() + "天";
            content[i][5] = jsLoanApplyInfo.getInterestRate() + "%";
            content[i][6] = "2019-09-09";//还款日
            content[i][7] = jsLoanApplyInfo.getAcctNo();
            content[i][8] = "3000.00";//待还本金
            content[i][9] = "30.00";//待还利息+费用
            content[i][10] = "3000.00";//已还金额
            content[i][10] = "3000.00";//已还本金
            content[i][11] = "30.00";//已还利息+费用
            content[i][11] = "2019-09-09";//结清日期
        }
        //创建HSSFWorkbook
        HSSFWorkbook wb = ExcelUtil.getHSSFWorkbook(sheetName, title, content, null);
        return ResultUtil.success(wb,ResultEnum.SUCCESS);
    }
}
