package com.js.loan.service.impl;

import cn.hutool.core.util.IdUtil;
import com.aliyun.oss.common.utils.DateUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.js.api.jsloan.service.ApiJsLoanApplicationService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.RegisterType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.*;
import com.js.common.model.resp.JsTradesVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsLoanApplyInfoMapper;
import com.js.dal.dao.mapper.JsLoanRiskInfoMapper;
import com.js.dal.dao.mapper.JsTradeMapper;
import com.js.dal.dao.mapper.KycCertiHKCompanyMapper;
import com.js.dal.dao.model.JsLoanApplyInfo;
import com.js.dal.dao.model.JsLoanRiskInfo;
import com.js.dal.dao.model.JsTrade;
import com.js.dal.dao.model.KycCertiHKCompany;
import com.js.loan.mq.RabbitMQJsLoanSender;
import com.js.loan.utils.ContratUtils;
import com.js.loan.utils.DateUtils;
import com.js.loan.utils.LoanConfigureInfo;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import tk.mybatis.mapper.entity.Example;

import java.util.*;

@Slf4j
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
/**
 * 贷款申请
 */
public class ApiJsLoanApplicationServiceImpl implements ApiJsLoanApplicationService {

    @Autowired
    private JsLoanApplyInfoMapper jsLoanApplyInfoMapper;

    @Autowired
    private JsLoanRiskInfoMapper jsLoanRiskInfoMapper;

    @Autowired
    private JsTradeMapper jsTradeMapper;

    @Autowired
    private KycCertiHKCompanyMapper kycCertiHKCompanyMapper;

    @Autowired
    private RabbitMQJsLoanSender rabbitMQJsLoanSender;

    @Autowired
    private LoanConfigureInfo loanConfigureInfo;


    /**
     * 贷款申请
     */
    @Override
    public ResponseMessage loanApply(JsLoanApplyInfoReq req) {

        log.info("贷款申请开始 执行 ..KycNaturalId:{} " , req.getKycNaturalId());

        //查询该用户是否可以贷款
        JsLoanRiskInfo jsLoanRiskInfoQuery = new JsLoanRiskInfo();
        jsLoanRiskInfoQuery.setKycNaturalId(req.getKycNaturalId());
        jsLoanRiskInfoQuery.setDelFlag(false);
        jsLoanRiskInfoQuery = jsLoanRiskInfoMapper.selectOne(jsLoanRiskInfoQuery);
        if(null == jsLoanRiskInfoQuery){
            log.info("该用户未进行准入申请不可以进行贷款申请 KycNaturalId:{} " , req.getKycNaturalId());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"该用户未进行准入申请不可以进行贷款申请");
        }
        if(!jsLoanRiskInfoQuery.getStatus().equals(CommonConstant.LOAN_RISK_STATUS_ADOPT)){
            log.info("该用户准入信息未审核通过，不可以进行贷款申请 KycNaturalId:{} " , req.getKycNaturalId());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"该用户准入信息未审核通过，不可以进行贷款申请");
        }
        //判断是否有未结束的贷款信息
        JsLoanApplyInfo selectLoanApplyInfo = new JsLoanApplyInfo();
        selectLoanApplyInfo.setKycNaturalId(req.getKycNaturalId());
        selectLoanApplyInfo.setIsEnd("0");//未结束
        selectLoanApplyInfo = jsLoanApplyInfoMapper.selectOne(selectLoanApplyInfo);
        if(null != selectLoanApplyInfo){
            log.info("有未处理完毕的贷款信息，请核实");
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"有未处理完毕的贷款信息，请核实");
        }
        //初始化
        req.setProductNo(loanConfigureInfo.getProductNo());
        req.setLoanNo("YFJSXD" + DateUtils.getNewDateyyyyMMddHHmmss());
        req.setApplyDate(DateUtils.getNewDate());
        //添加借款信息
        JsLoanApplyInfo jsLoanApplyInfo = new JsLoanApplyInfo();
        BeanUtils.copyProperties(req,jsLoanApplyInfo);
        jsLoanApplyInfo.setId(IdUtil.simpleUUID());
        jsLoanApplyInfo.setProductName(loanConfigureInfo.getProductName());
        jsLoanApplyInfo.setInterestRate(loanConfigureInfo.getInterestRate());
        jsLoanApplyInfo.setYearRate(loanConfigureInfo.getYearRate());
        jsLoanApplyInfo.setApplyDate(new Date());
        jsLoanApplyInfo.setLoanStatus("10");//等待初审
        jsLoanApplyInfo.setProductName("及时雨");
        jsLoanApplyInfo.setIsEnd("0");//设置未结束
        int count = jsLoanApplyInfoMapper.insertSelective(jsLoanApplyInfo);
        if(count < 1){
             log.info("贷款申请添加到数据操作失败 count{}",count);
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"贷款申请添加到数据操作失败，添加记录小于1");
        }
        //推送准入信息
        Map<String,Object> map=new HashMap();
        map.put("type",CommonConstant.CUSTOMER_LOAN_APPLY); //10客户准入 20修改  30借款  40合同签署通知
        map.put("data",req);
        JSONArray array=JSONArray.fromObject(map);
        log.info("推送小贷贷款申请报文: reqMap:{}",array.toArray());
        //推送小贷
        rabbitMQJsLoanSender.loanRiskSender(array.toString());
        return ResultUtil.success(array.toString(), ResultEnum.SUCCESS);
    }

    /**
     * 放款记录查询（贷款记录详情）
     * @param loanNo
     * @param kycNaturalId
     * @return
     */
    @Override
    public ResponseMessage loanApplicationDetailed(String loanNo, String kycNaturalId) {
        //判断是否有未结束的贷款信息
        JsLoanApplyInfo selectLoanApplyInfo = new JsLoanApplyInfo();
        selectLoanApplyInfo.setKycNaturalId(kycNaturalId);
        selectLoanApplyInfo.setLoanNo(loanNo);
        selectLoanApplyInfo = jsLoanApplyInfoMapper.selectOne(selectLoanApplyInfo);
        if(null == selectLoanApplyInfo){
            log.info("未查询到贷款记录 ...loanNo:{}" ,loanNo);
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"未查询到贷款记录，请核实");
        }
        return ResultUtil.success(selectLoanApplyInfo);
    }

    @Override
    public ResponseMessage queryLoan(LoanApplicationReq loanApplicationReq) {

        if(null == loanApplicationReq){
            log.info("借款记录查询不能为空 ");
            return ResultUtil.error(ResultEnum.ERROR);
        }
        log.info("借款记录查询请求参数  loanApplicationReq:{}" ,loanApplicationReq);

        Example example=new Example(JsLoanApplyInfo.class);
        Example.Criteria criteria = example.createCriteria();
        //条件筛选
        if(null != loanApplicationReq.getLoanQueryStartTime()
                && !loanApplicationReq.getLoanQueryStartTime().equals("")
                && null != loanApplicationReq.getLoanQueryEndTime()
                && !loanApplicationReq.getLoanQueryEndTime().equals("")){
            criteria.andBetween("applyDate",loanApplicationReq.getLoanQueryStartTime(),loanApplicationReq.getLoanQueryEndTime());
        }
        if(null != loanApplicationReq.getLoanTermStartTime()
                && !loanApplicationReq.getLoanTermStartTime().equals("")
                && null != loanApplicationReq.getLoanTermEndTime()
                && !loanApplicationReq.getLoanTermEndTime().equals("")){
            criteria.andBetween("repaymentDate",loanApplicationReq.getLoanTermStartTime(),loanApplicationReq.getLoanTermEndTime());
        }
        if(null != loanApplicationReq.getRepayType() && !loanApplicationReq.getRepayType().equals("")){
            criteria.andEqualTo("repayType",loanApplicationReq.getRepayType());//
        }
        if(null != loanApplicationReq.getLoanStatus() && !loanApplicationReq.getLoanStatus().equals("")){
            criteria.andEqualTo("loanStatus",loanApplicationReq.getLoanStatus());//
        }
        criteria.andEqualTo("kycNaturalId",loanApplicationReq.getKycNaturalId());
        PageHelper.startPage(loanApplicationReq);
        List<JsLoanApplyInfo> jsLoanApplyInfos =  jsLoanApplyInfoMapper.selectByExample(example);
        PageInfo<JsLoanApplyInfo> jsLoanApplyInfoPageInfo = new PageInfo<>(jsLoanApplyInfos);
        return ResultUtil.success(jsLoanApplyInfoPageInfo);
    }

    @Override
    public ResponseMessage loanDetailed(String loanNo,String kycNaturalId) {

        Map<String,Object> resMap = new HashMap<>();
        //贷款编号
        resMap.put("loanNo","1232222333");
        //借款金额
        resMap.put("loanAmount","100000.00");
        //状态
        resMap.put("contractStatus","1");
        //贷款名称
        resMap.put("productName","小贷");
        //还款方式
        resMap.put("repayWay","01");
        //最晚还款期限
        resMap.put("endDate","2019-09-09");
        //日利费率
        resMap.put("interestRate","12");
        //借款时间
        resMap.put("loanDate","2019-09-09");
        //已还总额
        resMap.put("indeedTotal","2000.00");
        //最大逾期天数
        resMap.put("overdueDays","90");
        //借款本金
        resMap.put("loanAmount","30000.00");
        //最晚还款日
        resMap.put("endDate","2019-09-09");
        //List
        List<Map<String,Object>> resList = new ArrayList<>();
        Map<String,Object> resMap2 = new HashMap<>();
        Map<String,Object> resMap3 = new HashMap<>();
        //还款日期（已还）
        resMap2.put("repayDate","2019-09-09");
        //实还总额
        resMap2.put("total","3000.00");
        //实还本金
        resMap2.put("capital","2000.00");
        //实还利息及费用
        resMap2.put("interest","12");
        resMap2.put("instFee","12");
        //还款账号
        resMap2.put("repayNumber","200000998");

        resMap3.put("repayDate","2019-09-09");
        //实还总额
        resMap3.put("total","30000.99");
        //实还本金
        resMap3.put("capital","4000.00");
        //实还利息及费用
        resMap3.put("interest","12");
        resMap3.put("instFee","12");
        //还款账号
        resMap3.put("repayNumber","123");
        resList.add(resMap2);
        resList.add(resMap3);
        resMap.put("resList",resList);
        //未还本金
        resMap.put("plannedCapital","30000000");
        //还款日期
        resMap.put("repayDate","2019-09-09");
        //应还总额
        resMap.put("plannedTotal","300.88");
        //应还本金
        resMap.put("plannedCapital","30000.00");
        //应还利息费用
        resMap.put("plannedInterest","23");
        resMap.put("plannedInstFee","23");
        //最早还款日
        resMap.put("startDate","2019-09-09");
        //日利费率
        resMap.put("interestRate","23");
        //最晚还款日
        resMap.put("endDate","2019-09-09");
        //合同编号
        resMap.put("contractNo","300090887");
        //收款账户
        resMap.put("repayAccount","3990888");
        //放款机构
        resMap.put("loanOrg","3998899");
        return ResultUtil.success(resMap);
    }

    @Override
    public ResponseMessage queryContract(String loanNo,String kycNaturalId) {
        log.info("查询合同-借款基本信息... loanNo:{},keyNaturalId:{}",loanNo,kycNaturalId);
        //查询借款信息
        JsLoanApplyInfo jsLoanApplyInfo = new JsLoanApplyInfo();
        jsLoanApplyInfo.setKycNaturalId(kycNaturalId);
        jsLoanApplyInfo.setLoanNo(loanNo);
        jsLoanApplyInfo = jsLoanApplyInfoMapper.selectOne(jsLoanApplyInfo);
        if(null == jsLoanApplyInfo){
            log.info("查询合同 - 未查询到贷款申请信息... loanNo:{},keyNaturalId:{}",loanNo,kycNaturalId);
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"查询合同 - 未查询到贷款申请信息");
        }
        Map<String,Object> resMap = new HashMap<>();
        resMap.put("loanDays",jsLoanApplyInfo.getLoanDays());
        resMap.put("startDate",jsLoanApplyInfo.getStartDate());
        resMap.put("interestRate",jsLoanApplyInfo.getInterestRate());
        resMap.put("repayType",jsLoanApplyInfo.getRepayType());
        resMap.put("loanNo",loanNo);
        return ResultUtil.success(resMap);
    }

    @Override
    public ResponseMessage loanContract(String loanNo, String kycNaturalId) {

        log.info("查询合同参数loanNo:{},keyNaturalId:{}",loanNo,kycNaturalId);
        //查询借款信息
        JsLoanApplyInfo jsLoanApplyInfo = new JsLoanApplyInfo();
        jsLoanApplyInfo.setKycNaturalId(kycNaturalId);
        jsLoanApplyInfo.setLoanNo(loanNo);
        jsLoanApplyInfo = jsLoanApplyInfoMapper.selectOne(jsLoanApplyInfo);
        if(null == jsLoanApplyInfo){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"未查询到贷款申请信息");
        }
        if(!jsLoanApplyInfo.getLoanStatus().equals(CommonConstant.LOAN_APPLY_STATUS_C_VERIFY_ADOPT)){ //是否复审通过
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"贷款申请提额信息未审核通过，不能签署合同");
        }
        Map<String,Object> resMap = new HashMap();
        resMap.put("loanNo",jsLoanApplyInfo.getLoanNo());
        resMap.put("adoptAmt",jsLoanApplyInfo.getAdoptAmt());//审核通过金额
        resMap.put("repayWay",jsLoanApplyInfo.getRepayType()); //还款方式
        //日利费率
        resMap.put("interestRate",jsLoanApplyInfo.getInterestRate());
        //最早还款日期
        resMap.put("startDate",DateUtils.getNewDate());
        //最晚还款日期
        resMap.put("endDate",DateUtils.DateToStr(DateUtils.addDay(new Date(),jsLoanApplyInfo.getLoanDays())));
        return ResultUtil.success(resMap);
    }

    @Override
    public ResponseMessage signContract(SignContractReq signContractReq,KycNaturalVO kycNaturalVO) {
        log.info("签署合同请求参数signContractReq:{} ",signContractReq);
        Map<String,Object> resMap = new HashMap<>();
        //查询准入信息是否审核通过
        JsLoanRiskInfo jsLoanRiskInfo = new JsLoanRiskInfo();
        jsLoanRiskInfo.setKycNaturalId(kycNaturalVO.getId());
        jsLoanRiskInfo.setDelFlag(false);
        jsLoanRiskInfo = jsLoanRiskInfoMapper.selectOne(jsLoanRiskInfo);
        if(jsLoanRiskInfo == null){
            log.info("未查询到贷款准入信息 loanNo:{}",signContractReq.getLoanNo());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"未查询到贷款准入信息");
        }
        //查询借款信息
        JsLoanApplyInfo jsLoanApplyInfo = new JsLoanApplyInfo();
        jsLoanApplyInfo.setLoanNo(signContractReq.getLoanNo());
        jsLoanApplyInfo.setKycNaturalId(kycNaturalVO.getId());
        jsLoanApplyInfo = jsLoanApplyInfoMapper.selectOne(jsLoanApplyInfo);
        if(null == jsLoanApplyInfo){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"签署合同-未查询到贷款申请信息");
        }
        if(!jsLoanApplyInfo.getLoanStatus().equals(CommonConstant.LOAN_APPLY_STATUS_C_VERIFY_ADOPT)){ //是否复审通过
            log.info("贷款申请提额信息未审核通过，不能签署合同 loanNo:{}",signContractReq.getLoanNo());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"贷款申请提额信息未审核通过，不能签署合同");
        }

        if(signContractReq.getRealAmt().compareTo(jsLoanApplyInfo.getAdoptAmt()) == 1){
            log.info("实际贷款金额大于贷款审批金额，不能签署合同 realAmt:{},adoptAmt:{}",signContractReq.getRealAmt(),jsLoanApplyInfo.getAdoptAmt());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"实际贷款金额大于贷款审批金额，不能签署合同");
        }

        //更新实际放款金额
        JsLoanApplyInfo updateJsLoanApplyInfo = new JsLoanApplyInfo();
        updateJsLoanApplyInfo.setRealAmt(signContractReq.getRealAmt());
        Example example=new Example(JsLoanApplyInfo.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("kycNaturalId",kycNaturalVO.getId());
        criteria.andEqualTo("loanNo",signContractReq.getLoanNo());
        int count = jsLoanApplyInfoMapper.updateByExampleSelective(updateJsLoanApplyInfo,example);
        if(count < 1){
            log.info("更新贷款实际金额失败 loanNo:{},realAmt:{}",signContractReq.getLoanNo(),signContractReq.getRealAmt());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"更新贷款实际金额失败");
        }

        //借款协议含担保条款parameter
        Map<String, Object> parameter = new HashMap<>();
        //服务合同含担保条款parameter2
        Map<String, Object> parameter2 = new HashMap<>();
        //委托扣款授权书parameter3
        Map<String, Object> parameter3 = new HashMap<>();
        parameter.put("borrowerName",jsLoanRiskInfo.getBorrowerName());
        parameter.put("borrowerIdcard",jsLoanRiskInfo.getBorrowerIdcard());
        parameter.put("borrowerAddress",jsLoanRiskInfo.getBorrowerAddress());
        parameter.put("borrowerPhone",jsLoanRiskInfo.getBorrowerPhone());
        parameter.put("acctNo",jsLoanApplyInfo.getAcctNo());
        parameter.put("guaranteeCorp",jsLoanRiskInfo.getGuaranteeCorp());
        parameter.put("guaranteeCorpLegalname",jsLoanRiskInfo.getGuaranteeCorpLegalname());
        parameter.put("guaranteeCorpOrgcode",jsLoanRiskInfo.getGuaranteeCorpOrgcode());

        String contractName = null;
        String contractName2 = null;
        //判断是否是香港企业
        RegisterType registerType = kycNaturalVO.getRegisterType();
        if(registerType == RegisterType.HK_COMPANY) {
            KycCertiHKCompany kycCertiHKCompanyQuery = new KycCertiHKCompany();
            kycCertiHKCompanyQuery.setKycNaturalId(kycNaturalVO.getId());
            kycCertiHKCompanyQuery = kycCertiHKCompanyMapper.selectOne(kycCertiHKCompanyQuery);
            //借款协议含担保条款
            contractName = loanConfigureInfo.getContractNameHk();
            parameter.put("companyName",kycCertiHKCompanyQuery.getCompanyName());
            parameter.put("directorName",kycCertiHKCompanyQuery.getDirectorName());
            parameter.put("companyRegisteredCertificateNo",kycCertiHKCompanyQuery.getCompanyRegisteredCertificateNo());
            //服务合同含担保条款
            contractName2 = loanConfigureInfo.getContractName2Hk();
            parameter2.put("companyName",kycCertiHKCompanyQuery.getCompanyName());
            parameter2.put("directorName",kycCertiHKCompanyQuery.getDirectorName());
        }else{
            //借款协议含担保条款
            contractName = loanConfigureInfo.getContractNameHolder();
            //服务合同含担保条款
            contractName2 =  loanConfigureInfo.getContractName2Holder();
        }
        //借款协议含担保条款
        parameter.put("contractName", contractName);
        //服务合同含担保条款
        parameter2.put("contractName", contractName2);

        parameter.put("realAmt",signContractReq.getRealAmt());
        parameter.put("rateYear",jsLoanApplyInfo.getYearRate()); //贷款利息：年利率
        parameter.put("bankName",jsLoanApplyInfo.getBankName());
        parameter.put("acctName",jsLoanApplyInfo.getAcctName());
        parameter.put("borrowerEmail",jsLoanRiskInfo.getBorrowerEmail());
        byte[]  bytesParameter = ContratUtils.contrat(parameter,loanConfigureInfo.getContractUrl());

        //借款协议含担保条款
        String contractNo = IdUtil.simpleUUID();
        //服务合同含担保条款
        String contractNo2 = IdUtil.simpleUUID();
        parameter2.put("contractNo",contractNo2);
        parameter2.put("contractDate", DateUtil.formatIso8601Date(new Date()));
        parameter2.put("borrowerName",jsLoanRiskInfo.getBorrowerName());
        parameter2.put("borrowerIdcard",jsLoanRiskInfo.getBorrowerIdcard());
        parameter2.put("guaranteeCorp",jsLoanRiskInfo.getGuaranteeCorp());
        parameter2.put("guaranteeCorpLegalname",jsLoanRiskInfo.getGuaranteeCorpLegalname());
        byte[]  bytesParameter2 = ContratUtils.contrat(parameter2,loanConfigureInfo.getContractUrl());

        //委托扣款授权书
        String contractNo3 = IdUtil.simpleUUID();
        String contractName3 = loanConfigureInfo.getContractName3();
        parameter3.put("contractName",contractName3);
        parameter3.put("borrowerIdcard",jsLoanRiskInfo.getBorrowerIdcard());
        parameter3.put("agreementDate",DateUtil.formatIso8601Date(new Date()));
        parameter3.put("agreementNo",contractNo2); //本人与北京源奉济生网络科技有限公司于 平台服务合同
        parameter3.put("contractDate",DateUtil.formatIso8601Date(new Date()));
        parameter3.put("contractNo",contractNo);
        parameter3.put("jsMerchant",loanConfigureInfo.getChannelChinapnrId());
        parameter3.put("loanMerchant",loanConfigureInfo.getChannelSmallLoanId());
        byte[]  bytesParameter3 = ContratUtils.contrat(parameter3,loanConfigureInfo.getContractUrl());

        //参数fadada签章
        FadadaUploadContractReq fadadaUploadContractReq = new FadadaUploadContractReq();
        List<FadadaUploadContractReq.Contract> contractList = new ArrayList<>();
        FadadaUploadContractReq.Contract contract = fadadaUploadContractReq.new Contract();
        contract.setContractId(contractNo);
        contract.setFileBytes(bytesParameter);
        contract.setFileName(contractName);
        contract.setLoanNo(signContractReq.getLoanNo());
        contractList.add(contract);
        FadadaUploadContractReq.Contract contract2 = fadadaUploadContractReq.new Contract();
        contract2.setContractId(contractNo2);
        contract2.setFileName(contractName2);
        contract2.setFileBytes(bytesParameter2);
        contract2.setLoanNo(signContractReq.getLoanNo());
        contractList.add(contract2);
        FadadaUploadContractReq.Contract contract3 = fadadaUploadContractReq.new Contract();
        contract3.setFileBytes(bytesParameter3);
        contract3.setFileName(contractName3);
        contract3.setLoanNo(signContractReq.getLoanNo());
        contract3.setContractId(contractNo3);
        contractList.add(contract3);
        fadadaUploadContractReq.setContracts(contractList);

        //返回Map
        resMap.put("riskNo",jsLoanRiskInfo.getRiskNo());
        resMap.put("loanNo",jsLoanApplyInfo.getLoanNo());
        resMap.put("fadadaUploadContractReq",fadadaUploadContractReq);
        log.info("合同号 contractNo：{}，contractNo2：{}，contractNo3{}",contractNo,contractNo2,contractNo3);
        log.info("组装发大大签署合同成功reqMap-riskNo:{},loanNO:{}",resMap.get("riskNo"),resMap.get("loanNo"));
        return ResultUtil.success(resMap,ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage capitalDetailed(LoanCapitalReq loanCapitalReq) {

        Example example=new Example(JsTrade.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("accType","2");//汇付
        criteria.andEqualTo("kycNaturalId",loanCapitalReq.getKycNaturalId());
        if(null != loanCapitalReq.getCapitalType() && !loanCapitalReq.getCapitalType().equals("")){
            criteria.andEqualTo("tradeSubType",loanCapitalReq.getCapitalType());
        }
        if(null != loanCapitalReq.getCapitalQueryStartTime()
                && !loanCapitalReq.getCapitalQueryStartTime().equals("")
                && null != loanCapitalReq.getCapitalQueryEndTime()
                && !loanCapitalReq.getCapitalQueryEndTime().equals("")){
            criteria.andBetween("createDts",loanCapitalReq.getCapitalQueryStartTime(),loanCapitalReq.getCapitalQueryEndTime());
        }
        PageHelper.startPage(loanCapitalReq);
        List<JsTrade> jsTrades =  jsTradeMapper.selectByExample(example);
        List<JsTradesVO> jsTradesVOS = new ArrayList();
        for(JsTrade entity : jsTrades){
            JsTradesVO vo = new JsTradesVO();
            vo.setCapitalTime(entity.getCreateDts());
            if(entity.getTradeType().equals("0")){//账户入账
                vo.setAccount(entity.getInAcct());
            }else{
                vo.setAccount(entity.getOutAcct());
            }
            vo.setAccType(entity.getTradeSubType());
            vo.setStatus(entity.getProcessStatus());
            vo.setAccAmt(entity.getTradeAmt());
            vo.setCapitalNo(entity.getTradeNo());
            vo.setKycNaturalId(entity.getKycNaturalId());
            jsTradesVOS.add(vo);
        }
        PageInfo<JsTradesVO> jsTradesVOPageInfo = new PageInfo<>(jsTradesVOS);
        return ResultUtil.success(jsTradesVOPageInfo);
    }

    @Override
    public ResponseMessage capitalDetailedDetails(String capitalNo, String accType) {

        //CapitalDetailedDetailsVO vo = new CapitalDetailedDetailsVO();
        Map<String,Object> resMap = new HashMap<>();
        resMap.put("total","123");//还款金额
        resMap.put("capital","123");//本金
        resMap.put("interest","123");//利息
        resMap.put("instFee","123");//费用
        resMap.put("repayDate","123");//还款时间
        resMap.put("repayType","123");//还款类型
        resMap.put("otherFee","123");//还款手续费
        resMap.put("loanAmount","123");//借款金额
        resMap.put("loanDate","123");//借款时间
        resMap.put("repayWay","123");//还款方式
        resMap.put("capitalNo","123");//交易流水号
        resMap.put("loanNo","123");//贷款编号
        return ResultUtil.success(resMap);
    }

    /**
     * 合同归档
     * @param loanNo
     * @param kycNaturalVO
     * @return
     */
    @Override
    public ResponseMessage signVerification(String loanNo, KycNaturalVO kycNaturalVO) {
        log.info("合同归档成功后更新状态 loanNo:{}",loanNo);
        //查询数据
        JsLoanApplyInfo jsLoanApplyInfo = new JsLoanApplyInfo();
        jsLoanApplyInfo.setLoanNo(loanNo);
        jsLoanApplyInfo.setKycNaturalId(kycNaturalVO.getId());
        jsLoanApplyInfo.setLoanStatus(CommonConstant.LOAN_APPLY_STATUS_C_VERIFY_ADOPT);//复审通过
        jsLoanApplyInfo = jsLoanApplyInfoMapper.selectOne(jsLoanApplyInfo);
        if(null == jsLoanApplyInfo){
            log.info("未查询到复审通过需签合同的借款单 loanNo:{}",loanNo);
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"未查询到复审通过需签合同的借款单");
        }
        Example example=new Example(JsLoanApplyInfo.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("loanNo",loanNo);
        criteria.andEqualTo("kycNaturalId",kycNaturalVO.getId());
        JsLoanApplyInfo updateJsLoanApplyInfo = new JsLoanApplyInfo();
        updateJsLoanApplyInfo.setLoanStatus(CommonConstant.LOAN_APPLY_STATUS_CONTRACT_ADOPT); //合同签署成功
        int count = jsLoanApplyInfoMapper.updateByExampleSelective(updateJsLoanApplyInfo,example);
        if(count < 1){
            log.info("更新贷款合同状态失败 loanNo:{}",loanNo);
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"更新贷款合同状态失败");
        }
        //合同签署成功推送MQ到小贷
        //推送准入信息
        Map<String,Object> mqMap = new HashMap();
        mqMap.put("loanNo",loanNo);
        mqMap.put("loanStatus",CommonConstant.LOAN_APPLY_STATUS_CONTRACT_ADOPT);
        mqMap.put("kycNaturalId",kycNaturalVO.getId());
        mqMap.put("realAmt",jsLoanApplyInfo.getRealAmt());
        Map<String,Object> map=new HashMap();
        map.put("type",CommonConstant.CUSTOMER_LOAN_CONTRACT); //10客户准入 20修改  30借款 40电子签章
        map.put("data",mqMap);
        JSONArray array=JSONArray.fromObject(map);
        //推送小贷
        rabbitMQJsLoanSender.loanRiskSender(array.toString());
        return ResultUtil.success(ResultEnum.SUCCESS);
    }
}
