package com.js.loan.service.impl;

import cn.hutool.core.util.IdUtil;
import com.js.api.jsloan.service.ApiJsLoanRiskinfoService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsLoanRiskInfoReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsLoanRiskInfoMapper;
import com.js.dal.dao.model.JsLoanRiskInfo;
import com.js.loan.mq.RabbitMQJsLoanRiskSender;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@Slf4j
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
public class ApiJsLoanRiskinfoServiceImpl implements ApiJsLoanRiskinfoService {

    @Autowired
    private JsLoanRiskInfoMapper jsLoanRiskInfoMapper;

    @Autowired
    private RabbitMQJsLoanRiskSender rabbitMQJsLoanRiskSender;

    /**
     * 准入
     * @param req
     * @return
     */
    @Override
    public ResponseMessage loanRisk(JsLoanRiskInfoReq req) {
        log.info("准入信息推送小贷 执行 .. 准入申请编号 = " + req.getRiskNo());

        //推送准入信息
        Map<String,Object> map=new HashMap();
        map.put("type","10"); //10客户准入 20店铺  30借款
        map.put("data",req);
        JSONArray array=JSONArray.fromObject(map);
        //推送小贷
        rabbitMQJsLoanRiskSender.loanRiskSender(array.toString());

        JsLoanRiskInfo jsLoanRiskInfo = new JsLoanRiskInfo();

        BeanUtils.copyProperties(req,jsLoanRiskInfo);
        jsLoanRiskInfo.setId(IdUtil.simpleUUID());
        jsLoanRiskInfo.setRiskNo(IdUtil.simpleUUID());
        jsLoanRiskInfo.setStatus("0");
        jsLoanRiskInfoMapper.insert(jsLoanRiskInfo);

        return ResultUtil.success(ResultEnum.SUCCESS);
    }
}







