package com.js.loan.service.impl;

import cn.hutool.core.util.IdUtil;
import com.js.api.jsloan.service.ApiJsLoanApplicationService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsLoanApplyInfoReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsLoanApplyInfoMapper;
import com.js.dal.dao.model.JsLoanApplyInfo;
import com.js.loan.mq.RabbitMQJsLoanRiskSender;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
/**
 * 贷款申请
 */
public class ApiJsLoanApplicationServiceImpl implements ApiJsLoanApplicationService {

    @Autowired
    private RabbitMQJsLoanRiskSender rabbitMQJsLoanRiskSender;

    @Autowired
    private JsLoanApplyInfoMapper jsLoanApplyInfoMapper;

    /**
     * 贷款申请
     */
    @Override
    public ResponseMessage loanApply(JsLoanApplyInfoReq req) {

        log.info("贷款申请信息推送小贷 执行 .. 准入申请编号 = " + req.getLoanNo());

        //推送准入信息
        Map<String,Object> map=new HashMap();
        map.put("type","30"); //10客户准入 20店铺  30借款
        map.put("data",req);
        JSONArray array=JSONArray.fromObject(map);
        //推送小贷
        rabbitMQJsLoanRiskSender.loanRiskSender(array.toString());

        //添加借款信息
        JsLoanApplyInfo jsLoanApplyInfo = new JsLoanApplyInfo();
        BeanUtils.copyProperties(req,jsLoanApplyInfo);
        jsLoanApplyInfo.setId(IdUtil.simpleUUID());
        jsLoanApplyInfoMapper.insert(jsLoanApplyInfo);

        return ResultUtil.success(ResultEnum.SUCCESS);
    }
}
