package com.js.loan.mq;

//import com.js.common.constant.RabbitMqConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;


/**
 * @Author zhouyongsheng
 * @Description mq 准入贷款申请信息发送
 * @Date 2019/3/1 14:39
 * @Param
 * @return
 **/
@Component
@Slf4j
public class RabbitMQJsLoanRiskSender {
    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Value("${spring.rabbitmq.exchange}")
    private String topicExchange;

    @Value("${spring.rabbitmq.routeKeyLoanRisk}")
    private String routeKeyPay;

    /**
     * @Author zhouyongsheng
     * @Description 准入贷款申请信息发送
     * @Date 2019/5/15 16:53
     * @Param [bidId]
     * @return void
     **/
    public void loanRiskSender(String message) {
        log.info("com.js.loan.mq.RabbitMQJsLoanRiskSender.senderTest message:{}", message);

        this.rabbitTemplate.convertAndSend(topicExchange,
                routeKeyPay,
                message,
                new CorrelationData());
    }

}
