package com.js.loan.mq;

import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.ExchangeTypes;
import org.springframework.amqp.rabbit.annotation.*;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @Author yjzhao
 * @Description 监听 mq 准入贷款信息状态信息接收
 * @Date 2019/3/1 14:51
 * @Param
 * @return
 **/
@Slf4j
@Component
//@EnableRabbit
//@Configuration
public class RabbitMQJsLoanRiskReceiver {

    @RabbitListener(
            bindings = @QueueBinding(
                    value = @Queue(value = "${spring.rabbitmq.queueLoan}", durable = "true"),
                    exchange = @Exchange(value = "${spring.rabbitmq.exchange}", type = ExchangeTypes.TOPIC),
                    key = "${spring.rabbitmq.routeKeyLoan}"
            )
    )
    @RabbitHandler
    public void loanMessage(@Payload String testId,
                              @Headers Map<String,Object> headers,
                              Channel channel) {
        log.info("com.js.loan.mq.RabbitMQJsLoanRiskReceiver.loanMessage testId:{}, headers:{}, channel:{}", testId, headers, channel);

    }


}
