package com.js.api.jsloan.service;

import com.js.common.model.req.JsLoanBillFilePageReq;
import com.js.common.model.req.JsLoanBillFileReq;
import com.js.common.model.vo.common.ResponseMessage;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 贷款对账文件
 * @Author: zhouyongsheng
 * @Create: 2019-06-13
 **/
@Path("apiJsLoanBillFile")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiJsLoanBillFileService {

    /**
     * 对账文件申请查询
     * @return
     */
    @POST
    @Path("applyQuery")
    ResponseMessage applyQuery(JsLoanBillFilePageReq jsLoanBillFilePageReq);

    /**
     * 对账文件申请
     * @return
     */
    @POST
    @Path("applyOperation")
    ResponseMessage applyOperation(JsLoanBillFileReq jsLoanBillFileReq);

    /**
     * 对账文件下载
     * @return
     */
    @POST
    @Path("download")
    ResponseMessage download(String kycNaturalId,String loanBillNo);
}
