package com.js.api.jsloan.service;


import com.js.common.model.req.JsLoanStatisticsInfoReq;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.web.bind.annotation.RequestBody;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

/**
 * 用户基础信息服务
 */
@Path("statisticsInfo")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
@Consumes({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiStatisticsInfoService {

    /**
     * 根据用户 kycNaturalId 提供用户基本信息
     */
    @GET
    @Path("baseInfo/{kycNaturalId}")
    ResponseMessage getBaseInfo(@PathParam("kycNaturalId") String kycNaturalId);

    /**
     * 根据用户 kycNaturalId 统计平台信息（实时的）
     */
    @GET
    @Path("platform/statistics/{kycNaturalId}")
    ResponseMessage getPlatformStatisticsInfo(@PathParam("kycNaturalId") String kycNaturalId);

    /**
     * 风控运营能力部分指标计算
     */
    @GET
    @Path("platform/amazonRiskQuota/{kycNaturalId}")
    ResponseMessage getAmazonRiskQuota(@PathParam("kycNaturalId") String kycNaturalId);

    /**
     * 获取店铺列表
     */
    @POST
    @Path("platform/amazonDataAnalysisByStore/storeList")
    ResponseMessage getStoreList(@RequestBody JsLoanStatisticsInfoReq jsLoanStatisticsInfoReq);

    /**
     * 获取单店铺
     */
    @GET
    @Path("platform/amazonDataAnalysisByStore/store/{storeId}")
    ResponseMessage getStore(@PathParam("storeId") String storeId);

    /**
     * 店铺趋势与指标相关
     */
    @GET
    @Path("platform/amazonDataAnalysisByKyc/kycHis/{kycNaturalId}")
    ResponseMessage getKycHis(@PathParam("kycNaturalId") String kycNaturalId);
}
