package com.js.api.jsloan.service;

import com.js.common.model.req.JsLoanRiskInfoReq;
import com.js.common.model.vo.common.ResponseMessage;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 贷款信息准入接口
 * @Author: zhouyongsheng
 * @Create: 2019-06-13
 **/
@Path("apiJsLoanRiskinfo")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiJsLoanRiskinfoService {


    /**
     * @Author zhouyongsheng
     * @Description 准入
     * @Date 2019/6/13
     **/
    @POST
    @Path("loanRisk")
    ResponseMessage loanRisk(JsLoanRiskInfoReq req);

    /**
     * 准入列表
     * @param kycNaturalId
     * @param pageNum
     * @param pageSize
     * @return
     */
    @POST
    @Path("queryAccess")
    ResponseMessage queryAccess(String kycNaturalId,int pageNum,int pageSize);

    /**
     * 申请列表详情
     * @param riskNo
     * @param kycNaturalId
     * @return
     */
    @POST
    @Path("queryAccessDetails")
    ResponseMessage queryAccessDetails(String riskNo,String kycNaturalId);

    /**
     * 准入明细信息
     * @param kycNaturalId
     * @return
     */
    @POST
    @Path("queryLoanRisk")
    ResponseMessage queryLoanRisk(String kycNaturalId);

    /**
     * @Author zhouyongsheng
     * @Description 修改准入信息
     * @Date 2019/6/13
     **/
    @POST
    @Path("updateLoanRisk")
    ResponseMessage updateLoanRisk(JsLoanRiskInfoReq req);

}
