package com.js.api.jsloan.service.qichacha;

import com.js.common.model.vo.common.ResponseMessage;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

/**
 * 企查查企业工商信息查询
 */
@Path("enterpriseInfo")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
@Consumes({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface QiChaChaEnterpriseInfoService {

    /**
     * 企业信息，借贷系统使用
     * @param kycNaturalId
     * @return
     */
    @GET
    @Path("getEnterpriseInfo/{kycNaturalId}")
    ResponseMessage getEnterpriseInfo(@PathParam("kycNaturalId") String kycNaturalId);

    /**
     * 获取 25% 占有股的股东
     * @param kycNaturalId
     * @param enterpriseName
     * @return
     */
    @GET
    @Path("getEnterprise25Partners")
    ResponseMessage getEnterprise25Partners(@QueryParam("kycNaturalId") String kycNaturalId, @QueryParam("enterpriseName") String enterpriseName);

    /**
     * 穿透获取 25% 占有股的股东
     * @param kycNaturalId
     * @param enterpriseName
     * @return
     */
    @GET
    @Path("getEnterprisePartners")
    ResponseMessage getEnterprisePartners2(@QueryParam("kycNaturalId") String kycNaturalId,
                                           @QueryParam("enterpriseName") String enterpriseName);

    /**
     * 校验公司名称与企业信用代码是否一致
     */
    @GET
    @Path("checkEnterpriseAndCreditCode")
    ResponseMessage checkEnterpriseAndCreditCode(@QueryParam("kycNaturalId") String kycNaturalId,
                                                 @QueryParam("enterpriseName") String enterpriseName,
                                                 @QueryParam("creditCode") String creditCode);

    /**
     * 判断企业信息近一年是否发生过异常
     */
    @GET
    @Path("getHasException")
    ResponseMessage getHasException(@QueryParam("kycNaturalId") String kycNaturalId,
                                    @QueryParam("enterpriseName") String enterpriseName);

}
