package com.js.api.jsloan.service;

import com.js.common.enums.RegisterType;
import com.js.common.model.req.KycStoreLoanReq;
import com.js.common.model.vo.common.ResponseMessage;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * @Author zhouyngsheng
 * @Description 店铺贷列表
 * @Date 2019/8/1
 **/
@Path("storeLoan")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiStoreLoanService {

    /**
     * 店铺贷店铺列表
     *
     * 列表中，入账金额与笔均入账金额都以最近统计的时间为准。
     * 店铺授权状态 2、3 均认为授权状态。0为未授权状态
     * @see com.js.common.enums.StoreAuthStatusEnum
     */
    @POST
    @Path("getStoreLoanList")
    ResponseMessage getStoreLoanList(KycStoreLoanReq kycStoreLoanReq);

    /**
     * 店铺贷-入口基本信息查询
     * @param kycNatural
     * @return
     */
    @POST
    @Path("condition")
    ResponseMessage condition(String kycNatural);

    /**
     * KEY信息查询
     * @return
     */
    @POST
    @Path("getKeyNatural")
    ResponseMessage getKeyNatural(String kycNaturalId, RegisterType registerType);

}
