package com.js.api.jsloan.service;

import com.js.common.model.req.JsLoanApplyInfoReq;
import com.js.common.model.req.LoanApplicationReq;
import com.js.common.model.req.LoanCapitalReq;
import com.js.common.model.req.SignContractReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.math.BigDecimal;

/**
 * @Description: 贷款信息申请接口
 * @Author: zhouyongsheng
 * @Create: 2019-06-13
 **/
@Path("apiJsLoanApplyInfo")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiJsLoanApplicationService {

    /**
     * @Author zhouyongsheng
     * @Description 申请
     * @Date 2019/6/13
     **/
    @POST
    @Path("loanApply")
    ResponseMessage loanApply(JsLoanApplyInfoReq req);

    /**
     * 查询借款记录详细信息（放款详情需要）
     * @return
     */
    @POST
    @Path("loanApplicationDetailed")
    ResponseMessage  loanApplicationDetailed(String loanNo,String kycNaturalId);

    /**
     * 借款记录查询
     * @return
     */
    @POST
    @Path("queryLoan")
    ResponseMessage queryLoan(LoanApplicationReq loanApplicationReq);

    /**
     * 借款记录详情
     * @return
     */
    @POST
    @Path("loanDetailed")
    ResponseMessage loanDetailed(String loanNo,String kycNaturalId);

    /**
     * 合同查询
     * @return
     */
    @POST
    @Path("queryContract")
    ResponseMessage queryContract(String loanNo,String kycNaturalId);


    /**
     * 签署支用合同查询
     * @return
     */
    @POST
    @Path("signContract")
    ResponseMessage loanContract(String loanNo, String kycNaturalId);
    /**
     * 签署合同
     * @return
     */
    @POST
    @Path("signContract")
    ResponseMessage signContract(SignContractReq signContractReq,KycNaturalVO kycNaturalVO);

    /**
     * 资金明细查询
     * @return
     */
    @POST
    @Path("capitalDetailed")
    ResponseMessage capitalDetailed(LoanCapitalReq loanCapitalReq);

    /**
     * 资金明细详情
     * @param loanNo 贷款流水号
     * @param applyId 资金明细详情ID
     * @return
     */
    @POST
    @Path("capitalDetailedDetails")
    ResponseMessage capitalDetailedDetails(String loanNo, String applyId);

    /**
     * 合同归档
     * @return
     */
    @POST
    @Path("signVerification")
    ResponseMessage signVerification(String loanNo, KycNaturalVO kycNaturalVO);
}
