package com.js.api.jsloan.service;

import com.js.common.model.req.KycLoanBankReq;
import com.js.common.model.vo.common.ResponseMessage;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 贷款绑定银行卡
 * @Author: zhouyongsheng
 * @Create: 2019-06-13
 **/
@Path("apiKycLoanBank")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiKycLoanBankService {

    /**
     * @Author zhouyongsheng
     * @Description 绑定银行卡
     * @Date 2019/6/13
     **/
    @POST
    @Path("addBank")
    ResponseMessage addBank(KycLoanBankReq kycLoanBankReq);

    /**
     * @Author zhouyongsheng
     * @Description 查询银行卡列表
     * @Date 2019/6/13
     **/
    @POST
    @Path("queryBankList")
    ResponseMessage queryBankList(String kycNaturalId);

    /**
     * @Author zhouyongsheng
     * @Description 查询该银行开是否已经绑过
     * @Date 2019/6/13
     **/
    @POST
    @Path("queryBankFlag")
    ResponseMessage queryBankFlag(KycLoanBankReq kycLoanBankReq);
    /**
     * @Author zhouyongsheng
     * @Description 查询该用户是否已经在汇付开户
     * @Date 2019/6/13
     **/
    @POST
    @Path("accountFalg")
    ResponseMessage accountFalg(String kycNaturalId);
}
