package com.js.api.jsloan.service.fadada;

import com.js.common.model.req.FadadaSignContractResultReq;
import com.js.common.model.req.FadadaUploadContractReq;
import com.js.common.model.resp.FadadaContractVO;
import com.js.common.model.vo.common.ResponseMessage;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

@Path("apiFadadaService")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiFadadaService {

    /**
     * 开始签署合同
     * @param riskNo
     * @param loanNo
     * @return
     */
    @GET
    @Path("sign")
    ResponseMessage sign(@QueryParam("riskNo") String riskNo, @QueryParam("loanNo") String loanNo);

    /**
     * 合同归档
     * @param kycNatualId
     * @param loanNo
     * @return
     */
    @GET
    @Path("archiveContract2")
    ResponseMessage archiveContract2(@QueryParam("kycNatualId") String kycNatualId, @QueryParam("loanNo") String loanNo);

    /**
     * 根据贷款申请编号获取合同列表。
     * @param loanNo
     * @return
     */
    ResponseMessage getFadadaContractVOByLoanNo(String loanNo);

    /**
     * 更新合同
     */
    ResponseMessage updateContract(FadadaContractVO fadadaContractVO);

    /**
     * 获取未签署的合同地址。
     * @param loanNo
     * @return
     */
    @GET
    @Path("getUnSignContractByLoanNo")
    ResponseMessage getUnSignContractByLoanNo(@QueryParam("loanNo") String loanNo);

    /**
     * 目前用户签署状态。
     * @param loanNo
     * @return total 总共需要用户签署的数量, unsigned: 已经签署的数量, status 合同状态 0:可以签署的新合同 1:不可以签新合同
     *
     */
    @GET
    @Path("getSignStatus")
    ResponseMessage getSignStatus(@QueryParam("loanNo") String loanNo);

    /**
     * 合同签署结果。同步通知
     */
    @GET
    @Path("getSignContractResultByReturnUrl")
    ResponseMessage getSignContractResultByReturnUrl(FadadaSignContractResultReq fadadaSignContractResultReq);

    /**
     * 法大大账号开户
     */
    @POST
    @Path("openAccount")
    ResponseMessage openAccount(String kycNaturalId, String accountType);

    /**
     * 个人实名信息存证
     *
     * 1.同一个用户，多次使用签章时如果四要素没变不用重复开户。
     * 2.同一个用户，不同的四要素需要开新户
     */
    @POST
    @Path("personDeposit")
    ResponseMessage personDeposit(String kycNaturalId, String jsLoanRiskInfoId, String jsLoanApplyInfoId);

    /**
     * 企业实名信息存证
     */
    @POST
    @Path("companyDeposit")
    ResponseMessage companyDeposit(String fadadaOpenAccountId, String jsLoanRiskInfoId);

    ResponseMessage companyDeposit2(String fadadaOpenAccountId, String jsLoanRiskInfoId, String fadadaCertiHKCompanyId);

    /**
     * 编号证书申请。
     */
    @POST
    @Path("applyClientNumCert")
    ResponseMessage applyClientNumCert(String kycNaturalId);

    ResponseMessage applyClientNumCert2(String fadadaCertiCompanyId);

    /**
     * 自定义印章
     */
    @POST
    @Path("customSignature")
    ResponseMessage customSignature(String kycNaturalId, String name, String customerId);

    /**
     * 印章上传
     */
    @POST
    @Path("addSignature2")
    ResponseMessage addSignature2(String kycNaturalId);


    /**
     * 合同上传
     */
    @GET
    @Path("uploadContract")
    ResponseMessage uploadContract(@QueryParam("loanNo") String loanNo,
                                   @QueryParam("fileName") String fileName,
                                   @QueryParam("contractId") String contractId,
                                   @QueryParam("filePath") String filePath);

    /**
     * 合同上传
     */
    @GET
    @Path("uploadContract2")
    ResponseMessage uploadContract2(FadadaUploadContractReq fadadaUploadContractReq);


    /**
     * 手动合同签署
     */
    ResponseMessage signContract(String kycNaturalId, String customerId, String contractId, String mobile);

    /**
     * 手动合同签署，骑缝章
     */
    ResponseMessage signContract2(String customerId, String contractId);

    /**
     * 自动合同签署
     */
    ResponseMessage signContractAuto(String contractId, String customerId, int y);

    /**
     * 合同归档
     */
    ResponseMessage contractArchive(String contractId);

    /**
     * 合同查看
     */
    ResponseMessage viewContract(String contractId);

    /**
     * 合同下载
     */
    ResponseMessage downloadContract(String contractId);

}
