package com.js.api.jsloan.service;

import com.js.common.model.req.RepaymentLoanReq;
import com.js.common.model.req.RepaymentOperationReq;
import com.js.common.model.req.RepaymentTrialReq;
import com.js.common.model.vo.common.ResponseMessage;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 还款信息接口
 * @Author: zhouyongsheng
 * @Create: 2019-06-13
 **/
@Path("apiJsLoanRiskinfo")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiJsLoanRepaymentService {

    /**
     * 还款明细查询
     * @return
     */
    @POST
    @Path("detailed")
    ResponseMessage detailed(String loanNo);

    /**
     * 需还款记录查询
     * @return
     */
    @POST
    @Path("loanSituation")
    ResponseMessage loanSituation(RepaymentLoanReq repaymentLoanReq);

    /**
     * 还款操作
     * @return
     */
    @POST
    @Path("operation")
    ResponseMessage operation(RepaymentOperationReq repaymentOperationReq);

    /**
     * 还款试算
     * @return
     */
    @POST
    @Path("trial")
    ResponseMessage trial(RepaymentTrialReq repaymentTrialReq);

    /**
     * 店铺账户查询
     * @param kycNaturalId
     * @return
     */
    @POST
    @Path("queryStoreAccount")
    ResponseMessage queryStoreAccount(String kycNaturalId);
}
