package com.js.api.jsloan.service;


import com.js.common.model.req.JsLoanStatisticsInfoReq;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

/**
 * 用户基础信息服务
 */
@Path("statisticsInfo")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
@Consumes({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiStatisticsInfoService {

    /**
     * 根据用户 kycNaturalId 提供用户基本信息
     */
    @GET
    @Path("baseInfo/{kycNaturalId}")
    ResponseMessage getBaseInfo(@PathParam("kycNaturalId") String kycNaturalId);

    /**
     * 根据用户 kycNaturalId 提供用户相关店铺信息列表
     */
    @POST
    @Path("platform/kyc")
    ResponseMessage getPlatformKycInfo(@RequestBody JsLoanStatisticsInfoReq jsLoanStatisticsInfoReq);

    /**
     * 根据用户 id， 统计时间
     */
    @POST
    @Path("platform/storeList")
    ResponseMessage getPlatformStoreInfoList(@RequestBody JsLoanStatisticsInfoReq jsLoanStatisticsInfoReq);

    /**
     * 根据用户 storeId 提供用户店铺相关信息
     */
    @POST
    @Path("platform/store")
    ResponseMessage getPlatformStoreInfo(@RequestBody JsLoanStatisticsInfoReq jsLoanStatisticsInfoReq);

    /**
     * 根据用户 kycNaturalId 统计平台信息（实时的）
     */
    @GET
    @Path("platform/statistics/{kycNaturalId}")
    ResponseMessage getPlatformStatisticsInfo(@PathParam("kycNaturalId") String kycNaturalId);
}
