package com.js.web.validate.code.email;


import cn.hutool.core.convert.Convert;
import com.js.common.model.req.ValidateCodeReq;
import com.js.web.properties.ValidateCodeProperties;
import com.js.web.validate.code.ValidateCode;
import com.js.web.validate.code.ValidateCodeGenerator;
import org.apache.commons.lang.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.ZoneOffset;

/**
 * 邮箱验证码模板
 */
@Component("emailValidateCodeGenerator")
public class EmailCodeGenerator implements ValidateCodeGenerator {

    @Autowired
    private ValidateCodeProperties validateCodeProperties;

    @Override
    public ValidateCode generate(ValidateCodeReq validateCodeReq) {
        String code = RandomStringUtils.randomNumeric(validateCodeProperties.getEmail().getLength());
        int expireIn = validateCodeProperties.getEmail().getExpireIn();
        Long markLong = LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli();
        return new ValidateCode(code, Convert.toStr(markLong), expireIn,validateCodeReq.getEmailAdd());
    }
}
