package com.js.web.utils;

import cn.xsshome.taip.face.TAipFace;
import cn.xsshome.taip.ocr.TAipOcr;
import com.alibaba.fastjson.JSONObject;
import com.js.common.enums.CertiFileType;
import com.js.common.enums.OcrType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ImageCompressUtil;
import com.js.common.util.ResultUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.springframework.util.Base64Utils;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;

@Slf4j
public class TAipUtil {
    private static String appId = "2117232408";
    private static String appKey = "gsSvG848hBDZeqQt";

    public static ResponseMessage ocrIdentify(MultipartFile file, CertiFileType certiFileType){
        String result;
        try {
            TAipOcr tAipOcr = new TAipOcr(appId,appKey);
            TAipFace tAipFace = new TAipFace(appId,appKey);
            log.info("ocr识别影像信息-开始:{}",certiFileType);
            byte[] bytes = file.getBytes();
            ByteArrayInputStream fileByteArrayInputStream = ImageCompressUtil.compressPicForScale(bytes, 1024);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtils.copy(fileByteArrayInputStream,byteArrayOutputStream);
            byte[] image = byteArrayOutputStream.toByteArray();
            if (CertiFileType.CARD_FRONT_IMAGE.equals(certiFileType) || CertiFileType.CARD_BACK_IMAGE.equals(certiFileType)) {
                //身份证正反面识别方法
                result = tAipOcr.idcardOcr(image, certiFileType.getEnumCode());
            }else if(CertiFileType.BUSINESS_LICENSE_IMAGE.equals(certiFileType)){
                //企业营业执照识别方法
                result = tAipOcr.bizlicenseOcr(image);
            }else if(CertiFileType.CARD_HANDID_IMAGE.equals(certiFileType)){
                //手持身份证影像
                return ResultUtil.success(handInFaceCompare(file,tAipOcr,tAipFace));
            }else {
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR);
            }
            JSONObject queryJson = JSONObject.parseObject(result);
            String ret = queryJson.getString("ret");
            if("0".equals(ret)){
                log.info("识别成功:{}",queryJson);
                JSONObject resultJson = queryJson.getJSONObject("data");
                resultJson.remove("frontimage");
                resultJson.remove("backimage");
                return ResultUtil.success(resultJson);
            }else{
                log.error("识别失败:{}",queryJson.get("msg"));
            }
        }catch (Exception ex){
            log.error("请求ocr识别异常", ex);
            return ResultUtil.error(ResultEnum.ERROR);
        }
        return ResultUtil.error(ResultEnum.ERROR);
    }

    private static String handInFaceCompare(MultipartFile file,TAipOcr tAipOcr,TAipFace tAipFace) throws Exception{
        //身份证正反面识别方法
        byte[] image = file.getBytes();
        String idcardOcr = tAipOcr.idcardOcr(image, OcrType.ID_CARD_FRONT.getCode());
        JSONObject queryJson = JSONObject.parseObject(idcardOcr);
        String ret = queryJson.getString("ret");
        String returnResult = "false";
        if("0".equals(ret)){
            log.info("手持对比身份证正面识别成功:{}",queryJson);
            JSONObject jsonObject = queryJson.getJSONObject("data");
            String frontimage = jsonObject.getString("frontimage");
            byte[] bytesSource = Base64Utils.decodeFromString(frontimage);
            //人脸对比
            String resultCompare = tAipFace.faceCompare(bytesSource,file.getBytes());
            JSONObject compareResult = JSONObject.parseObject(resultCompare);
            if("0".equals(compareResult.getString("ret"))){
                JSONObject compareDate = compareResult.getJSONObject("data");
                int similarity = compareDate.getIntValue("similarity");
                if(similarity > 50){
                    returnResult = "true";
                }
            }
        }else{
            log.error("手持对比身份证正面识别失败:{}",queryJson.get("msg"));
        }
        log.info("手持证件对比结果:{}",returnResult);
        return returnResult;
    }
}
