package com.js.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.itextpdf.text.*;
import com.itextpdf.text.pdf.*;
import com.js.api.jspay.service.ApiGenerateFileRecordService;
import com.js.api.jspay.service.ApiJsPaySunrateBankTradeInService;
import com.js.api.jspay.service.ApiJsPaySunrateTradeLockPriceService;
import com.js.common.constant.Constant;
import com.js.common.enums.*;
import com.js.common.model.req.GenerateFileRecordReq;
import com.js.common.model.req.JsTradeFundReq;
import com.js.common.model.req.JsTradeListReq;
import com.js.common.model.vo.*;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ReqNoUtil;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsFileSerivce;
import com.js.web.service.JsPayTradeService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.math.BigDecimal;
import java.util.*;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description: 寻汇虚拟银行账户服务实现
 * @Author: liuh
 * @Create: 2019-05-21
 **/
@Slf4j
@Service
public class JsPayTradeServiceImpl implements JsPayTradeService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiJsPaySunrateBankTradeInService apiJsPaySunrateBankTradeInService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiJsPaySunrateTradeLockPriceService apiJsPaySunrateTradeLockPriceService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiGenerateFileRecordService apiGenerateFileRecordService;
    @Autowired
    private JsFileSerivce jsFileSerivce;
    @Value("${js.file.path}")
    private String templateFilePath;

    @Override
    public ResponseMessage tradeList(JsTradeListReq jsTradeListReq, KycNaturalVO kycNaturalVO) {
        log.info("查询交易明细开始：{}", jsTradeListReq);
        if(null == jsTradeListReq.getTradeType()){
            log.error("交易类型不能为空");
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() + "交易类型不能为空");
        }
        if(TradeTypeEnum.TRADE_IN.equals(jsTradeListReq.getTradeType())){
            //入账交易查询
            return apiJsPaySunrateBankTradeInService.tradeInList(jsTradeListReq, kycNaturalVO);
        }else if(TradeTypeEnum.TRADE_WITHDRAW.equals(jsTradeListReq.getTradeType())){
            //提现交易查询
            jsTradeListReq.setTradeSubType(TradeSubTypeEnum.WITHDRAW);
            return apiJsPaySunrateTradeLockPriceService.withdrawList(jsTradeListReq,kycNaturalVO);
        }else if(TradeTypeEnum.TRADE_REPAYMENT.equals(jsTradeListReq.getTradeType())){
            //还款交易查询
//            return apiJsPaySunrateTradeLockPriceService.withdrawAndRefundList(jsTradeListReq,kycNaturalVO);
        }else{
            log.info("不支持的交易查询类型");
        }
        log.info("查询交易明细结束");
        return ResultUtil.error(ResultEnum.ERROR);
    }

    @Override
    public ResponseMessage tradeDetail(TradeTypeEnum tradeType, String tradeId) {
        log.info("交易列表查询交易详情-开始：{},{}",tradeType,tradeId);
        if(TradeTypeEnum.TRADE_IN.equals(tradeType)){
            //入账交易详情查询
            return apiJsPaySunrateBankTradeInService.tradeInDetail(tradeId);
        }else if(TradeTypeEnum.TRADE_WITHDRAW.equals(tradeType)){
            //提现交易详情查询
            return apiJsPaySunrateTradeLockPriceService.withdrawDetail(tradeType,TradeSubTypeEnum.WITHDRAW,tradeId);
        }else if(TradeTypeEnum.TRADE_REPAYMENT.equals(tradeType)){
            //还款交易详情查询
            return apiJsPaySunrateTradeLockPriceService.withdrawAndRefundDetail(tradeId);
        }else{
            log.info("不支持的交易详情查询类型");
        }
        log.info("查询交易详情-结束");
        return ResultUtil.error(ResultEnum.ERROR);
    }

    @Override
    public ResponseMessage fundDetailList(JsTradeFundReq jsTradeFundReq, KycNaturalVO kycNaturalVO) {
        log.info("查询资金明细开始：{}", jsTradeFundReq);
        ResponseMessage responseMessage = apiJsPaySunrateTradeLockPriceService.fundDetailList(jsTradeFundReq, kycNaturalVO);
        log.info("查询资金明细结束");
        return responseMessage;
    }

    @Override
    public ResponseMessage fundDetail(TradeTypeEnum tradeType, String fundDetailId) {
        log.info("资金列表查询交易详情-开始：{},{}",tradeType,fundDetailId);
        if(TradeTypeEnum.TRADE_IN.equals(tradeType)){
            //入账交易详情查询
            return apiJsPaySunrateBankTradeInService.tradeInDetail(fundDetailId);
        }else if(TradeTypeEnum.TRADE_WITHDRAW.equals(tradeType)){
            //提现交易详情查询
            return apiJsPaySunrateTradeLockPriceService.withdrawFundDetail(tradeType,fundDetailId);
        }else if(TradeTypeEnum.TRADE_REPAYMENT.equals(tradeType)){
            //还款交易详情查询
            return apiJsPaySunrateTradeLockPriceService.withdrawAndRefundDetail(fundDetailId);
        }else{
            log.info("不支持的交易详情查询类型");
        }
        log.info("查询交易详情-结束");
        return ResultUtil.error(ResultEnum.ERROR);
    }

    @Override
    public ResponseMessage generateFileRecordList(GenerateFileType generateFileType,KycNaturalVO kycNaturalVO) {
        log.info("查询生成记录信息：{}",generateFileType);
        return apiGenerateFileRecordService.generateFileRecordList(generateFileType,kycNaturalVO);
    }

    @Override
    public ResponseMessage generateTradeRecord(JsTradeListReq jsTradeListReq,KycNaturalVO kycNaturalVO) {
        log.info("生成文件开始：{}",jsTradeListReq);
        if(null == jsTradeListReq.getTradeStartDate()){
            log.error("起始日期不能为空");
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() + "起始日期不能为空");
        }
        if(null == jsTradeListReq.getTradeEndDate()){
            log.error("结束日期不能为空");
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() + "结束日期不能为空");
        }
        if(null == jsTradeListReq.getGenerateFileType()){
            log.error("下载类型不能为空");
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() + "下载类型不能为空");
        }
        log.info("生成提现交易记录：{}",jsTradeListReq);
        try {
            String fileName = "";
            String fileExt = "";
            String fileNameAfter = DateUtil.format(jsTradeListReq.getTradeStartDate(), "yyyyMMdd") + "-" + DateUtil.format(jsTradeListReq.getTradeEndDate(), "yyyyMMdd");
            if(GenerateFileType.GENERATE_TRADE_RECORD.equals(jsTradeListReq.getGenerateFileType())){
                log.info("下载交易记录");
                if(null == jsTradeListReq.getTradeType()){
                    log.error("交易类型不能为空");
                    return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() + "交易类型不能为空");
                }
                if(!TradeTypeEnum.TRADE_WITHDRAW.equals(jsTradeListReq.getTradeType())){
                    log.error("交易类型暂不支持");
                    return ResultUtil.error(ResultEnum.ERROR);
                }
                jsTradeListReq.setFileType(FileType.FILE_EXCEL);
                jsTradeListReq.setLanguageType(LanguageType.LANGUAGE_CHINESE);
                jsTradeListReq.setStorePlateform(StorePlateformEnum.AMAZON);
                fileName = "提现记录";
                fileExt = "xls";
            }else if(GenerateFileType.GENERATE_TRADE_RECEIPT.equals(jsTradeListReq.getGenerateFileType())){
                log.info("下载回执单");
                if(null == jsTradeListReq.getTradeType()){
                    log.error("交易类型不能为空");
                    return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() + "交易类型不能为空");
                }
                if(null == jsTradeListReq.getLanguageType()){
                    log.error("下载文件语言类型不能为空");
                    return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() + "语言类型不能为空");
                }
                jsTradeListReq.setStorePlateform(StorePlateformEnum.AMAZON);
                jsTradeListReq.setFileType(FileType.FILE_PDF);
                fileName = "提现回执单";
                fileExt = "pdf";
            }else if(GenerateFileType.GENERATE_FUND_RECORD.equals(jsTradeListReq.getGenerateFileType())){
                log.info("下载资金明细");
                if(null == jsTradeListReq.getFileType()){
                    log.error("生成文件不能为空");
                    return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() + "-下载格式不能为空");
                }
                if(!FileType.FILE_EXCEL.equals(jsTradeListReq.getFileType()) && !FileType.FILE_PDF.equals(jsTradeListReq.getFileType())){
                    log.error("文件下载类型暂不支持");
                    return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() + "文件下载类型暂不支持");
                }
                if(StringUtils.isNotBlank(jsTradeListReq.getKycStoreId()) && StringUtils.isBlank(jsTradeListReq.getAcctNo())){
                    log.error("选择账号时，账号需要传");
                    return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() + "账号不能为空");
                }
                jsTradeListReq.setStorePlateformName(null == jsTradeListReq.getStorePlateform() ? "全部" : jsTradeListReq.getStorePlateform().getDesc());
                jsTradeListReq.setLanguageType(LanguageType.LANGUAGE_CHINESE);

                fileName = "资金明细";
                fileExt = FileType.FILE_EXCEL.equals(jsTradeListReq.getFileType()) ? "xls" : "pdf";
            }else{
                log.error("下载类型暂不支持");
                return ResultUtil.error(ResultEnum.ERROR);
            }
            GenerateFileRecordReq generateFileRecordReq = convertToGenerateFileRecordReq(jsTradeListReq);
            generateFileRecordReq.setFileShowName(fileName + fileNameAfter + "." + fileExt);
            ResponseMessage generateFileRecordAdd = apiGenerateFileRecordService.generateFileRecordAdd(generateFileRecordReq, kycNaturalVO);
            if(!generateFileRecordAdd.isSuccess()){
                log.error("存储下载记录");
                return ResultUtil.error(ResultEnum.FILE_GENERATE_ERROR);
            }
            return generateFileRecordAdd;
        }catch (Exception ex){
            log.error("生成文件失败", ex);
            return ResultUtil.error(ResultEnum.FILE_GENERATE_ERROR);
        }
    }

    private GenerateFileRecordReq convertToGenerateFileRecordReq(JsTradeListReq jsTradeListReq){
        GenerateFileRecordReq generateFileRecordReq = new GenerateFileRecordReq();
        generateFileRecordReq.setGenerateType(jsTradeListReq.getGenerateFileType());
        generateFileRecordReq.setGenerateStartDate(jsTradeListReq.getTradeStartDate());
        generateFileRecordReq.setGenerateEndDate(jsTradeListReq.getTradeEndDate());
        generateFileRecordReq.setKycStoreId(jsTradeListReq.getKycStoreId());
        generateFileRecordReq.setStoreName(jsTradeListReq.getStoreName());
        generateFileRecordReq.setFileType(jsTradeListReq.getFileType());
        generateFileRecordReq.setLanguageType(jsTradeListReq.getLanguageType());
        generateFileRecordReq.setStorePlateform(jsTradeListReq.getStorePlateform());
        generateFileRecordReq.setTradeType(jsTradeListReq.getTradeType());
        generateFileRecordReq.setAcctNo(jsTradeListReq.getAcctNo());
        generateFileRecordReq.setStorePlateformName(jsTradeListReq.getStorePlateformName());
        generateFileRecordReq.setProcessStatus(ProcessStatusEnum.TRADE_UNPROCESSED);
        return generateFileRecordReq;
    }

    @Override
    public ResponseMessage downloadGenerateRecord(GenerateFileRecordReq generateFileRecordReq, HttpServletResponse response, KycNaturalVO kycNaturalVO) {
        log.info("生成文件操作开始：{}",generateFileRecordReq);
        if(GenerateFileType.GENERATE_TRADE_WITHDRAW_RECORD.equals(generateFileRecordReq.getGenerateType())){
            GenerateFileRecordVO generateFileRecordVO = new GenerateFileRecordVO();
            generateFileRecordVO.setBatchNo(generateFileRecordReq.getId());
            generateFileRecordVO.setLanguageType(LanguageType.LANGUAGE_CHINESE);
            return downloadGenerateTradeReceiptRecord(generateFileRecordVO,kycNaturalVO,response);
        }
        GenerateFileRecordVO generateFileRecordVO = apiGenerateFileRecordService.findGenerateFileRecordById(generateFileRecordReq);
        if(null == generateFileRecordVO){
            log.info("根据主键ID未查询到生成记录信息：{}",generateFileRecordReq.getId());
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        if(ProcessStatusEnum.TRADE_PROCESSED.equals(generateFileRecordVO.getProcessStatus()) && StringUtils.isNotBlank(generateFileRecordVO.getFileSavePath())){
            log.info("文件已存在，直接下载：{}",generateFileRecordVO.getFileSavePath());
            return downloadFile(generateFileRecordVO,response);
        }
        GenerateFileType generateFileType = generateFileRecordVO.getGenerateType();
        if(GenerateFileType.GENERATE_TRADE_RECORD.equals(generateFileType)){
            return downloadGenerateWithdrawTradeRecord(generateFileRecordVO,kycNaturalVO,response);
        }else if(GenerateFileType.GENERATE_TRADE_RECEIPT.equals(generateFileType)){
            if(TradeTypeEnum.TRADE_WITHDRAW.equals(generateFileRecordVO.getTradeType())){
                return downloadGenerateTradeReceiptRecord(generateFileRecordVO,kycNaturalVO,response);
            }else{
                log.info("交易类型暂不支持");
                return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
            }
        }else if(GenerateFileType.GENERATE_FUND_RECORD.equals(generateFileType)){
            if(FileType.FILE_EXCEL.equals(generateFileRecordVO.getFileType())){
                log.info("下载资金明细excel文件");
                return downloadGenerateFundRecordExcel(generateFileRecordVO,kycNaturalVO,response);
            }else if(FileType.FILE_PDF.equals(generateFileRecordVO.getFileType())){
                log.info("下载资金明细pdf文件");
                return downloadGenerateFundRecordPdf(generateFileRecordVO,kycNaturalVO,response);
            }else{
                log.info("下载文件类型不支持");
                return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
            }
        }else{
            return ResultUtil.error(ResultEnum.ERROR.getCode(),ResultEnum.ERROR.getMsg() + "下载类型暂不支持");
        }
    }

    //下载资金明细pdf-GENERATE_FUND_RECORD
    private ResponseMessage downloadGenerateFundRecordPdf(GenerateFileRecordVO generateFileRecordVO,KycNaturalVO kycNaturalVO,HttpServletResponse response){
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream swapStream = null;
        OutputStream outputStream = null;
        Document document = new Document();
        PdfWriter writer = null;
        try {
            JsTradeFundReq jsTradeFundReq = convertToJsTradeFundReq(generateFileRecordVO);
            log.info("查询资金明细开始：{}", jsTradeFundReq);
            List<JsTradeFundVO> jsTradeFundVOS = apiJsPaySunrateTradeLockPriceService.fundDetailListNoPage(jsTradeFundReq, kycNaturalVO);
            log.info("查询资金明细结束");
            if (CollectionUtils.isEmpty(jsTradeFundVOS)) {
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR);
            }
            document.setPageSize(PageSize.A4);
            writer = PdfWriter.getInstance(document, baos);
            document.open();

            BaseFont bf = BaseFont.createFont("STSong-Light","UniGB-UCS2-H",BaseFont.NOT_EMBEDDED);

            // 小三号
            Font smallThreeFont = new Font(bf, 15);
            smallThreeFont.setColor(BaseColor.BLACK);

            // 五号
            Font fiveFont = new Font(bf);
            fiveFont.setColor(BaseColor.BLACK);
            fiveFont.setSize(10.5f);

            // 小五号
            Font smallFiveFont = new Font(bf);
            smallFiveFont.setColor(BaseColor.BLACK);
            smallFiveFont.setSize(9);

            // 五号
            Font smallSixFont = new Font(bf);
            smallSixFont.setColor(BaseColor.BLACK);
            smallSixFont.setSize(6.5f);

            // 标题加粗
            Font titleFont = new Font(bf, 7, Font.BOLD);
            titleFont.setColor(BaseColor.BLACK);

            // 表1.
            PdfPTable table1 = new PdfPTable(4);
            table1.setWidthPercentage(100); // 宽度100%填充
            table1.setSpacingBefore(10f); // 前间距
            table1.setSpacingAfter(10f); // 后间距
            // 设置列宽
            float[] columnWidths1 = { 0.8f, 0.8f, 0.5f,0.5f};
            table1.setWidths(columnWidths1);
            PdfPCell cell1;
            //第一行
            cell1 = new PdfPCell(new Phrase("", smallThreeFont));
            Image image = Image.getInstance(templateFilePath + "/jishihyupaylogo.jpg");
            cell1.setImage(image);
            cell1.setBorder(0);
            table1.addCell(cell1);

            cell1 = new PdfPCell(new Phrase("", smallThreeFont));
            cell1.setBorder(0);
            cell1.setColspan(3);
            table1.addCell(cell1);

            //第二行
            cell1 = new PdfPCell(new Phrase("及时雨Pay 跨境支付交易记录明细查询", smallThreeFont));
            cell1.setMinimumHeight(25); // 设置单元格高度
            cell1.setUseAscender(true); // 设置可以居中
            cell1.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
            cell1.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
            cell1.setBorderWidthTop(0);
            cell1.setBorderWidthLeft(0);
            cell1.setBorderWidthRight(0);
            cell1.setBorderWidthBottom(1.5f);
            cell1.setBorderColorBottom(BaseColor.GRAY);
            cell1.setColspan(4);
            table1.addCell(cell1);

            document.add(table1);

            //表2
            PdfPTable table2 = new PdfPTable(2);
            table2.setWidthPercentage(100); // 宽度100%填充
            table2.setSpacingBefore(10f); // 前间距
            table2.setSpacingAfter(10f); // 后间距
            // 设置列宽
            float[] columnWidths2 = { 0.8f, 0.8f};
            table2.setWidths(columnWidths2);
            PdfPCell cell2;

            //第一行
            cell2 = new PdfPCell(new Phrase("账号：" + kycNaturalVO.getPhoneNo(), fiveFont));
            cell2.setMinimumHeight(15); // 设置单元格高度
            cell2.setUseAscender(true); // 设置可以居中
            cell2.setHorizontalAlignment(PdfPCell.ALIGN_LEFT); // 设置水平居中
            cell2.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
            cell2.setBorder(0);
            cell2.setColspan(2);
            table2.addCell(cell2);

            //第二行
            cell2 = new PdfPCell(new Phrase("起始日期："  + DateUtil.format(generateFileRecordVO.getGenerateStartDate(),"yyyy-MM-dd"), fiveFont));
            cell2.setMinimumHeight(15); // 设置单元格高度
            cell2.setUseAscender(true); // 设置可以居中
            cell2.setHorizontalAlignment(PdfPCell.ALIGN_LEFT); // 设置水平居中
            cell2.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
            cell2.setBorder(0);
            table2.addCell(cell2);

            cell2 = new PdfPCell(new Phrase("截止日期："  + DateUtil.format(generateFileRecordVO.getGenerateEndDate(),"yyyy-MM-dd"), fiveFont));
            cell2.setMinimumHeight(15); // 设置单元格高度
            cell2.setUseAscender(true); // 设置可以居中
            cell2.setHorizontalAlignment(PdfPCell.ALIGN_LEFT); // 设置水平居中
            cell2.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
            cell2.setBorder(0);
            table2.addCell(cell2);

            document.add(table2);

            //表3
            PdfPTable table3 = new PdfPTable(12);
            table3.setWidthPercentage(100); // 宽度100%填充
            table3.setSpacingBefore(10f); // 前间距
            table3.setSpacingAfter(10f); // 后间距
            PdfPCell cell3;

            //第一行-表头
            cell3 = new PdfPCell(new Phrase("交易单号", titleFont));
            cell3.setMinimumHeight(20); // 设置单元格高度
            cell3.setUseAscender(true); // 设置可以居中
            cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
            cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
            cell3.setBorder(0);
            cell3.setBackgroundColor(BaseColor.GRAY);
            table3.addCell(cell3);

            cell3 = new PdfPCell(new Phrase("批次单号", titleFont));
            cell3.setMinimumHeight(20); // 设置单元格高度
            cell3.setUseAscender(true); // 设置可以居中
            cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
            cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
            cell3.setBorder(0);
            cell3.setBackgroundColor(BaseColor.GRAY);
            table3.addCell(cell3);

            cell3 = new PdfPCell(new Phrase("创建时间", titleFont));
            cell3.setMinimumHeight(20); // 设置单元格高度
            cell3.setUseAscender(true); // 设置可以居中
            cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
            cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
            cell3.setBorder(0);
            cell3.setBackgroundColor(BaseColor.GRAY);
            table3.addCell(cell3);

            cell3 = new PdfPCell(new Phrase("类型", titleFont));
            cell3.setMinimumHeight(20); // 设置单元格高度
            cell3.setUseAscender(true); // 设置可以居中
            cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
            cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
            cell3.setBorder(0);
            cell3.setBackgroundColor(BaseColor.GRAY);
            table3.addCell(cell3);

            cell3 = new PdfPCell(new Phrase("收款人名称", titleFont));
            cell3.setMinimumHeight(20); // 设置单元格高度
            cell3.setUseAscender(true); // 设置可以居中
            cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
            cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
            cell3.setBorder(0);
            cell3.setBackgroundColor(BaseColor.GRAY);
            table3.addCell(cell3);

            cell3 = new PdfPCell(new Phrase("交易金额", titleFont));
            cell3.setMinimumHeight(20); // 设置单元格高度
            cell3.setUseAscender(true); // 设置可以居中
            cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
            cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
            cell3.setBorder(0);
            cell3.setBackgroundColor(BaseColor.GRAY);
            table3.addCell(cell3);

            cell3 = new PdfPCell(new Phrase("状态", titleFont));
            cell3.setMinimumHeight(20); // 设置单元格高度
            cell3.setUseAscender(true); // 设置可以居中
            cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
            cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
            cell3.setBorder(0);
            cell3.setBackgroundColor(BaseColor.GRAY);
            table3.addCell(cell3);

            cell3 = new PdfPCell(new Phrase("电商平台", titleFont));
            cell3.setMinimumHeight(20); // 设置单元格高度
            cell3.setUseAscender(true); // 设置可以居中
            cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
            cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
            cell3.setBorder(0);
            cell3.setBackgroundColor(BaseColor.GRAY);
            table3.addCell(cell3);

            cell3 = new PdfPCell(new Phrase("店铺名称", titleFont));
            cell3.setMinimumHeight(20); // 设置单元格高度
            cell3.setUseAscender(true); // 设置可以居中
            cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
            cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
            cell3.setBorder(0);
            cell3.setBackgroundColor(BaseColor.GRAY);
            table3.addCell(cell3);

            cell3 = new PdfPCell(new Phrase("汇率", titleFont));
            cell3.setMinimumHeight(20); // 设置单元格高度
            cell3.setUseAscender(true); // 设置可以居中
            cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
            cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
            cell3.setBorder(0);
            cell3.setBackgroundColor(BaseColor.GRAY);
            table3.addCell(cell3);

            cell3 = new PdfPCell(new Phrase("手续费金额", titleFont));
            cell3.setMinimumHeight(20); // 设置单元格高度
            cell3.setUseAscender(true); // 设置可以居中
            cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
            cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
            cell3.setBorder(0);
            cell3.setBackgroundColor(BaseColor.GRAY);
            table3.addCell(cell3);

            cell3 = new PdfPCell(new Phrase("账户余额", titleFont));
            cell3.setMinimumHeight(20); // 设置单元格高度
            cell3.setUseAscender(true); // 设置可以居中
            cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
            cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
            cell3.setBorder(0);
            cell3.setBackgroundColor(BaseColor.GRAY);
            table3.addCell(cell3);

            for(int i = 0; i < jsTradeFundVOS.size() ; i ++){
                JsTradeFundVO jsTradeFundVO = jsTradeFundVOS.get(i);
                cell3 = new PdfPCell(new Phrase(jsTradeFundVO.getTradeNo(), smallSixFont));
                cell3.setMinimumHeight(20); // 设置单元格高度
                cell3.setUseAscender(true); // 设置可以居中
                cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
                cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
                cell3.setBorderWidthTop(0);
                cell3.setBorderWidthLeft(0);
                cell3.setBorderWidthRight(0);
                table3.addCell(cell3);

                cell3 = new PdfPCell(new Phrase(jsTradeFundVO.getBatchNo(), smallSixFont));
                cell3.setMinimumHeight(20); // 设置单元格高度
                cell3.setUseAscender(true); // 设置可以居中
                cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
                cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
                cell3.setBorderWidthTop(0);
                cell3.setBorderWidthLeft(0);
                cell3.setBorderWidthRight(0);
                table3.addCell(cell3);

                cell3 = new PdfPCell(new Phrase(DateUtil.format(jsTradeFundVO.getTradeDate(),"yyyy-MM-dd HH:mm:ss"), smallSixFont));
                cell3.setMinimumHeight(20); // 设置单元格高度
                cell3.setUseAscender(true); // 设置可以居中
                cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
                cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
                cell3.setBorderWidthTop(0);
                cell3.setBorderWidthLeft(0);
                cell3.setBorderWidthRight(0);
                table3.addCell(cell3);

                cell3 = new PdfPCell(new Phrase(jsTradeFundVO.getTradeSubType().getDesc(), smallSixFont));
                cell3.setMinimumHeight(20); // 设置单元格高度
                cell3.setUseAscender(true); // 设置可以居中
                cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
                cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
                cell3.setBorderWidthTop(0);
                cell3.setBorderWidthLeft(0);
                cell3.setBorderWidthRight(0);
                table3.addCell(cell3);

                cell3 = new PdfPCell(new Phrase(jsTradeFundVO.getReceiverAcctName(), smallSixFont));
                cell3.setMinimumHeight(20); // 设置单元格高度
                cell3.setUseAscender(true); // 设置可以居中
                cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
                cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
                cell3.setBorderWidthTop(0);
                cell3.setBorderWidthLeft(0);
                cell3.setBorderWidthRight(0);
                table3.addCell(cell3);

                cell3 = new PdfPCell(new Phrase(jsTradeFundVO.getTradeAmt().toString(), smallSixFont));
                cell3.setMinimumHeight(20); // 设置单元格高度
                cell3.setUseAscender(true); // 设置可以居中
                cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
                cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
                cell3.setBorderWidthTop(0);
                cell3.setBorderWidthLeft(0);
                cell3.setBorderWidthRight(0);
                table3.addCell(cell3);

                cell3 = new PdfPCell(new Phrase(jsTradeFundVO.getProcessStatusDesc(), smallSixFont));
                cell3.setMinimumHeight(20); // 设置单元格高度
                cell3.setUseAscender(true); // 设置可以居中
                cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
                cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
                cell3.setBorderWidthTop(0);
                cell3.setBorderWidthLeft(0);
                cell3.setBorderWidthRight(0);
                table3.addCell(cell3);

                cell3 = new PdfPCell(new Phrase(jsTradeFundVO.getStorePlateform().getDesc() + jsTradeFundVO.getStoreTheSite().getSiteName(), smallSixFont));
                cell3.setMinimumHeight(20); // 设置单元格高度
                cell3.setUseAscender(true); // 设置可以居中
                cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
                cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
                cell3.setBorderWidthTop(0);
                cell3.setBorderWidthLeft(0);
                cell3.setBorderWidthRight(0);
                table3.addCell(cell3);

                cell3 = new PdfPCell(new Phrase(jsTradeFundVO.getStoreName(), smallSixFont));
                cell3.setMinimumHeight(20); // 设置单元格高度
                cell3.setUseAscender(true); // 设置可以居中
                cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
                cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
                cell3.setBorderWidthTop(0);
                cell3.setBorderWidthLeft(0);
                cell3.setBorderWidthRight(0);
                table3.addCell(cell3);

                cell3 = new PdfPCell(new Phrase(null != jsTradeFundVO.getUseRate() && jsTradeFundVO.getUseRate().compareTo(new BigDecimal(0)) > 0 ? jsTradeFundVO.getUseRate().toString() : "", smallSixFont));
                cell3.setMinimumHeight(20); // 设置单元格高度
                cell3.setUseAscender(true); // 设置可以居中
                cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
                cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
                cell3.setBorderWidthTop(0);
                cell3.setBorderWidthLeft(0);
                cell3.setBorderWidthRight(0);
                table3.addCell(cell3);

                cell3 = new PdfPCell(new Phrase(null != jsTradeFundVO.getChargeAmt() && jsTradeFundVO.getChargeAmt().compareTo(new BigDecimal(0)) > 0 ? jsTradeFundVO.getChargeAmt().toString() : "", smallSixFont));
                cell3.setMinimumHeight(20); // 设置单元格高度
                cell3.setUseAscender(true); // 设置可以居中
                cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
                cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
                cell3.setBorderWidthTop(0);
                cell3.setBorderWidthLeft(0);
                cell3.setBorderWidthRight(0);
                table3.addCell(cell3);

                cell3 = new PdfPCell(new Phrase(jsTradeFundVO.getAvailableBalance().toString(), smallSixFont));
                cell3.setMinimumHeight(20); // 设置单元格高度
                cell3.setUseAscender(true); // 设置可以居中
                cell3.setHorizontalAlignment(PdfPCell.ALIGN_CENTER); // 设置水平居中
                cell3.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE); // 设置垂直居中
                cell3.setBorderWidthTop(0);
                cell3.setBorderWidthLeft(0);
                cell3.setBorderWidthRight(0);
                table3.addCell(cell3);
            }

            document.add(table3);
            document.close();
            writer.close();

            swapStream = new ByteArrayInputStream(baos.toByteArray());
            //获取文件扩展名
            String fileExt = "pdf";
            String fileName = generateFileRecordVO.getFileShowName();
            ResponseMessage responseMessage = jsFileSerivce.uploadFile(swapStream, FileType.DOCUMENT, FileResourceType.TRADE_REPORT, fileName,fileExt);
            if (!responseMessage.isSuccess()) {
                log.error("上传文件返回不成功");
                return ResultUtil.success(ResultEnum.FILE_GENERATE_ERROR);
            }
            FileVo fileVo = (FileVo) responseMessage.getData();
            ResponseMessage generateFileRecordUpdate = apiGenerateFileRecordService.generateFileRecordUpdate(fileVo, generateFileRecordVO, kycNaturalVO);
            if (!generateFileRecordUpdate.isSuccess()) {
                log.error("更新存储下载记录");
                return ResultUtil.success(ResultEnum.FILE_GENERATE_ERROR);
            }
            log.info("文件生成完成");
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + java.net.URLEncoder.encode(fileName + "." + fileExt, "UTF-8"));
//            response.setHeader("Content-Disposition", "attachment;filename=" + java.net.URLEncoder.encode("测试.pdf", "UTF-8"));
            outputStream = response.getOutputStream();
            outputStream.write(baos.toByteArray());
        }catch (Exception ex){
            log.error("文件生成异常",ex);
            return ResultUtil.success(ResultEnum.FILE_GENERATE_ERROR);
        }finally {
            // 关闭writer，释放内存
            if(null != document){
                document.close();
            }
            if(null != writer){
                writer.close();
            }
            //此处记得关闭输出Servlet流
            IoUtil.close(outputStream);
            IoUtil.close(swapStream);
            IoUtil.close(baos);
        }
        return ResultUtil.success(ResultEnum.FILE_DOWNLOAD_SUCCESS);
    }

    //下载资金明细excel-GENERATE_FUND_RECORD
    private ResponseMessage downloadGenerateFundRecordExcel(GenerateFileRecordVO generateFileRecordVO,KycNaturalVO kycNaturalVO,HttpServletResponse response){
        ExcelWriter excelWriter = ExcelUtil.getWriter();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream swapStream = null;
        ServletOutputStream servletOutputStream = null;
        try {
            JsTradeFundReq jsTradeFundReq = convertToJsTradeFundReq(generateFileRecordVO);
            log.info("查询资金明细开始：{}", jsTradeFundReq);
            List<JsTradeFundVO> jsTradeFundVOS = apiJsPaySunrateTradeLockPriceService.fundDetailListNoPage(jsTradeFundReq, kycNaturalVO);
            log.info("查询资金明细结束");
            if (CollectionUtils.isEmpty(jsTradeFundVOS)) {
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR);
            }
            ArrayList<Map<String, Object>> rows = CollUtil.newArrayList();
            jsTradeFundVOS.stream().forEach(jsTradeFundVO -> {
                Map<String, Object> row = new LinkedHashMap<>();
                row.put("tradeNo", jsTradeFundVO.getTradeNo());
                row.put("batchNo", jsTradeFundVO.getBatchNo());
                row.put("createDts", jsTradeFundVO.getTradeDate());
                row.put("tradeType", jsTradeFundVO.getTradeSubType().getDesc());
                row.put("receiverAcctName", jsTradeFundVO.getReceiverAcctName());
                row.put("receiverAcctNo", jsTradeFundVO.getReceiverAcctNo());
                row.put("currency", jsTradeFundVO.getCurrencyDesc());
                row.put("tradeAmt", jsTradeFundVO.getTradeAmt());
                row.put("processStatusDesc", jsTradeFundVO.getProcessStatusDesc());
                row.put("storePlateformName", jsTradeFundVO.getStorePlateform().getDesc() + jsTradeFundVO.getStoreTheSite().getSiteName());
                row.put("sunrateBankNo", jsTradeFundVO.getSunrateBankCardNo());
                row.put("storeName", jsTradeFundVO.getStoreName());
                row.put("useRate", null != jsTradeFundVO.getUseRate() && jsTradeFundVO.getUseRate().compareTo(new BigDecimal(0)) > 0 ? jsTradeFundVO.getUseRate() : "");
                row.put("feeCurrency", jsTradeFundVO.getCurrencyDesc());
                row.put("chargeAmt", null != jsTradeFundVO.getChargeAmt() && jsTradeFundVO.getChargeAmt().compareTo(new BigDecimal(0)) > 0 ? jsTradeFundVO.getChargeAmt() : "");
                row.put("acctBalance", jsTradeFundVO.getAvailableBalance());
                rows.add(row);
            });
            //自定义标题别名
            excelWriter.addHeaderAlias("tradeNo", "交易单号");
            excelWriter.addHeaderAlias("batchNo", "批次单号");
            excelWriter.addHeaderAlias("createDts", "创建日期");
            excelWriter.addHeaderAlias("tradeType", "类型");
            excelWriter.addHeaderAlias("receiverAcctName", "收款人名称");
            excelWriter.addHeaderAlias("receiverAcctNo", "收款人银行卡号");
            excelWriter.addHeaderAlias("currency", "币种");
            excelWriter.addHeaderAlias("tradeAmt", "交易金额");
            excelWriter.addHeaderAlias("processStatusDesc", "状态");
            excelWriter.addHeaderAlias("storePlateformName", "电商平台");
            excelWriter.addHeaderAlias("sunrateBankNo", "收款账号");
            excelWriter.addHeaderAlias("storeName", "店铺名称");
            excelWriter.addHeaderAlias("useRate", "汇率");
            excelWriter.addHeaderAlias("feeCurrency", "手续费币种");
            excelWriter.addHeaderAlias("chargeAmt", "手续费金额");
            excelWriter.addHeaderAlias("acctBalance", "账户余额");

            excelWriter.setColumnWidth(0, 25);
            excelWriter.setColumnWidth(1, 20);
            excelWriter.setColumnWidth(2, 17);


            // 合并单元格后的标题行，使用默认标题样式
            excelWriter.merge(15, "JS跨境支付交易记录明细查询");
            excelWriter.merge(15, "账号：【" + kycNaturalVO.getPhoneNo() + "】");
            excelWriter.merge(15, "起始日期：[" + DateUtil.format(generateFileRecordVO.getGenerateStartDate(), "yyyy-MM-dd") + "]  终止日期：[" + DateUtil.format(generateFileRecordVO.getGenerateEndDate(), "yyyy-MM-dd") + "]");
            // 一次性写出内容，使用默认样式，强制输出标题
            excelWriter.write(rows, true);
            excelWriter.flush(baos, true);

            swapStream = new ByteArrayInputStream(baos.toByteArray());
            //获取文件扩展名
            String fileExt = "xls";
            String fileName = generateFileRecordVO.getFileShowName();
            ResponseMessage responseMessage = jsFileSerivce.uploadFile(swapStream, FileType.DOCUMENT, FileResourceType.TRADE_REPORT,fileName ,fileExt);
            if (!responseMessage.isSuccess()) {
                log.error("上传文件返回不成功");
                return ResultUtil.success(ResultEnum.FILE_GENERATE_ERROR);
            }
            FileVo fileVo = (FileVo) responseMessage.getData();
            ResponseMessage generateFileRecordUpdate = apiGenerateFileRecordService.generateFileRecordUpdate(fileVo, generateFileRecordVO, kycNaturalVO);
            if (!generateFileRecordUpdate.isSuccess()) {
                log.error("更新存储下载记录");
                return ResultUtil.success(ResultEnum.FILE_GENERATE_ERROR);
            }
            log.info("文件生成完成");

            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + java.net.URLEncoder.encode(fileName + "." + fileVo.getFileExt(), "UTF-8"));
//            response.setHeader("Content-Disposition", "attachment;filename=" + java.net.URLEncoder.encode("测试.xls", "UTF-8"));
            servletOutputStream = response.getOutputStream();
            excelWriter.flush(servletOutputStream, true);
            servletOutputStream.flush();
        }catch (Exception ex){
            log.error("文件生成异常",ex);
            return ResultUtil.success(ResultEnum.FILE_GENERATE_ERROR);
        }finally {
            // 关闭writer，释放内存
            if(null != excelWriter){
                excelWriter.close();
            }
            //此处记得关闭输出Servlet流
            IoUtil.close(servletOutputStream);
            IoUtil.close(swapStream);
            IoUtil.close(baos);
        }
        return ResultUtil.success(ResultEnum.FILE_DOWNLOAD_SUCCESS);
    }

    //下载回执单
    private ResponseMessage downloadGenerateTradeReceiptRecord(GenerateFileRecordVO generateFileRecordVO,KycNaturalVO kycNaturalVO,HttpServletResponse response){
        LanguageType languageType = generateFileRecordVO.getLanguageType();
        String readFileName = LanguageType.LANGUAGE_CHINESE.equals(languageType) ? "/tradedetailchinese.pdf" : "/tradedetailenglish.pdf";
        String tradeTypeDesc = LanguageType.LANGUAGE_CHINESE.equals(languageType) ? "提现" : "Withdrawal";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream swapStream = null;
        ByteArrayInputStream readerArrayInputStream = null;
        OutputStream outputStream = null;
        ByteArrayOutputStream bos = null;
        Document document = new Document();
        PdfCopy copy = null;
        try {
            JsTradeListReq jsTradeListReq = convertToJsTradeListReq(generateFileRecordVO);
            ResponseMessage generateWithdrawList = apiJsPaySunrateTradeLockPriceService.generateWithdrawList(jsTradeListReq, kycNaturalVO);
            if (!generateWithdrawList.isSuccess()) {
                return generateWithdrawList;
            }
            List<JsTradeListVO> jsTradeListVOList = (List<JsTradeListVO>) generateWithdrawList.getData();
            List<JsTradeListVO> successList = jsTradeListVOList.stream().filter(jsTradeListVO -> ProcessStatusEnum.TRADE_PROCESSED.equals(jsTradeListVO.getProcessStatus())).collect(Collectors.toList());
            if(CollectionUtils.isEmpty(successList)){
                return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
            }
            log.info("查询导出数据：{}条，生成表ID：{}",successList.size(),generateFileRecordVO.getId());
            copy = new PdfCopy(document, baos);
            document.open();
            for(int i = 0 ; i < successList.size() ; i++){
                JsTradeListVO jsTradeListVO = successList.get(i);
                PdfReader reader = new PdfReader(templateFilePath + readFileName);
                bos = new ByteArrayOutputStream();
                PdfStamper ps = new PdfStamper(reader, bos);
                BaseFont baseFont = BaseFont.createFont("STSong-Light","UniGB-UCS2-H",BaseFont.NOT_EMBEDDED);
                ArrayList<BaseFont> fontList = new ArrayList<BaseFont>();
                fontList.add(baseFont);
                AcroFields s = ps.getAcroFields();
                s.setSubstitutionFonts(fontList);

                s.setField("batchNo",jsTradeListVO.getBatchNo());
                s.setField("tradeTime",DateUtil.format(jsTradeListVO.getTradeDate(),"yyyy-MM-dd HH:ss:mm"));
                s.setField("tradeType",tradeTypeDesc);
                s.setField("tradeNo",jsTradeListVO.getTxnNo());
                s.setField("paymentNo",jsTradeListVO.getSunrateBankCardNo());
                s.setField("paymentName",jsTradeListVO.getSunrateBankCusName());
                s.setField("collectionName",jsTradeListVO.getAccountName());
                s.setField("collectionNo",jsTradeListVO.getBankCardNo());
                s.setField("collectionOpenBank",jsTradeListVO.getBankName());
                s.setField("withdrawAmt",jsTradeListVO.getAmt().toString());
                s.setField("useRate",jsTradeListVO.getUseRate().toString());
                s.setField("accountReceiveFee",null == jsTradeListVO.getAccountsReceivableFee() ? "0" : jsTradeListVO.getAccountsReceivableFee().toString());
                s.setField("withdrawFee",null == jsTradeListVO.getWithdrawFee() ? "0" : jsTradeListVO.getWithdrawFee().toString());

                ps.setFormFlattening(true);
                ps.close();

                swapStream = new ByteArrayInputStream(bos.toByteArray());
                PdfReader readerAdd = new PdfReader(swapStream);
                PdfImportedPage page = copy.getImportedPage(readerAdd, 1);
                copy.addPage(page);
            }
            document.close();
            copy.close();
            readerArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
//            获取文件扩展名
            String fileName = generateFileRecordVO.getFileShowName();
            String fileExt = "pdf";
            ResponseMessage responseMessage = jsFileSerivce.uploadFile(readerArrayInputStream, FileType.DOCUMENT, FileResourceType.TRADE_REPORT,fileName ,fileExt);
            if (!responseMessage.isSuccess()) {
                log.error("上传文件返回不成功");
                return ResultUtil.success(ResultEnum.FILE_GENERATE_ERROR);
            }
            FileVo fileVo = (FileVo) responseMessage.getData();
            ResponseMessage generateFileRecordUpdate = apiGenerateFileRecordService.generateFileRecordUpdate(fileVo, generateFileRecordVO, kycNaturalVO);
            if (!generateFileRecordUpdate.isSuccess()) {
                log.error("更新存储下载记录");
                return ResultUtil.success(ResultEnum.FILE_GENERATE_ERROR);
            }
            log.info("文件生成完成");
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
//            response.setHeader("Content-Disposition", "attachment;filename=" + java.net.URLEncoder.encode("提现测试.pdf", "UTF-8"));
            response.setHeader("Content-Disposition", "attachment;filename=" + java.net.URLEncoder.encode(fileName + "." + fileExt, "UTF-8"));
            outputStream = response.getOutputStream();
            outputStream.write(baos.toByteArray());
        }catch (Exception ex){
            log.error("下载回执单异常", ex);
            return ResultUtil.success(ResultEnum.FILE_GENERATE_ERROR);
        }finally {
            if(null != document){
                document.close();
            }
            if(null != copy){
                copy.close();
            }
            IOUtils.closeQuietly(baos);
            IOUtils.closeQuietly(swapStream);
            IOUtils.closeQuietly(outputStream);
            IOUtils.closeQuietly(bos);
        }
        return ResultUtil.success(ResultEnum.FILE_DOWNLOAD_SUCCESS);
    }

    private ResponseMessage downloadFile(GenerateFileRecordVO generateFileRecordVO,HttpServletResponse response){
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try{
            inputStream =  jsFileSerivce.findFile(generateFileRecordVO.getFileSavePath());
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + java.net.URLEncoder.encode(generateFileRecordVO.getFileShowName(), "UTF-8"));
            outputStream = response.getOutputStream();
            IOUtils.copy(inputStream, outputStream);
            outputStream.flush();
        }catch (Exception ex){
            log.error("下载文件异常",ex);
        }finally {
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(outputStream);
        }
        return ResultUtil.success(ResultEnum.FILE_DOWNLOAD_SUCCESS.getCode(), ResultEnum.FILE_DOWNLOAD_SUCCESS.getMsg());
    }

    //下载交易记录
    private ResponseMessage downloadGenerateWithdrawTradeRecord(GenerateFileRecordVO generateFileRecordVO,KycNaturalVO kycNaturalVO,HttpServletResponse response){
        ExcelWriter excelWriter = ExcelUtil.getWriter();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream swapStream = null;
        ServletOutputStream servletOutputStream = null;
        try {
            JsTradeListReq jsTradeListReq = convertToJsTradeListReq(generateFileRecordVO);
            ResponseMessage generateWithdrawList = apiJsPaySunrateTradeLockPriceService.generateWithdrawList(jsTradeListReq, kycNaturalVO);
            if (!generateWithdrawList.isSuccess()) {
                return generateWithdrawList;
            }
            ArrayList<Map<String, Object>> rows = CollUtil.newArrayList();
            List<JsTradeListVO> jsTradeListVOList = (List<JsTradeListVO>) generateWithdrawList.getData();
            if(CollectionUtils.isEmpty(jsTradeListVOList)){
                log.info("下载文件,查询交易记录不存在");
                return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
            }
            jsTradeListVOList.stream().forEach(jsTradeListVO -> {
                Map<String, Object> row = new LinkedHashMap<>();
                row.put("batchNo", jsTradeListVO.getBatchNo());
                row.put("tradeDate", jsTradeListVO.getTradeDate());
                row.put("tradeType", "提现");
                row.put("receiver", jsTradeListVO.getAccountName());
                row.put("receiverAcctNo", jsTradeListVO.getBankCardNo());
                row.put("openBankCode", jsTradeListVO.getBankName());
                row.put("withdrawCur", jsTradeListVO.getCurrencyDesc());
                row.put("withdrawAmt", jsTradeListVO.getAmt());
                row.put("useRate", jsTradeListVO.getUseRate());
                row.put("fee", jsTradeListVO.getWithdrawFee());
                row.put("buyCur", jsTradeListVO.getBuyCurrencyDesc());
                row.put("buyAmt", jsTradeListVO.getActualAmt());
                row.put("processStatusDesc", jsTradeListVO.getProcessStatusDes());
                rows.add(row);
            });
            //自定义标题别名
            excelWriter.addHeaderAlias("batchNo", "批次单号");
            excelWriter.addHeaderAlias("tradeDate", "交易日期");
            excelWriter.addHeaderAlias("tradeType", "交易类型");
            excelWriter.addHeaderAlias("receiver", "收款人名称");
            excelWriter.addHeaderAlias("receiverAcctNo", "收款人账号");
            excelWriter.addHeaderAlias("openBankCode", "收款人开户行");
            excelWriter.addHeaderAlias("withdrawCur", "提现币种");
            excelWriter.addHeaderAlias("withdrawAmt", "提现金额");
            excelWriter.addHeaderAlias("useRate", "汇率");
            excelWriter.addHeaderAlias("fee", "实收手续费");
            excelWriter.addHeaderAlias("buyCur", "到账币种");
            excelWriter.addHeaderAlias("buyAmt", "到账金额");
            excelWriter.addHeaderAlias("processStatusDesc", "提现状态");

            excelWriter.setColumnWidth(0, 25);
            excelWriter.setColumnWidth(1, 20);


            // 合并单元格后的标题行，使用默认标题样式
            excelWriter.merge(12, "JS跨境支付提现记录查询");
            excelWriter.merge(12, "账号：【" + kycNaturalVO.getPhoneNo() + "】");
            excelWriter.merge(12, "起始日期：[" + DateUtil.format(jsTradeListReq.getTradeStartDate(), "yyyy-MM-dd") + "]  终止日期：[" + DateUtil.format(jsTradeListReq.getTradeEndDate(), "yyyy-MM-dd") + "]");
            // 一次性写出内容，使用默认样式，强制输出标题
            excelWriter.write(rows, true);
            excelWriter.flush(baos, true);

            swapStream = new ByteArrayInputStream(baos.toByteArray());
            //获取文件扩展名
            String fileExt = "xls";
            String fileName = generateFileRecordVO.getFileShowName();
            ResponseMessage responseMessage = jsFileSerivce.uploadFile(swapStream, FileType.DOCUMENT, FileResourceType.TRADE_REPORT, fileName,fileExt);
            if (!responseMessage.isSuccess()) {
                log.error("上传文件返回不成功");
                return ResultUtil.success(ResultEnum.FILE_GENERATE_ERROR);
            }
            FileVo fileVo = (FileVo) responseMessage.getData();
            ResponseMessage generateFileRecordUpdate = apiGenerateFileRecordService.generateFileRecordUpdate(fileVo, generateFileRecordVO, kycNaturalVO);
            if (!generateFileRecordUpdate.isSuccess()) {
                log.error("更新存储下载记录");
                return ResultUtil.success(ResultEnum.FILE_GENERATE_ERROR);
            }
            log.info("文件生成完成");

            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + java.net.URLEncoder.encode(fileName + "." + fileExt, "UTF-8"));
            servletOutputStream = response.getOutputStream();
            excelWriter.flush(servletOutputStream, true);
            servletOutputStream.flush();
        }catch (Exception ex){
            log.error("文件生成异常",ex);
            return ResultUtil.success(ResultEnum.FILE_GENERATE_ERROR);
        }finally {
            // 关闭writer，释放内存
            excelWriter.close();
            //此处记得关闭输出Servlet流
            IoUtil.close(servletOutputStream);
            IoUtil.close(swapStream);
            IoUtil.close(baos);
        }
        return ResultUtil.success(ResultEnum.FILE_DOWNLOAD_SUCCESS);
    }

    private JsTradeListReq convertToJsTradeListReq(GenerateFileRecordVO generateFileRecordVO){
        JsTradeListReq jsTradeListReq = new JsTradeListReq();
        jsTradeListReq.setTradeStartDate(generateFileRecordVO.getGenerateStartDate());
        jsTradeListReq.setTradeEndDate(generateFileRecordVO.getGenerateEndDate());
        jsTradeListReq.setTradeType(TradeTypeEnum.TRADE_WITHDRAW);
        jsTradeListReq.setTradeSubType(TradeSubTypeEnum.WITHDRAW);
        jsTradeListReq.setBatchNo(generateFileRecordVO.getBatchNo());
        return jsTradeListReq;
    }

    private JsTradeFundReq convertToJsTradeFundReq(GenerateFileRecordVO generateFileRecordVO){
        JsTradeFundReq jsTradeFundReq = new JsTradeFundReq();
        if(null != generateFileRecordVO.getGenerateStartDate()){
            jsTradeFundReq.setTradeStartDate(generateFileRecordVO.getGenerateStartDate());
        }
        if(null != generateFileRecordVO.getGenerateEndDate()){
            jsTradeFundReq.setTradeEndDate(generateFileRecordVO.getGenerateEndDate());
        }
        if(null != generateFileRecordVO.getStorePlateform()){
            jsTradeFundReq.setStorePlateform(generateFileRecordVO.getStorePlateform());
        }
        if(StringUtils.isNotBlank(generateFileRecordVO.getKycStoreId())){
            jsTradeFundReq.setKycStoreId(generateFileRecordVO.getKycStoreId());
        }
        return jsTradeFundReq;
    }
}
