package com.js.web.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiJsPaySunrateBankService;
import com.js.api.jspay.service.ApiKycBankService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.*;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycBankVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ReqNoUtil;
import com.js.common.util.ResultUtil;
import com.js.web.service.IMailService;
import com.js.web.service.JsKycNaturalService;
import com.js.web.service.JsKycSunrateBeneficiaryService;
import com.js.web.service.JsPaySunrateBankService;
import com.js.web.validate.code.ValidateCodeException;
import com.js.web.validate.code.ValidateCodeProcessorHolder;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;

/**
 * @Description: js_pay_sunrate_bank交互操作
 * @Author: liuh
 * @Create: 2019-06-27
 **/
@Slf4j
@Service
public class JsPaySunrateBankServiceImpl implements JsPaySunrateBankService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 30000
    )
    private ApiKycBankService apiKycBankService;
    @Autowired
    private ValidateCodeProcessorHolder validateCodeProcessorHolder;
    @Autowired
    JsKycSunrateBeneficiaryService jsKycSunrateBeneficiaryService;
    @Autowired
    JsKycNaturalService jsKycNaturalService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 30000
    )
    private ApiJsPaySunrateBankService apiJsPaySunrateBankService;
    @Autowired
    IMailService iMailService;

    @Override
    public ResponseMessage applyWithdraw(ApplyWithdrawTotalReq applyWithdrawTotalReq, KycNaturalVO kycNaturalVO, HttpServletResponse response) {
        log.info("提现入参：{}",applyWithdrawTotalReq);
        ResponseMessage bankCardResponse = apiKycBankService.getBankCard(applyWithdrawTotalReq.getBankId());
        log.info("根据提现入参查询银行卡信息：{}",JSON.toJSONString(bankCardResponse));
        if(!bankCardResponse.isSuccess()){
            return bankCardResponse;
        }
        KycBankVO kycBankVO = (KycBankVO)bankCardResponse.getData();
        if(null == kycBankVO || kycBankVO.getDelFlag()){
            log.error("根据提现入参查询银行卡信息不存在");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        if(!kycNaturalVO.getId().equals(kycBankVO.getKycNaturalId())){
            log.error("提现银行卡有误，非本人操作：{}",kycBankVO.getKycNaturalId());
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        if(!applyWithdrawTotalReq.getAccountNo().equals(kycBankVO.getAccountNo())
            || !kycNaturalVO.getPhoneNo().equals(applyWithdrawTotalReq.getPhone())){
            log.error("提现入参输入银行账号不正确或提现手机号不正确,卡号入参：{}，查询卡号：{}，手机号入参:{},查询手机号:{}",applyWithdrawTotalReq.getAccountNo(),kycBankVO.getAccountNo(),kycNaturalVO.getPhoneNo(),applyWithdrawTotalReq.getPhone());
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR);
        }
        BigDecimal countBigDecimal = new BigDecimal(0);
        List<ApplyWithdrawReq> withdrawStoreList = applyWithdrawTotalReq.getWithdrawStoreList();
        for(ApplyWithdrawReq applyWithdrawReq : withdrawStoreList){
            if(applyWithdrawReq.getWithdrawAmt().compareTo(CommonConstant.SURATE_TRADE_MIN_AMT) <0){
                log.error("店铺提现金额不能小于{}" , CommonConstant.SURATE_TRADE_MIN_AMT);
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() + "店铺提现金额不可小于" + CommonConstant.SURATE_TRADE_MIN_AMT);
            }
            if(applyWithdrawReq.getWithdrawAmt().compareTo(CommonConstant.SURATE_TRADE_MAX_AMT) > 0){
                log.error("店铺提现金额不能大于{}" , CommonConstant.SURATE_TRADE_MAX_AMT);
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),ResultEnum.NO_MUST_PARAM_ERROR.getMsg() + "店铺提现金额不可大于" + CommonConstant.SURATE_TRADE_MAX_AMT);
            }
            countBigDecimal = countBigDecimal.add(applyWithdrawReq.getWithdrawAmt());
        }
        log.info("提现总金额：{}，店铺加和：{}",applyWithdrawTotalReq.getWithdrawTotalAmt(),countBigDecimal);
        if(countBigDecimal.compareTo(applyWithdrawTotalReq.getWithdrawTotalAmt()) != 0){
            log.error("提现总金额与店铺提现金额加和不符合");
            return ResultUtil.error(ResultEnum.ERROR);
        }
        //校验验证码是否正确
        try {
            ValidateCodeReq validateCodeReq = regiserReqConvertToValidateCodeReq(applyWithdrawTotalReq);
            validateCodeProcessorHolder.findValidateCodeProcessor("sms").validate(validateCodeReq, response);
        } catch (ValidateCodeException exception) {
            return ResultUtil.error(ResultEnum.VALIDATE_CODE_ERROT.getCode(),exception.getMessage());
        } catch (Exception e) {
            return ResultUtil.error(ResultEnum.VALIDATE_CODE_ERROT.getCode(),ResultEnum.VALIDATE_CODE_ERROT.getMsg());
        }
        String batchNo = ReqNoUtil.getReqNo();
        ResponseMessage resultResponse = ResultUtil.success(ResultEnum.SUCCESS);
        for(ApplyWithdrawReq applyWithdrawReq : withdrawStoreList){
            log.info("提现操作-批次号：{},提现店铺ID：{}",batchNo,applyWithdrawReq.getStoreId());
            applyWithdrawReq.setBatchNo(batchNo);//统一批次号
            applyWithdrawReq.setCurrency(kycBankVO.getCurrencyCode());
            ResponseMessage responseMessage = apiJsPaySunrateBankService.applyWithdraw(applyWithdrawReq, kycNaturalVO,kycBankVO);
            log.info("单个店铺申请提现结果：{}",JSON.toJSONString(responseMessage));
            if(!responseMessage.isSuccess()){
                resultResponse = responseMessage;
            }
        }
        Date tradeDate = new Date();
        if(resultResponse.isSuccess()) {
            StringBuffer sb = new StringBuffer("<p style=\"margin: 0;line-height: 24px;font-size: 14px;\">您的账户于" + DateUtil.format(tradeDate, "yyyy年MM月dd日HH:mm") + "提现{" + applyWithdrawTotalReq.getStoreTheSite().getHyDesc() + "}" + applyWithdrawTotalReq.getWithdrawTotalAmt() + ",预计到账时间在1~2个工作日内，请留意银行信息。</p >");
            boolean sendResult = iMailService.sendTemplateHtmlMail(kycNaturalVO.getEmail(), "提现成功提醒", sb.toString(), kycNaturalVO.getPhoneNo());
            log.info("发送邮件结果：{}", sendResult);
            iMailService.sendRemindEmail("用户提现操作成功提醒", "用户：" + kycNaturalVO.getPhoneNo() + "于" + DateUtil.format(tradeDate, "yyyy年MM月dd日HH:mm") + "提现{" + applyWithdrawTotalReq.getStoreTheSite().getHyDesc() + "}" + applyWithdrawTotalReq.getWithdrawTotalAmt(), EmailRemindTypeEnum.REMIND_EMAIL);
        }else{
            iMailService.sendRemindEmail("用户提现操作失败提醒", "用户：" + kycNaturalVO.getPhoneNo() + "于" + DateUtil.format(tradeDate, "yyyy年MM月dd日HH:mm") + "提现{" + applyWithdrawTotalReq.getStoreTheSite().getHyDesc() + "}" + applyWithdrawTotalReq.getWithdrawTotalAmt() + ",提现操作失败;" + resultResponse , EmailRemindTypeEnum.REMIND_EMAIL);
        }
        return resultResponse;
    }

    private ValidateCodeReq regiserReqConvertToValidateCodeReq(ApplyWithdrawTotalReq applyWithdrawTotalReq){
        ValidateCodeReq validateCodeReq = new ValidateCodeReq();
        validateCodeReq.setMarkStr(applyWithdrawTotalReq.getMarkStr());
        validateCodeReq.setPhoneNo(applyWithdrawTotalReq.getPhone());
        validateCodeReq.setSmsCode(applyWithdrawTotalReq.getSmsCode());
        return validateCodeReq;
    }
}
