package com.js.web.service.impl;

import com.js.common.enums.EmailRemindTypeEnum;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.IMailService;
import com.js.web.service.JsKycDictionaryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;

/**
 * @ClassName: IMailServiceImpl
 * @Description: 邮箱服务实现
 * @Author: yjzhao
 * @Create: 2019-05-24  12:05
 **/
@Component
@Slf4j
public class IMailServiceImpl implements IMailService {
    @Autowired
    private JavaMailSender mailSender;
    @Value("${spring.mail.from}")
    private String from;
    @Autowired
    JsKycDictionaryService jsKycDictionaryService;

    /**
     * 发送文本邮件
     * @param to
     * @param subject
     * @param content
     */
    @Override
    public void sendSimpleMail(String to, String subject, String content) {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setFrom(from);
        message.setTo(to);
        message.setSubject(subject);
        message.setText(content);
        mailSender.send(message);
    }

    @Override
    public void sendRemindEmail(String subject,String content, EmailRemindTypeEnum emailRemindTypeEnum) {
        try {
            ResponseMessage responseMessage = jsKycDictionaryService.findDictionary(emailRemindTypeEnum.getType(), "");
            if (!responseMessage.isSuccess() || null == responseMessage.getData()) {
                log.error("获取{}发送邮件地址异常", emailRemindTypeEnum.getDesc());
                return;
            }
            ArrayList<Map<String, Object>> list = (ArrayList) responseMessage.getData();
            String toEmail = "";
            String[] ccList = new String[list.size() - 1];
            for (int i = 0; i < list.size(); i++) {
                Map<String, Object> valueMap = list.get(i);
                if (i == 0) {
                    toEmail = valueMap.get("code").toString();
                } else {
                    ccList[i - 1] = valueMap.get("code").toString();
                }
            }
            if (list.size() == 1) {
                sendSimpleMail(toEmail, subject, content);
            } else {
                sendSimpleMail(toEmail, subject, content, ccList);
            }
        }catch (Exception ex){
            log.error("发送提醒邮件异常:",ex);
        }
    }

    @Override
    public void sendSimpleMail(String to, String subject, String content, String... cc) {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setFrom(from);
        message.setTo(to);
        message.setCc(cc);
        message.setSubject(subject);
        message.setText(content);
        mailSender.send(message);
    }

    /**
     * 发送HTML邮件
     * @param to
     * @param subject
     * @param content
     */
    @Override
    public void sendHtmlMail(String to, String subject, String content) throws MessagingException {
        MimeMessage message = mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        helper.setFrom(from);
        helper.setTo(to);
        helper.setSubject(subject);
        helper.setText(content, true);

        mailSender.send(message);
    }

    /**
     * 发送模板范围内HTML邮件
     * @param to
     * @param subject
     * @param content
     */
    @Override
    public Boolean sendTemplateHtmlMail(String to, String subject, String content,String dearTitle){
        try {
            MimeMessage message = mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            StringBuffer sb = new StringBuffer("<!DOCTYPE html>")
                    .append("<html lang='en'><head><meta charset='UTF-8'><meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\"><meta http-equiv=\"X-UA-Compatible\" content=\"ie=edge\"><title>邮箱验证码</title></head>")
                    .append("<div style=\"padding: 20px;\">")
                    .append("<div style=\"width: 50%;min-width: 400px;margin: 0 auto;\">")
                    .append("<div style=\"margin: 0 20px;padding-bottom:20px;border-bottom: 1px solid #e2e2e2;\">")
                    .append("<img src=\"data:image/png;base64,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\" alt=\"\"></div>")
                    .append("<div style=\"padding-left: 40px;\">")
                    .append("<h3 style='margin: 30px 0;font-size: 24px;font-weight: normal;'>尊敬的&nbsp;<span style='color: #3d86e9;'>")
                    .append(dearTitle)
                    .append("</span>，您好！</h3>")
                    .append(content)
                    .append("</div>")
                    .append("<div style=\"height: 60px;line-height: 60px;font-size: 14px;font-weight: bold;text-align: center;background: #f7f7f7;\">如需帮助，可致电及时雨Pay客服热线：<span style=\"color: #3d86e9;\">400-687-3977</span></div>")
                    .append("</div></div></body></html>");
            helper.setFrom(from);
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(sb.toString(), true);
            mailSender.send(message);
        }catch (Exception ex){
            log.error("发送邮件异常:",ex);
            return false;
        }
        return true;
    }

    /**
     * 发送带附件的邮件
     * @param to
     * @param subject
     * @param content
     * @param filePath
     */
    @Override
    public void sendAttachmentsMail(String to, String subject, String content, String filePath) throws MessagingException {
        MimeMessage message = mailSender.createMimeMessage();

        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        helper.setFrom(from);
        helper.setTo(to);
        helper.setSubject(subject);
        helper.setText(content, true);

        FileSystemResource file = new FileSystemResource(new File(filePath));
        String fileName = filePath.substring(filePath.lastIndexOf(File.separator));
        helper.addAttachment(fileName, file);

        mailSender.send(message);
    }

    @Override
    public void sendAttachmentsMail(String to, String subject, String content, String filePath, String... cc) {

    }

    /**
     * 发送正文中有静态资源的邮件
     * @param to
     * @param subject
     * @param content
     * @param rscPath
     * @param rscId
     */
    @Override
    public void sendResourceMail(String to, String subject, String content, String rscPath, String rscId) throws MessagingException {
        MimeMessage message = mailSender.createMimeMessage();

        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        helper.setFrom(from);
        helper.setTo(to);
        helper.setSubject(subject);
        helper.setText(content, true);

        FileSystemResource res = new FileSystemResource(new File(rscPath));
        helper.addInline(rscId, res);

        mailSender.send(message);
    }

    @Override
    public void sendResourceMail(String to, String subject, String content, String rscPath, String rscId, String... cc) {

    }
}
