package com.js.web.service.impl;

import com.js.api.jsloan.service.qichacha.QiChaChaEnterpriseInfoService;
import com.js.api.jspay.service.ApiKycCertiContactsService;
import com.js.api.jspay.service.ApiKycCertiMainLandCompanyService;
import com.js.common.constant.Constant;
import com.js.common.enums.RegisterType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.KycCertiContactsReq;
import com.js.common.model.vo.KycCertiContactsVO;
import com.js.common.model.vo.KycCertiMainLandCompanyVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.EnterpriseInfoService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@Service
public class EnterpriseInfoServiceImpl implements EnterpriseInfoService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    QiChaChaEnterpriseInfoService qiChaChaEnterpriseInfoService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0
    )
    ApiKycCertiContactsService apiKycCertiContactsService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiKycCertiMainLandCompanyService apiKycCertiMainLandCompanyService;

    @Override
    public ResponseMessage getEnterpriseInfo(String kycNaturalId) {
        return qiChaChaEnterpriseInfoService.getEnterpriseInfo(kycNaturalId);
    }

    @Override
    public ResponseMessage getEnterprise25Partners(KycNaturalVO kycNaturalVO,String kycCertiId) {
        RegisterType registerType = kycNaturalVO.getRegisterType();
        if(!RegisterType.MAINLAND_COMPANY.equals(registerType)){
            log.error("{}注册类型不支持",registerType.getEnumName());
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),"注册类型不支持");
        }
        return qiChaChaEnterpriseInfoService.getEnterprise25Partners(kycNaturalVO.getId(), kycNaturalVO.getCertificationName());
    }

    @Override
    public ResponseMessage getEnterprisePartners2(KycNaturalVO kycNaturalVO) {
        RegisterType registerType = kycNaturalVO.getRegisterType();
        if(!RegisterType.MAINLAND_COMPANY.equals(registerType) && !RegisterType.HK_COMPANY.equals(registerType)){
            log.error("{}注册类型不支持",registerType.getEnumName());
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),"注册类型不支持");
        }
        KycCertiContactsReq kycCertiContactsReq = new KycCertiContactsReq();
        kycCertiContactsReq.setKycNaturalId(kycNaturalVO.getId());
        ResponseMessage kycCertiContacts = apiKycCertiContactsService.getKycCertiContacts(kycCertiContactsReq);
        if(!kycCertiContacts.isSuccess()){
            return kycCertiContacts;
        }
        List<KycCertiContactsVO> kycCertiContactsVOList = (List<KycCertiContactsVO>)kycCertiContacts.getData();
        List<Map<String,Object>> resultList = new ArrayList<>();
        if(RegisterType.HK_COMPANY.equals(registerType)){
            kycCertiContactsVOList.stream().forEach(KycCertiContactsVO -> {
                Map<String,Object> resultMap = new HashMap<>();
                String selStockName = KycCertiContactsVO.getContactName();
                resultMap.put("stockName",selStockName);
                resultMap.put("contractsId", KycCertiContactsVO.getId());
                resultMap.put("isNeed", false);
                resultList.add(resultMap);
            });
            return ResultUtil.success(resultList);
        }
        ResponseMessage responseMessage = apiKycCertiMainLandCompanyService.certiMainLandCompanySel(null, kycNaturalVO);
        if(!responseMessage.isSuccess()){
            return responseMessage;
        }
        KycCertiMainLandCompanyVO kycCertiMainLandCompanyVO = (KycCertiMainLandCompanyVO)responseMessage.getData();
        ResponseMessage enterprisePartners2 = qiChaChaEnterpriseInfoService.getEnterprisePartners2(kycNaturalVO.getId(), kycNaturalVO.getCertificationName());
        if(!enterprisePartners2.isSuccess()){
            return enterprisePartners2;
        }
        List<Map<String, Object>> list = (List<Map<String, Object>>)enterprisePartners2.getData();
        List<Map<String,Object>> filterList = list.stream().filter(map -> !map.get("stockName").equals(kycCertiMainLandCompanyVO.getLegalRepresentativeName())).collect(Collectors.toList());
        filterList.stream().forEach(map -> {
            Map<String,Object> resultMap = new HashMap<>();
            String selStockName = map.get("stockName").toString();
            resultMap.put("stockName",selStockName);
            List<KycCertiContactsVO> voFilterList = kycCertiContactsVOList.stream().filter(kycCertiContactsVO -> selStockName.toString().equals(kycCertiContactsVO.getContactName())).collect(Collectors.toList());
            String contractsId = CollectionUtils.isEmpty(voFilterList) ? "" : voFilterList.get(0).getId();
            resultMap.put("contractsId", contractsId);
            resultMap.put("isNeed", StringUtils.isBlank(contractsId) ? true : false);
            resultList.add(resultMap);
        });
        return ResultUtil.success(resultList);
    }

    @Override
    public ResponseMessage checkEnterpriseAndCreditCode(String kycNaturalId, String enterpriseName, String creditCode) {
        return qiChaChaEnterpriseInfoService.checkEnterpriseAndCreditCode(kycNaturalId, enterpriseName ,creditCode);
    }

    @Override
    public ResponseMessage getHasException(String kycNaturalId, String enterpriseName) {
        return qiChaChaEnterpriseInfoService.getHasException(kycNaturalId, enterpriseName);
    }
}
