package com.js.web.service;

import com.js.common.model.req.JsLoanStatisticsInfoReq;
import com.js.common.model.vo.common.ResponseMessage;

public interface StatisticsInfoService {

    /**
     * 根据用户 kycNaturalId 获取用户基本信息
     */
    ResponseMessage getBaseInfo(String kycNaturalId);

    /**
     * 根据用户 kycNaturalId 统计平台信息（实时的）
     */
    ResponseMessage getPlatformStatisticsInfo(String kycNaturalId);

    /**
     * 根据用户 kycNaturalId 获取目前最新的风控指标。
     */
    ResponseMessage getAmazonRiskQuota(String kycNaturalId);

    /**
     * 获取店铺列表
     */
    ResponseMessage getStoreList(JsLoanStatisticsInfoReq jsLoanStatisticsInfoReq);

    /**
     * 获取店铺
     */
    ResponseMessage getStore(String storeId);

    /**
     * 总店铺指标趋势
     */
    ResponseMessage getKycHis(String kycNaturalId);

}
