package com.js.web.service;

import com.js.common.model.req.JsLoanRiskInfoReq;
import com.js.common.model.vo.common.ResponseMessage;

/**
 * @Author zhouyongsheng
 * @Description 贷款准入
 * @Date 2019/6/1
 **/
public interface JsLoanRiskService {

    /**
     * 贷款准入
     * @param jsLoanRiskInfoReq
     * @return
     */
    ResponseMessage loanRisk(JsLoanRiskInfoReq jsLoanRiskInfoReq);

    /**
     * 贷款准入查询
     * @return
     * @throws Exception
     */
    ResponseMessage queryAccess(String kycNaturalId,int pageNum,int pageSize);

    /**
     * 贷款准入详情查询
     * @return
     * @throws Exception
     */
    ResponseMessage queryAccessDetails(String riskNo,String kycNaturalId);

    /**
     * 准入明细信息
     * @param kycNaturalId
     * @return
     */
    ResponseMessage queryLoanRisk(String kycNaturalId);

    /**
     * @Author zhouyongsheng
     * @Description 修改准入信息
     * @Date 2019/6/13
     **/
    ResponseMessage updateLoanRisk(JsLoanRiskInfoReq req);
}
