package com.js.web.controller.pay;

import com.js.common.constant.Constant;
import com.js.common.model.req.KycStoreReq;
import com.js.common.model.req.SunrateTradePriceReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycNaturalService;
import com.js.web.service.JsKycStoreService;
import com.js.web.service.SunrateTradePriceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.Date;
import java.util.Optional;

/**
 * @Author liuh
 * @Description 询价前后端交互controller
 * @Date 2019/5/29
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class SunrateTradePriceController {
    @Autowired
    private SunrateTradePriceService sunrateTradePriceService;
    @Autowired
    JsKycNaturalService jsKycNaturalService;

    /**
     * 询价-查询汇率
     * @Author liuh
     * @Date 2019/5/29
     */
    @GetMapping(value = Constant.ApiLoginAuth.AUTHC +"/xhTrade/queryPrice")
    public ResponseMessage xhTradeQueryPrice(@RequestParam String browserIP,HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return sunrateTradePriceService.xhTradeQueryPrice(browserIP,optionalKycNaturalVO.get());
    }
}
