package com.js.web.controller.pay;

import com.js.common.constant.Constant;
import com.js.common.model.req.CertiMainLandCompanyReq;
import com.js.common.model.req.KycCertiHKCompanyReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycCertiHKCompanyService;
import com.js.web.service.JsKycCertiMainLandCompanyService;
import com.js.web.service.JsKycNaturalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Optional;

/**
 * @Author liuh
 * @Description 香港企业前后端交互controller
 * @Date 2019/6/1
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE},
        consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class CertiHKCompanyController {

    @Autowired
    private JsKycCertiHKCompanyService jsKycCertiHKCompanyService;
    @Autowired
    JsKycNaturalService jsKycNaturalService;

    /**
     * 实名认证-大陆企业保存接口
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.AUTHC +"/certiHK/addCompany")
    public ResponseMessage certiHKCompanyAdd(@RequestBody KycCertiHKCompanyReq kycCertiHKCompanyReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycCertiHKCompanyService.certiHKCompanyAdd(kycCertiHKCompanyReq,optionalKycNaturalVO.get());
    }
}
