package com.js.web.controller.loan;

import com.js.common.constant.Constant;
import com.js.common.model.req.FadadaSignContractResultReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.FadadaService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;


/**
 * 法大大电子签章
 *
 * @author liutianyu
 */
@Slf4j
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE, MediaType.TEXT_HTML_VALUE})
public class FadadaController {

    @Autowired
    FadadaService fadadaService;

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/fadada/sign")
    public ResponseMessage sign(String jsLoanRiskInfoId, String jsLoanApplyInfoId) {
        return fadadaService.sign(jsLoanRiskInfoId, jsLoanApplyInfoId);
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/fadada/archiveContract2")
    public ResponseMessage archiveContract2(String kycNatualId, String loanNo) {
        return fadadaService.archiveContract2(kycNatualId, loanNo);
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/fadada/getSignStatus")
    public ResponseMessage getSignStatus(String loanNo) {
        return fadadaService.getSignStatus(loanNo);
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/fadada/getUnSignContractByLoanNo")
    public ResponseMessage getUnSignContractByLoanNo(String loanNo) {
        return fadadaService.getUnSignContractByLoanNo(loanNo);
    }

    @RequestMapping(value = Constant.ApiLoginAuth.ANON +"/fadada/getSignContractResultByReturnUrl",
            method = RequestMethod.GET, produces = {MediaType.TEXT_HTML_VALUE + ";charset=UTF-8"})
    public String getSignContractResultByReturnUrl(FadadaSignContractResultReq fadadaSignContractResultReq) {
        log.info("getSignContractResultByReturnUrl");
        fadadaService.getSignContractResultByReturnUrl(fadadaSignContractResultReq);
        // 直接将签署页关闭，可能会有兼容性问题
        return "<html><head><script type=text/javascript>" +
                "            (function close () {" +
                "                window.opener = null;" +
                "                window.open('', '_self');" +
                "                window.close();" +
                "            })()" +
                "        </script>" +
                "    </head>" +
                "</html>";
    }

    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/fadada/getSignContractResultByNotifyUrl")
    public void getSignContractResultByNotifyUrl(FadadaSignContractResultReq fadadaSignContractResultReq) {
        log.info("getSignContractResultByNotifyUrl");
        fadadaService.getSignContractResultByNotifyUrl(fadadaSignContractResultReq);
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/fadada/getContractViewUrl")
    public ResponseMessage getContractListByLoanNo(String loanNo) {
        return fadadaService.getContractViewUrl(loanNo);
    }

}
