package com.js.web.service.impl;

import com.js.api.jspay.service.ApiWaiHuiService;
import com.js.common.constant.Constant;
import com.js.common.model.vo.*;
import com.js.web.service.WaiHuiService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class WaiHuiServiceImpl implements WaiHuiService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    ApiWaiHuiService apiWaiHuiService;

    @Override
    public WaiHuiVO getWaiHuiInfo(String currency) {
        return apiWaiHuiService.getWaiHuiInfo(currency);
    }
}
