package com.js.web.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jsloan.service.ApiJsLoanRepaymentService;
import com.js.api.jspay.service.*;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.*;
import com.js.common.model.req.*;
import com.js.common.model.vo.*;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ReqNoUtil;
import com.js.common.util.ResultUtil;
import com.js.web.service.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Description: 预计算锁汇处理
 * @Author: liuh
 * @Create: 2019-09-11
 **/
@Slf4j
@Service
public class JsPaySunrateTradelockPricePreServiceImpl implements JsPaySunrateTradeLockPricePreService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 30000,
            retries = 0
    )
    ApiJsPaySunrateTradeLockPricePreService apiJsPaySunrateTradeLockPricePreService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 30000,
            retries = 0
    )
    ApiJsSystemHolidaysService apiJsSystemHolidaysService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 30000,
            retries = 0
    )
    private ApiJsLoanRepaymentService apiJsLoanRepaymentService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 30000,
            retries = 0
    )
    ApiJsKycChargeService apiJsKycChargeService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 30000
    )
    ApiSunrateTradePriceService apiSunrateTradePriceService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 30000
    )
    ApiJsPaySunrateTradeLockPriceService apiJsPaySunrateTradeLockPriceService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 30000
    )
    ApiSunrateBeneficiaryService apiSunrateBeneficiaryService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 30000
    )
    ApiJsPaySunrateBankService apiJsPaySunrateBankService;
    @Autowired
    WaiHuiService waiHuiService;
    @Autowired
    IMailService iMailService;

    public void exeRefund(JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq,JsPaySunrateBankVO jsPaySunrateBankVO){
        String kycNaturalId = jsPaySunrateBankVO.getKycNaturalId();
        ResponseMessage responseMessage = apiJsLoanRepaymentService.queryVerificationLoan(kycNaturalId);
        log.info("查询贷款记录返回结果:{}",responseMessage);
        if(!responseMessage.isSuccess()){
            log.info("用户{}未查询到需要还款的记录信息",kycNaturalId);
            return;
        }
        JSONObject shouldRefundInfo = (JSONObject)responseMessage.getData();
//        Date startDate = shouldRefundInfo.getDate("startDate");
//        if(startDate.compareTo(new Date()) > 0){
//            log.info("当前日期小于应还最早起始日期:{}",startDate);
//            return;
//        }
        ResponseMessage exeResponseMessage = exeRefundDetail(shouldRefundInfo,jsPaySunrateBankVO,jsPaySunrateBankTradeInReq);
        if(!exeResponseMessage.isSuccess()){
            String loanNo = shouldRefundInfo.getString("loanNo");
            iMailService.sendRemindEmail("loanNo:" + loanNo + "自动还款处理失败提醒",exeResponseMessage.getMsg(), EmailRemindTypeEnum.WARN_EMAIL);
        }
    }

    private ResponseMessage exeRefundDetail(JSONObject shouldRefundInfo,JsPaySunrateBankVO jsPaySunrateBankVO,JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq){
        String kycNaturalId = jsPaySunrateBankVO.getKycNaturalId();
        BigDecimal plannedTotal = shouldRefundInfo.getBigDecimal("plannedTotal");
        log.info("开始处理还款操作kycNaturalId：{},应还总额：{}",kycNaturalId,plannedTotal);
        WaiHuiVO waiHuiVO = waiHuiService.getWaiHuiInfo(jsPaySunrateBankVO.getCurId());
        if(null == waiHuiVO){
            log.error("接口查询汇率信息返回不存在，currency:{}",jsPaySunrateBankVO.getCurId());
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST.getCode(),"接口查询汇率信息返回不存在，currency:" + jsPaySunrateBankVO.getCurId());
        }
        BigDecimal huiIn = waiHuiVO.getHuiIn();
        boolean dealFlag = true;//apiJsSystemHolidaysService.dealFlag();
        JsKycChargeReq jsKycChargeReq = new JsKycChargeReq();
        jsKycChargeReq.setKycNaturalId(jsPaySunrateBankVO.getKycNaturalId());
        jsKycChargeReq.setChargeType("SERVICE_CHARGE");
        JsKycChargeVO jsKycChargeVO = apiJsKycChargeService.findKycChargeInfo(jsKycChargeReq);
        BigDecimal serviceCharge = null == jsKycChargeVO ? SiteEnum.getByCurrency(jsPaySunrateBankVO.getCurId()).getJsTradeServiceChargeValue() : jsKycChargeVO.getChargeScale();

        JsKycChargeReq jsKycChargeRateReq = new JsKycChargeReq();
        jsKycChargeRateReq.setKycNaturalId(jsPaySunrateBankVO.getKycNaturalId());
        jsKycChargeRateReq.setChargeType("RATE");
        JsKycChargeVO jsKycChargeRateVO = apiJsKycChargeService.findKycChargeInfo(jsKycChargeRateReq);
        BigDecimal useRate = null == jsKycChargeRateVO ? huiIn.setScale(4,BigDecimal.ROUND_HALF_UP) : jsKycChargeRateVO.getChargeScale().add(huiIn).setScale(4,BigDecimal.ROUND_HALF_UP);

        BigDecimal scaleTransinAmt = jsPaySunrateBankTradeInReq.getTransinAmt().multiply(new BigDecimal(0.35)).setScale(2,BigDecimal.ROUND_HALF_UP);
        BigDecimal txnAmt = scaleTransinAmt.compareTo(CommonConstant.SURATE_TRADE_MIN_AMT) < 0 ? CommonConstant.SURATE_TRADE_MIN_AMT : scaleTransinAmt;
        if(!dealFlag){
            useRate = useRate.subtract(new BigDecimal(0.2));
        }
        BigDecimal backSellAmt = plannedTotal.divide(useRate,2,BigDecimal.ROUND_UP);
        BigDecimal backTotalAmt = serviceCharge.compareTo(new BigDecimal(0)) > 0 ? backSellAmt.divide(new BigDecimal(1).subtract(serviceCharge),2,BigDecimal.ROUND_HALF_UP) : new BigDecimal(0);
        BigDecimal backServiceChargeAmt = backTotalAmt.subtract(backSellAmt);
        log.info("plannedTotal：{}，backTotalAmt：{}，backSellAmt：{}，backServiceChargeAmt：{}",plannedTotal,backTotalAmt,backSellAmt,backServiceChargeAmt);
        if(backTotalAmt.compareTo(CommonConstant.SURATE_TRADE_MIN_AMT) < 0){
            log.error("plannedTotal：{},backTotalAmt：{}，小于最小交易金额",plannedTotal,backTotalAmt);
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"应还金额：" + plannedTotal + "外币金金额：" + backTotalAmt + "小于最小交易金额");

        }
        List<KycSunrateBeneficiaryVO> kycSunrateBeneficiaryVOS = apiSunrateBeneficiaryService.beneficiaryListByOrgCode(jsPaySunrateBankVO.getOrgCode(),BeneficiaryTypeEnum.PLATEFORM_SELF ,CommonConstant.TRADE_CURRENCY_CNH);
        if(CollectionUtils.isEmpty(kycSunrateBeneficiaryVOS)){
            log.error("查询受益人信息不存在，orgCode:{}",jsPaySunrateBankVO.getOrgCode());
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"查询受益人信息不存在，orgCode:" + jsPaySunrateBankVO.getOrgCode());
        }
        KycSunrateBeneficiaryVO kycSunrateBeneficiaryVO = kycSunrateBeneficiaryVOS.get(0);
        String loanNo = shouldRefundInfo.getString("loanNo");
        BigDecimal serviceChargeAmt = txnAmt.multiply(serviceCharge).setScale(2,BigDecimal.ROUND_HALF_UP);
        BigDecimal sellAmt = txnAmt.subtract(serviceChargeAmt);
        BigDecimal refundAmt = sellAmt.multiply(useRate).setScale(2,BigDecimal.ROUND_HALF_UP);
        if(refundAmt.compareTo(plannedTotal) > 0){
            refundAmt = plannedTotal;
            sellAmt = backSellAmt;
            serviceChargeAmt = backServiceChargeAmt;
            txnAmt = sellAmt.add(serviceChargeAmt);
        }
        log.info("refundAmt：{}，sellAmt：{}，serviceChargeAmt：{}",refundAmt,sellAmt,serviceChargeAmt);
        ResponseMessage loanApplyInitResult = apiJsLoanRepaymentService.loanApplyInit(loanNo, refundAmt, CommonConstant.LOAN_REPAYMENT_STATUS_ACTIVE);
        log.info("loanNo:{}锁定借款信息返回结果：{}",loanNo,loanApplyInitResult);
        if(!loanApplyInitResult.isSuccess()){
            log.error("锁定借款信息失败");
            StringBuffer stringBuffer = new StringBuffer().append("锁定借款信息失败-").append(loanApplyInitResult.getMsg()).append(";入参:loanNo-").append(loanNo)
                    .append(";refundAmt-").append(refundAmt).append(";repaymentStatus-").append(CommonConstant.LOAN_REPAYMENT_STATUS_ACTIVE);
            return ResultUtil.error(ResultEnum.ERROR.getCode(), stringBuffer.toString());
        }
        if(dealFlag){
            log.info("交易日自动还款操作");
            apiJsPaySunrateBankService.freezeAmt(jsPaySunrateBankVO.getId(),txnAmt);
            JsPaySunrateTradeMarketOrderReq jsPaySunrateTradeMarketOrderReq = new JsPaySunrateTradeMarketOrderReq();
            jsPaySunrateTradeMarketOrderReq.setOrgCode(jsPaySunrateBankVO.getOrgCode());
            jsPaySunrateTradeMarketOrderReq.setSubAcctNo(jsPaySunrateBankVO.getSubAcctNo());
            jsPaySunrateTradeMarketOrderReq.setBuyCur(CommonConstant.TRADE_CURRENCY_CNH );
            jsPaySunrateTradeMarketOrderReq.setSellCur(jsPaySunrateBankVO.getCurId());
            jsPaySunrateTradeMarketOrderReq.setTxnAmt(txnAmt);
            jsPaySunrateTradeMarketOrderReq.setValueDate(DateUtil.format(new Date(),"yyyy-MM-dd"));
            jsPaySunrateTradeMarketOrderReq.setTradeType(TradeTypeEnum.TRADE_REPAYMENT);
            jsPaySunrateTradeMarketOrderReq.setTradeSubType(TradeSubTypeEnum.REPAYMENT_AUTOMATIC);
            jsPaySunrateTradeMarketOrderReq.setTxnMode(CommonConstant.TXN_MODE_SELL);
            jsPaySunrateTradeMarketOrderReq.setBeneficiaryId(kycSunrateBeneficiaryVO.getBeneficiaryId());//受益人编号
            jsPaySunrateTradeMarketOrderReq.setBatchNo(ReqNoUtil.getReqNo());
            jsPaySunrateTradeMarketOrderReq.setSunrateBankAvailableBalance(jsPaySunrateBankVO.getAvailableBalance().subtract(txnAmt));
            jsPaySunrateTradeMarketOrderReq.setSunrateBankCurrentBalance(jsPaySunrateBankVO.getFreezedBalance().add(txnAmt));
            jsPaySunrateTradeMarketOrderReq.setUseRate(useRate);
            jsPaySunrateTradeMarketOrderReq.setRefundAmt(refundAmt);
            jsPaySunrateTradeMarketOrderReq.setServiceCharge(serviceCharge);
            jsPaySunrateTradeMarketOrderReq.setStoreTheSite(SiteEnum.getByCurrency(jsPaySunrateBankVO.getCurId()));
            jsPaySunrateTradeMarketOrderReq.setJsRemark("寻汇入账触发自动还款(交易日)插入记录");
            ResponseMessage responseMessage = apiJsPaySunrateTradeLockPriceService.tradeMarketOrder(jsPaySunrateTradeMarketOrderReq, jsPaySunrateBankVO.getKycNaturalId(), jsPaySunrateBankVO.getKycSunrateStoreId(), jsPaySunrateBankVO.getId());
            log.info("交易日请求寻汇返回结果：{}",responseMessage);
            if(responseMessage.isSuccess()){
                ResponseMessage loanApplyResult = apiJsLoanRepaymentService.loanApplyResult(loanNo, true, null);
                log.info("loanNo:{}通知锁汇结果接口返回信息：{}",loanNo,loanApplyResult);
                if(!loanApplyResult.isSuccess()){
                    return ResultUtil.error(ResultEnum.ERROR.getCode(),"通知锁汇结果接口返回信息：" + loanApplyResult);
                }
            }else{
                return ResultUtil.error(ResultEnum.ERROR.getCode(),"寻汇入账触发自动还款(交易日)处理失败：" + JSON.toJSONString(jsPaySunrateTradeMarketOrderReq) + ";处理返回结果：" + responseMessage);
            }
        }else{
            log.info("非交易日自动还款操作");
            BigDecimal buyAmt = refundAmt;
            BigDecimal serviceChargeAmtBuy = serviceChargeAmt.multiply(useRate).setScale(2,BigDecimal.ROUND_HALF_UP);
            JsPaySunrateTradeLockPricePreReq jsPaySunrateTradeLockPricePreReq = new JsPaySunrateTradeLockPricePreReq();
            jsPaySunrateTradeLockPricePreReq.setTradeType(TradeTypeEnum.TRADE_REPAYMENT);
            jsPaySunrateTradeLockPricePreReq.setTradeSubType(TradeSubTypeEnum.REPAYMENT_AUTOMATIC);
            jsPaySunrateTradeLockPricePreReq.setBatchNo(ReqNoUtil.getReqNo());
            jsPaySunrateTradeLockPricePreReq.setKycSunrateBankId(jsPaySunrateBankVO.getId());
            jsPaySunrateTradeLockPricePreReq.setUseRate(useRate);
            jsPaySunrateTradeLockPricePreReq.setServiceCharge(serviceCharge);
            jsPaySunrateTradeLockPricePreReq.setTransinNoticeId(jsPaySunrateBankTradeInReq.getTransinNoticeId());
            jsPaySunrateTradeLockPricePreReq.setLoanNo(loanNo);
            jsPaySunrateTradeLockPricePreReq.setTxnAmt(txnAmt);
            jsPaySunrateTradeLockPricePreReq.setSellAmt(sellAmt);
            jsPaySunrateTradeLockPricePreReq.setBuyAmt(buyAmt);
            jsPaySunrateTradeLockPricePreReq.setChargeAmt(serviceChargeAmt);
            jsPaySunrateTradeLockPricePreReq.setChargeAmtBuy(serviceChargeAmtBuy);
            jsPaySunrateTradeLockPricePreReq.setRefundAmt(refundAmt);
            jsPaySunrateTradeLockPricePreReq.setBeneficiaryId(kycSunrateBeneficiaryVO.getBeneficiaryId());
            jsPaySunrateTradeLockPricePreReq.setJsRemark("寻汇入账触发自动还款(非交易日)插入记录");
            ResponseMessage lockPricePreResult = apiJsPaySunrateTradeLockPricePreService.lockPricePre(jsPaySunrateTradeLockPricePreReq);
            log.info("执行预算预锁汇操作返回结果：{}",lockPricePreResult);
            if(lockPricePreResult.isSuccess()){
                ResponseMessage loanApplyResult = apiJsLoanRepaymentService.loanApplyResult(loanNo, true, null);
                log.info("loanNo:{}通知锁汇结果接口返回信息：{}",loanNo,loanApplyResult);
                if(!loanApplyResult.isSuccess()){
                    return ResultUtil.error(ResultEnum.ERROR.getCode(),"通知锁汇结果接口返回信息：" + loanApplyResult);
                }
            }else{
                return ResultUtil.error(ResultEnum.ERROR.getCode(),"寻汇入账触发自动还款(非交易日)处理失败：" + JSON.toJSONString(jsPaySunrateTradeLockPricePreReq));
            }
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }
}
